/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.little.registry;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.util.filter.Filter;
import team.creative.creativecore.common.util.filter.premade.BlockFilters;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3c;
import team.creative.littletiles.common.block.little.registry.LittleBlockRegistry;
import team.creative.littletiles.common.block.little.registry.LittleMCBlock;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.collection.LittleCollection;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.entity.PrimedSizedTnt;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVec;

public class LittleBlocks {
    public static void init() {
        LittleBlockRegistry.register((Filter<Block>)BlockFilters.block((Block)Blocks.BARRIER), x -> new LittleMCBlock((Block)x){

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void randomDisplayTick(IParentCollection parent, LittleTile tile, RandomSource rand) {
                Minecraft mc = Minecraft.getInstance();
                ItemStack itemstack = mc.player.getMainHandItem();
                if (mc.player.isCreative() && itemstack.is(Blocks.BARRIER.asItem())) {
                    mc.level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK_MARKER, tile.getState()), (double)parent.getPos().getX() + 0.5, (double)parent.getPos().getY() + 0.5, (double)parent.getPos().getZ() + 0.5, 0.0, 0.0, 0.0);
                }
            }
        });
        LittleBlockRegistry.register((Filter<Block>)BlockFilters.instance(TntBlock.class), x -> new LittleMCBlock((Block)x){

            @Override
            public boolean canInteract() {
                return true;
            }

            @Override
            public InteractionResult use(IParentCollection parent, LittleTile tile, LittleBox box, Player player, BlockHitResult result) {
                ItemStack heldItem = player.getMainHandItem();
                if (heldItem.is(Items.FLINT_AND_STEEL) || heldItem.is(Items.FIRE_CHARGE)) {
                    if (!parent.isClient()) {
                        this.explodeBox(parent, box, (Entity)player, false);
                    }
                    parent.getBE().updateTiles(x -> tile.remove((LittleCollection)x.get(parent), box));
                    if (heldItem.getItem() == Items.FLINT_AND_STEEL) {
                        heldItem.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)InteractionHand.MAIN_HAND));
                    } else if (!player.isCreative()) {
                        heldItem.shrink(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.PASS;
            }

            @Override
            public void exploded(IParentCollection parent, LittleTile tile, Explosion explosion) {
                for (LittleBox box : tile) {
                    this.explodeBox(parent, box, explosion.getDirectSourceEntity(), true);
                }
            }

            public void explodeBox(IParentCollection parent, LittleBox box, Entity entity, boolean randomFuse) {
                BlockPos pos = parent.getPos();
                LittleVec size = box.getSize();
                LittleVec min = box.getMinVec();
                LittleGrid grid = parent.getGrid();
                PrimedSizedTnt entitytntprimed = new PrimedSizedTnt(parent.getLevel(), (double)pos.getX() + min.getPosX(grid) + size.getPosX(grid) / 2.0, (double)pos.getY() + min.getPosY(grid) + size.getPosY(grid) / 2.0, (double)pos.getZ() + min.getPosZ(grid) + size.getPosZ(grid) / 2.0, entity instanceof LivingEntity ? (LivingEntity)entity : null, grid, size);
                if (randomFuse) {
                    entitytntprimed.setFuse((short)(parent.getLevel().random.nextInt(entitytntprimed.getFuse() / 4) + entitytntprimed.getFuse() / 8));
                }
                parent.getLevel().addFreshEntity((Entity)entitytntprimed);
                parent.getLevel().playSound((Player)null, entitytntprimed.getX(), entitytntprimed.getY(), entitytntprimed.getZ(), SoundEvents.TNT_PRIMED, SoundSource.BLOCKS, 1.0f, 1.0f);
                parent.getLevel().gameEvent(entity, (Holder)GameEvent.PRIME_FUSE, parent.getPos());
            }
        });
        LittleBlockRegistry.register((Filter<Block>)BlockFilters.block((Block)Blocks.CRAFTING_TABLE), x -> new LittleMCBlock((Block)x){

            @Override
            public boolean canInteract() {
                return true;
            }

            @Override
            public InteractionResult use(IParentCollection parent, LittleTile tile, LittleBox box, Player player, BlockHitResult result) {
                if (parent.isClient()) {
                    return InteractionResult.SUCCESS;
                }
                player.openMenu(this.getState().getMenuProvider(parent.getLevel(), parent.getPos()));
                player.awardStat(Stats.INTERACT_WITH_CRAFTING_TABLE);
                return InteractionResult.CONSUME;
            }
        });
        LittleBlockRegistry.register((Filter<Block>)BlockFilters.property((Property)BlockStateProperties.AXIS), x -> new LittleMCBlock((Block)x){

            @Override
            public BlockState transform(BlockState state, IntMatrix3c matrix, LittleVec doubledCenter) {
                return (BlockState)state.setValue((Property)BlockStateProperties.AXIS, (Comparable)Axis.get((Direction.Axis)((Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS))).transform(matrix).toVanilla());
            }
        });
        LittleBlockRegistry.register((Filter<Block>)BlockFilters.property((Property)BlockStateProperties.FACING), x -> new LittleMCBlock((Block)x){

            @Override
            public BlockState transform(BlockState state, IntMatrix3c matrix, LittleVec doubledCenter) {
                return (BlockState)state.setValue((Property)BlockStateProperties.FACING, (Comparable)Facing.get((Direction)((Direction)state.getValue((Property)BlockStateProperties.FACING))).transform(matrix).toVanilla());
            }
        });
        LittleBlockRegistry.register((Filter<Block>)BlockFilters.instance(LeavesBlock.class), x -> new LittleMCBlock((Block)x){

            @Override
            public boolean cullOverEdge() {
                return false;
            }
        });
    }
}

