/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.little.tile.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.box.RenderBox;
import team.creative.creativecore.common.util.math.box.AlignedBox;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3c;
import team.creative.creativecore.common.util.mc.LanguageUtils;
import team.creative.creativecore.common.util.type.Bunch;
import team.creative.creativecore.common.util.type.itr.FunctionIterator;
import team.creative.creativecore.common.util.type.itr.IterableIterator;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.collection.LittleCollection;
import team.creative.littletiles.common.grid.IGridBased;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleBoxGrid;
import team.creative.littletiles.common.math.box.volume.LittleVolumes;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecGrid;
import team.creative.littletiles.common.placement.box.LittlePlaceBox;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.attribute.LittleStructureAttribute;
import team.creative.littletiles.common.structure.connection.children.ItemChildrenList;
import team.creative.littletiles.common.structure.registry.LittleStructureRegistry;

public class LittleGroup
implements Bunch<LittleTile>,
IGridBased {
    public static final String PARENT_KEY = "k";
    public static final String CHILDREN_KEY = "c";
    public static final String STRUCTURE_KEY = "s";
    public static final String EXTENSION_KEY = "e";
    public static final String EXTENSION_ID_KEY = "eid";
    public static final String TILES_KEY = "t";
    public static final String TRANSLUCENT_KEY = "trans";
    public static final String MIN_KEY = "min";
    public static final String SIZE_KEY = "size";
    public static final String TILES_COUNT_KEY = "tiles";
    public static final String BOXES_COUNT_KEY = "boxes";
    protected CompoundTag structure;
    protected LittleCollection content = new LittleCollection();
    public final ItemChildrenList children;
    private LittleGrid grid;

    public static Component printTooltip(CompoundTag tag) {
        StringBuilder text = new StringBuilder();
        if (tag.contains(TILES_COUNT_KEY) && tag.contains(BOXES_COUNT_KEY)) {
            text.append(tag.getInt(TILES_COUNT_KEY) + " " + LanguageUtils.translate((String)"gui.tile.count") + " " + tag.getInt(BOXES_COUNT_KEY) + " " + LanguageUtils.translate((String)"gui.box.count"));
        }
        return Component.literal((String)text.toString());
    }

    public static void advancedScale(LittleGroup group, int from, int to) {
        group.advancedScale(from, to);
    }

    @Deprecated
    public static void setGridSecretly(LittleGroup previews, LittleGrid grid) {
        if (previews.hasStructure()) {
            previews.getStructureType().advancedScale(previews, grid.count, previews.grid.count);
        }
        previews.grid = grid;
        if (previews.hasChildren()) {
            for (LittleGroup child : previews.children.all()) {
                LittleGroup.setGridSecretly(child, grid);
            }
        }
    }

    public static boolean shouldRenderInHand(CompoundTag nbt) {
        int count = nbt.getInt(BOXES_COUNT_KEY);
        return count > 0 && count < LittleTiles.CONFIG.building.lowResolutionBoxCount;
    }

    public static LittleGroup loadLow(CompoundTag nbt) {
        if (nbt.getInt(BOXES_COUNT_KEY) > LittleTiles.CONFIG.building.lowResolutionBoxCount) {
            LittleGroup group = new LittleGroup();
            LittleVecGrid max = LittleGroup.getSize(nbt);
            LittleVecGrid min = LittleGroup.getMin(nbt);
            max.add(min);
            min.forceSameGrid((IGridBased)max);
            group.addTile(min.getGrid(), new LittleTile(Blocks.STONE.defaultBlockState(), -1, new LittleBox(min.getVec(), max.getVec())));
            return group;
        }
        return LittleGroup.load(nbt);
    }

    public static LittleGroup load(CompoundTag nbt) {
        ListTag list = nbt.getList(CHILDREN_KEY, 10);
        ArrayList<LittleGroup> children = new ArrayList<LittleGroup>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            children.add(LittleGroup.load(list.getCompound(i)));
        }
        CompoundTag structure = nbt.getCompound(STRUCTURE_KEY);
        if (structure.isEmpty()) {
            structure = null;
        }
        LittleGroup group = new LittleGroup(structure, children);
        group.convertTo(LittleGrid.get(nbt));
        LittleCollection.load(group.content, nbt.getCompound(TILES_KEY));
        CompoundTag extensions = nbt.getCompound(EXTENSION_KEY);
        for (String id : extensions.getAllKeys()) {
            group.children.addExtension(id, LittleGroup.load(extensions.getCompound(id)));
        }
        return group;
    }

    public static CompoundTag saveChild(LittleGroup group) {
        CompoundTag nbt = new CompoundTag();
        if (group.hasStructure()) {
            nbt.put(STRUCTURE_KEY, (Tag)group.getStructureTag());
        }
        nbt.put(TILES_KEY, (Tag)LittleCollection.save(group.content));
        group.grid.set(nbt);
        ListTag list = new ListTag();
        for (LittleGroup child : group.children.children()) {
            list.add((Object)LittleGroup.saveChild(child));
        }
        if (!list.isEmpty()) {
            nbt.put(CHILDREN_KEY, (Tag)list);
        }
        CompoundTag extensions = new CompoundTag();
        for (Map.Entry entry : group.children.extensionEntries()) {
            extensions.put(entry.getKey(), (Tag)LittleGroup.saveChild((LittleGroup)entry.getValue()));
        }
        if (!extensions.isEmpty()) {
            nbt.put(EXTENSION_KEY, (Tag)extensions);
        }
        return nbt;
    }

    public static CompoundTag save(LittleGroup group) {
        CompoundTag nbt = LittleGroup.saveChild(group);
        group.getSize().save(SIZE_KEY, nbt);
        group.getMinVec().save(MIN_KEY, nbt);
        nbt.putInt(TILES_COUNT_KEY, group.totalTiles());
        nbt.putInt(BOXES_COUNT_KEY, group.totalBoxes());
        if (group.hasTranslucentBlocks()) {
            nbt.putBoolean(TRANSLUCENT_KEY, true);
        }
        return nbt;
    }

    public static LittleVecGrid getSize(CompoundTag nbt) {
        if (nbt.contains(SIZE_KEY)) {
            return new LittleVecGrid(new LittleVec(SIZE_KEY, nbt), LittleGrid.get(nbt));
        }
        return null;
    }

    public static LittleVecGrid getMin(CompoundTag nbt) {
        if (nbt.contains(MIN_KEY)) {
            return new LittleVecGrid(new LittleVec(MIN_KEY, nbt), LittleGrid.get(nbt));
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void shrinkCubesToOneBlock(List<? extends RenderBox> cubes) {
        float sizeZ;
        float sizeY;
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float minZ = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        for (RenderBox renderBox : cubes) {
            minX = Math.min(minX, renderBox.minX);
            minY = Math.min(minY, renderBox.minY);
            minZ = Math.min(minZ, renderBox.minZ);
            maxX = Math.max(maxX, renderBox.maxX);
            maxY = Math.max(maxY, renderBox.maxY);
            maxZ = Math.max(maxZ, renderBox.maxZ);
        }
        float scale = 1.0f;
        float f = maxX - minX;
        if (f > 1.0f) {
            scale = Math.min(scale, 1.0f / f);
        }
        if ((sizeY = maxY - minY) > 1.0f) {
            scale = Math.min(scale, 1.0f / sizeY);
        }
        if ((sizeZ = maxZ - minZ) > 1.0f) {
            scale = Math.min(scale, 1.0f / sizeZ);
        }
        float offsetX = (minX + maxX) * -0.5f;
        float offsetY = (minY + maxY) * -0.5f;
        float offsetZ = (minZ + maxZ) * -0.5f;
        for (RenderBox renderBox : cubes) {
            renderBox.add(offsetX, offsetY, offsetZ);
            renderBox.scale(scale);
            renderBox.add(0.5f, 0.5f, 0.5f);
        }
    }

    public LittleGroup() {
        this((CompoundTag)null, (List<LittleGroup>)Collections.EMPTY_LIST);
    }

    public LittleGroup(CompoundTag structure, List<LittleGroup> children) {
        this.grid = LittleGrid.MIN;
        this.structure = structure;
        this.children = new ItemChildrenList(this, children);
        this.convertToSmallest();
    }

    public LittleGroup(LittleGroup group, List<LittleGroup> children) {
        this.grid = group.getGrid();
        this.structure = group.structure;
        this.content = group.content;
        this.children = new ItemChildrenList(this, children);
        this.convertToSmallest();
    }

    public LittleGroup(CompoundTag nbt, LittleGroup group, List<LittleGroup> children) {
        this.grid = group.getGrid();
        this.structure = nbt;
        this.content = group.content;
        this.children = new ItemChildrenList(this, children);
        this.convertToSmallest();
    }

    public LittleGroup getParent() {
        return (LittleGroup)this.children.getParent();
    }

    public boolean hasParent() {
        return this.children.hasParent();
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean hasStructure() {
        return this.structure != null;
    }

    public boolean hasStructureIncludeChildren() {
        if (this.hasStructure()) {
            return true;
        }
        for (LittleGroup child : this.children.all()) {
            if (!child.hasStructureIncludeChildren()) continue;
            return true;
        }
        return false;
    }

    public String getStructureName() {
        if (!this.hasStructure()) {
            return null;
        }
        return this.structure.contains("name") ? this.structure.getString("name") : null;
    }

    public String getStructureId() {
        if (this.hasStructure()) {
            return this.structure.getString("id");
        }
        return null;
    }

    public LittleStructureType getStructureType() {
        if (this.hasStructure()) {
            return (LittleStructureType)LittleStructureRegistry.REGISTRY.get(this.structure.getString("id"));
        }
        return null;
    }

    public CompoundTag getStructureTag() {
        return this.structure;
    }

    public boolean transformable() {
        for (LittleGroup child : this.children.all()) {
            if (child.transformable()) continue;
            return false;
        }
        return true;
    }

    public boolean containsIngredients() {
        if (this.hasStructure()) {
            return !LittleStructureAttribute.premade(this.getStructureType().attribute);
        }
        return true;
    }

    public void move(LittleVecGrid vec) {
        if (!this.transformable()) {
            throw new RuntimeException("Cannot transform group with links");
        }
        this.forceSameGrid(vec);
        for (LittleBox box : this.boxes()) {
            box.add(vec.getVec());
        }
        if (this.hasStructure()) {
            this.getStructureType().move(this, vec);
        }
        if (this.hasChildren()) {
            for (LittleGroup child : this.children.all()) {
                child.move(vec);
            }
        }
    }

    public void transform(IntMatrix3c matrix, LittleVec doubledCenter) {
        if (!this.transformable()) {
            throw new RuntimeException("Cannot transform group with links");
        }
        Iterator<LittleTile> iterator = this.iterator();
        while (iterator.hasNext()) {
            LittleTile tile = iterator.next();
            tile.transform(matrix, doubledCenter);
        }
        if (this.hasStructure()) {
            this.getStructureType().transform(this, this.getGrid(), matrix, doubledCenter);
        }
        if (this.hasChildren()) {
            for (LittleGroup child : this.children.all()) {
                child.transform(matrix, doubledCenter);
            }
        }
    }

    @Override
    public LittleGrid getGrid() {
        return this.grid;
    }

    @Override
    public void convertToSmallest() {
        this.convertTo(LittleGrid.get(this.getSmallest()));
    }

    @Override
    public int getSmallest() {
        int size = LittleGrid.MIN.count;
        Iterator<LittleTile> iterator = this.iterator();
        while (iterator.hasNext()) {
            LittleTile tile = iterator.next();
            size = Math.max(size, tile.getSmallest(this.grid));
        }
        LittleGrid context = LittleGrid.get(size);
        if (this.hasStructure()) {
            context = LittleGrid.max(context, this.getStructureType().getMinContext(this));
        }
        size = context.count;
        if (this.hasChildren()) {
            for (LittleGroup child : this.children.all()) {
                size = Math.max(child.getSmallest(), size);
            }
        }
        return size;
    }

    @Override
    public void convertTo(LittleGrid to) {
        if (this.grid != to) {
            Iterator<LittleTile> iterator = this.iterator();
            while (iterator.hasNext()) {
                LittleTile tile = iterator.next();
                tile.convertTo(this.grid, to);
            }
        }
        if (this.hasChildren()) {
            for (LittleGroup child : this.children.all()) {
                child.convertTo(to);
            }
        }
        this.grid = to;
    }

    public LittleGroup copyExceptChildren() {
        LittleGroup group = new LittleGroup(this.structure != null ? this.structure.copy() : null, (List<LittleGroup>)Collections.EMPTY_LIST);
        for (Map.Entry extension : this.children.extensionEntries()) {
            group.children.addExtension(extension.getKey(), ((LittleGroup)extension.getValue()).copy());
        }
        group.addAll(this.grid, (Iterable<LittleTile>)new FunctionIterator((Iterable)((Object)this), x -> x.copy()));
        return group;
    }

    public LittleGroup copy() {
        ArrayList<LittleGroup> newChildren = new ArrayList<LittleGroup>();
        for (LittleGroup group : this.children.children()) {
            newChildren.add(group.copy());
        }
        LittleGroup group = new LittleGroup(this.structure != null ? this.structure.copy() : null, newChildren);
        for (Map.Entry extension : this.children.extensionEntries()) {
            group.children.addExtension(extension.getKey(), ((LittleGroup)extension.getValue()).copy());
        }
        group.addAll(this.grid, (Iterable<LittleTile>)new FunctionIterator((Iterable)((Object)this), x -> x.copy()));
        return group;
    }

    public Iterator<LittleTile> iterator() {
        return this.content.iterator();
    }

    public Iterable<LittleTile> allTiles() {
        if (this.hasChildren()) {
            return new IterableIterator<LittleTile>(){
                public Iterator<LittleTile> subIterator;
                public Iterator<LittleGroup> children;
                {
                    this.subIterator = LittleGroup.this.iterator();
                    this.children = LittleGroup.this.children.all().iterator();
                }

                public boolean hasNext() {
                    while (!this.subIterator.hasNext()) {
                        if (!this.children.hasNext()) {
                            return false;
                        }
                        this.subIterator = this.children.next().allTiles().iterator();
                    }
                    return true;
                }

                public LittleTile next() {
                    return this.subIterator.next();
                }

                public void remove() {
                    this.subIterator.remove();
                }
            };
        }
        return this;
    }

    public Iterable<LittleBox> allBoxes() {
        return new IterableIterator<LittleBox>(){
            public Iterator<LittleBox> subIterator = null;
            public Iterator<LittleTile> children = LittleGroup.this.allTiles().iterator();

            public boolean hasNext() {
                while (this.subIterator == null || !this.subIterator.hasNext()) {
                    if (!this.children.hasNext()) {
                        return false;
                    }
                    this.subIterator = this.children.next().iterator();
                }
                return true;
            }

            public LittleBox next() {
                return this.subIterator.next();
            }

            public void remove() {
                this.subIterator.remove();
            }
        };
    }

    public double getVolume() {
        double volume = 0.0;
        Iterator<LittleTile> iterator = this.iterator();
        while (iterator.hasNext()) {
            LittleTile tile = iterator.next();
            volume += tile.getPercentVolume(this.grid);
        }
        return volume;
    }

    public double getVolumeIncludingChildren() {
        double volume = this.getVolume();
        for (LittleGroup child : this.children.all()) {
            volume += child.getVolumeIncludingChildren();
        }
        return volume;
    }

    public LittleVolumes getVolumes() {
        LittleVolumes volumes = new LittleVolumes(this.grid);
        volumes.add(this);
        return volumes;
    }

    public LittleVolumes getVolumesIncludingChildren() {
        LittleVolumes volume = this.getVolumes();
        for (LittleGroup child : this.children.all()) {
            volume.add(child.getVolumesIncludingChildren());
        }
        return volume;
    }

    public void combineBlockwise() {
        this.content.combineBlockwise(this.grid);
        if (this.hasChildren()) {
            for (LittleGroup child : this.children.all()) {
                child.combineBlockwise();
            }
        }
    }

    public void advancedScale(int from, int to) {
        for (LittleBox box : this.boxes()) {
            box.convertTo(from, to);
        }
        if (this.hasStructure()) {
            this.getStructureType().advancedScale(this, from, to);
        }
        if (this.hasChildren()) {
            for (LittleGroup child : this.children.all()) {
                child.advancedScale(from, to);
            }
        }
    }

    public boolean isEmptyIncludeChildren() {
        if (!this.isEmpty()) {
            return false;
        }
        for (LittleGroup child : this.children.all()) {
            if (child.isEmptyIncludeChildren()) continue;
            return false;
        }
        return true;
    }

    public Iterable<LittleBox> boxes() {
        return this.content.boxes();
    }

    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    public int size() {
        return this.content.size();
    }

    public int boxesCount() {
        return this.content.boxesCount();
    }

    public int totalTiles() {
        if (!this.hasChildren()) {
            return this.size();
        }
        int size = this.size();
        for (LittleGroup child : this.children.all()) {
            size += child.totalTiles();
        }
        return size;
    }

    public int totalBoxes() {
        if (!this.hasChildren()) {
            return this.boxesCount();
        }
        int size = this.boxesCount();
        for (LittleGroup child : this.children.all()) {
            size += child.totalBoxes();
        }
        return size;
    }

    public LittleBox getSurroundingBox() {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (LittleBox box : this.allBoxes()) {
            minX = Math.min(minX, box.minX);
            minY = Math.min(minY, box.minY);
            minZ = Math.min(minZ, box.minZ);
            maxX = Math.max(maxX, box.maxX);
            maxY = Math.max(maxY, box.maxY);
            maxZ = Math.max(maxZ, box.maxZ);
        }
        return new LittleBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public LittleVec getMinVec() {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (LittleBox box : this.allBoxes()) {
            minX = Math.min(minX, box.minX);
            minY = Math.min(minY, box.minY);
            minZ = Math.min(minZ, box.minZ);
            maxX = Math.max(maxX, box.maxX);
            maxY = Math.max(maxY, box.maxY);
            maxZ = Math.max(maxZ, box.maxZ);
        }
        return new LittleVec(minX, minY, minZ);
    }

    public LittleVec getSize() {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (LittleBox box : this.allBoxes()) {
            minX = Math.min(minX, box.minX);
            minY = Math.min(minY, box.minY);
            minZ = Math.min(minZ, box.minZ);
            maxX = Math.max(maxX, box.maxX);
            maxY = Math.max(maxY, box.maxY);
            maxZ = Math.max(maxZ, box.maxZ);
        }
        return new LittleVec(maxX - minX, maxY - minY, maxZ - minZ);
    }

    public void removeOffset() {
        LittleVec min = this.getMinVec();
        min.x = this.grid.toGrid(this.grid.toBlockOffset(min.x));
        min.y = this.grid.toGrid(this.grid.toBlockOffset(min.y));
        min.z = this.grid.toGrid(this.grid.toBlockOffset(min.z));
        min.invert();
        this.move(new LittleVecGrid(min, this.grid));
    }

    public List<LittlePlaceBox> getSpecialBoxes() {
        if (this.hasStructure()) {
            return this.getStructureType().getSpecialBoxes(this);
        }
        return Collections.EMPTY_LIST;
    }

    public void add(LittleGroup group) {
        this.sameGrid(group, () -> this.content.addAll((Iterable<LittleTile>)((Object)group)));
    }

    public void addTileFast(LittleGrid grid, LittleTile tile) {
        if (grid != this.grid) {
            if (grid.count > this.grid.count) {
                this.convertTo(grid);
            } else {
                tile.convertTo(grid, this.grid);
            }
        }
        this.content.add(tile);
    }

    public void addTile(LittleGrid grid, LittleTile tile) {
        this.addTileFast(grid, tile);
        this.convertToSmallest();
    }

    public void addAll(LittleGrid grid, Iterable<LittleTile> tiles) {
        boolean needsConvert = false;
        if (grid != this.grid) {
            if (grid.count > this.grid.count) {
                this.convertTo(grid);
            } else {
                needsConvert = true;
            }
        }
        for (LittleTile tile : tiles) {
            if (needsConvert) {
                tile.convertTo(grid, this.grid);
            }
            this.content.add(tile);
        }
        this.convertToSmallest();
    }

    public void add(LittleGrid grid, LittleElement element, Iterable<LittleBox> boxes) {
        if (grid != this.grid) {
            if (grid.count > this.grid.count) {
                this.convertTo(grid);
            } else {
                for (LittleBox box : boxes) {
                    box.convertTo(grid, this.grid);
                }
            }
        }
        this.content.add(element, boxes);
        this.convertToSmallest();
    }

    public void addFast(LittleGrid grid, LittleElement element, LittleBox box) {
        if (grid != this.grid) {
            if (grid.count > this.grid.count) {
                this.convertTo(grid);
            } else {
                box.convertTo(grid, this.grid);
            }
        }
        this.content.add(element, box);
    }

    public void add(LittleBoxGrid box, LittleElement element) {
        this.add(box.getGrid(), element, box.getBox().copy());
    }

    public void add(LittleGrid grid, LittleElement element, LittleBox box) {
        this.addFast(grid, element, box);
        this.convertToSmallest();
    }

    public void combine(boolean optimized) {
        this.content.combine(this.grid, optimized);
    }

    public Set<BlockPos> getPositions(BlockPos pos) {
        HashSet<BlockPos> positions = new HashSet<BlockPos>();
        for (LittleBox box : this.allBoxes()) {
            positions.add(box.getMinVec().getBlockPos(this.grid).offset((Vec3i)pos));
        }
        return positions;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<RenderBox> getPlaceBoxes(LittleVec offset) {
        ArrayList<RenderBox> boxes = new ArrayList<RenderBox>();
        this.addPlaceBoxes(boxes, offset);
        return boxes;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void addPlaceBoxes(List<RenderBox> boxes, LittleVec offset) {
        List<LittlePlaceBox> structureBoxes;
        for (Object tile : this.content) {
            ((LittleTile)tile).addPlaceBoxes(this.grid, boxes, offset);
        }
        if (this.hasStructure() && (structureBoxes = this.getStructureType().getSpecialBoxes(this)) != null) {
            for (LittlePlaceBox box : structureBoxes) {
                boxes.add(box.getRenderBox(this.grid, offset));
            }
        }
        for (LittleGroup child : this.children.all()) {
            child.addPlaceBoxes(boxes, offset);
        }
    }

    public boolean hasTranslucentBlocks() {
        for (LittleTile tile : this.content) {
            if (!tile.isTranslucent()) continue;
            return true;
        }
        if (this.hasStructure() && this.getStructureType().hasTranslucentItemPreview(this)) {
            return true;
        }
        for (LittleGroup child : this.children.all()) {
            if (!child.hasTranslucentBlocks()) continue;
            return true;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<RenderBox> getRenderingBoxes(boolean translucent) {
        ArrayList<RenderBox> boxes = new ArrayList<RenderBox>();
        if (this.totalBoxes() > LittleTiles.CONFIG.rendering.itemLowResolutionBoxCount) {
            LittleVec size = this.getSize();
            boxes.add(new RenderBox(new AlignedBox(0.0f, 0.0f, 0.0f, (float)size.getPosX(this.grid), (float)size.getPosY(this.grid), (float)size.getPosZ(this.grid)), (Block)LittleTilesRegistry.CLEAN.value()));
        } else {
            this.addRenderingBoxes(boxes, translucent, !this.hasChildren());
        }
        return boxes;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void addRenderingBoxes(List<RenderBox> boxes, boolean translucent, boolean itemPreview) {
        List<RenderBox> structureBoxes;
        for (LittleTile tile : this.content) {
            if (tile.isTranslucent() != translucent) continue;
            tile.addRenderingBoxes(this.grid, boxes);
        }
        if (this.hasStructure() && itemPreview && (structureBoxes = this.getStructureType().getItemPreview(this, translucent)) != null) {
            boxes.addAll(structureBoxes);
        }
        for (LittleGroup child : this.children.all()) {
            child.addRenderingBoxes(boxes, translucent, false);
        }
    }

    public boolean isVolumeEqual(LittleGroup previews) {
        return this.getVolumes().equals(previews.getVolumes());
    }
}

