/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.mc;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.block.entity.BESignalConverter;

public class BlockSignalConverter
extends BaseEntityBlock {
    public static final DirectionProperty HORIZONTAL_FACING = BlockStateProperties.HORIZONTAL_FACING;

    public BlockSignalConverter() {
        super(BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(1.5f, 6.0f));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return null;
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation rotation) {
        return (BlockState)state.setValue((Property)HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)HORIZONTAL_FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return (BlockState)state.setValue((Property)HORIZONTAL_FACING, (Comparable)mirror.mirror((Direction)state.getValue((Property)HORIZONTAL_FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HORIZONTAL_FACING});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)HORIZONTAL_FACING, (Comparable)context.getHorizontalDirection());
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos origin, boolean p_60514_) {
        super.neighborChanged(state, level, pos, block, origin, p_60514_);
        this.changed((LevelReader)level, pos);
    }

    public void onNeighborChange(BlockState state, LevelReader level, BlockPos pos, BlockPos neighbor) {
        super.onNeighborChange(state, level, pos, neighbor);
        this.changed(level, pos);
    }

    public void changed(LevelReader level, BlockPos pos) {
        Optional result = level.getBlockEntity(pos, (BlockEntityType)LittleTilesRegistry.BE_SIGNALCONVERTER_TYPE.get());
        if (result.isEmpty()) {
            return;
        }
        Direction direction = (Direction)level.getBlockState(pos).getValue((Property)HORIZONTAL_FACING);
        if (!level.isClientSide()) {
            ((BESignalConverter)result.get()).setPower(BlockSignalConverter.getPowerOnSide(level, pos.relative(direction.getOpposite()), direction));
        }
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction side) {
        Optional result;
        if (state.getValue((Property)HORIZONTAL_FACING) == side.getOpposite() && (result = level.getBlockEntity(pos, (BlockEntityType)LittleTilesRegistry.BE_SIGNALCONVERTER_TYPE.get())).isPresent()) {
            return ((BESignalConverter)result.get()).getPower();
        }
        return 0;
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, Direction direction) {
        return state.getValue((Property)HORIZONTAL_FACING) == direction;
    }

    public static int getPowerOnSide(LevelReader level, BlockPos pos, Direction side) {
        BlockState iblockstate = level.getBlockState(pos);
        if (iblockstate.isSignalSource()) {
            return level.getDirectSignal(pos, side);
        }
        return 0;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new BESignalConverter(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }
}

