/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import team.creative.creativecore.common.level.IOrientatedLevel;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.entity.INoPushEntity;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.connection.ILevelPositionProvider;
import team.creative.littletiles.common.structure.connection.children.StructureChildConnection;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.type.LittleChair;

public class EntitySit
extends Entity
implements ILevelPositionProvider,
INoPushEntity {
    public static final EntityDataAccessor<CompoundTag> CONNECTION = SynchedEntityData.defineId(EntitySit.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);
    public static final EntityDataAccessor<Float> CHAIRX = SynchedEntityData.defineId(EntitySit.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> CHAIRY = SynchedEntityData.defineId(EntitySit.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    public static final EntityDataAccessor<Float> CHAIRZ = SynchedEntityData.defineId(EntitySit.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private StructureChildConnection temp;

    public EntitySit(LittleChair chair, Level level, double x, double y, double z) {
        super((EntityType)LittleTilesRegistry.SIT_TYPE.get(), level);
        this.entityData.set(CHAIRX, (Object)Float.valueOf((float)x));
        this.entityData.set(CHAIRY, (Object)Float.valueOf((float)y));
        this.entityData.set(CHAIRZ, (Object)Float.valueOf((float)z));
        this.temp = chair.children.generateConnection(this);
        this.entityData.set(CONNECTION, (Object)this.temp.save(new CompoundTag()));
        this.setPos(x, y, z);
    }

    public EntitySit(EntityType<? extends EntitySit> type, Level level) {
        super(type, level);
        this.noPhysics = true;
    }

    public boolean isPushable() {
        return false;
    }

    public void tick() {
        super.tick();
        StructureChildConnection connection = StructureChildConnection.load(this, (CompoundTag)this.entityData.get(CONNECTION), false);
        if (!this.level().isClientSide && !this.isVehicle()) {
            try {
                LittleStructure structure = connection.getStructure();
                if (structure instanceof LittleChair) {
                    ((LittleChair)structure).setPlayer(null);
                }
                this.kill();
            }
            catch (CorruptedConnectionException | NotYetConnectedException structure) {}
        } else {
            try {
                LittleStructure structure = connection.getStructure();
                Level level = structure.getStructureLevel();
                if (level instanceof IOrientatedLevel) {
                    IOrientatedLevel l = (IOrientatedLevel)level;
                    Vec3d vec = new Vec3d((double)((Float)this.entityData.get(CHAIRX)).floatValue(), (double)((Float)this.entityData.get(CHAIRY)).floatValue(), (double)((Float)this.entityData.get(CHAIRZ)).floatValue());
                    l.getOrigin().transformPointToWorld(vec);
                    this.setPos(vec.x, vec.y, vec.z);
                }
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                // empty catch block
            }
        }
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return this.position();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(CONNECTION, (Object)new CompoundTag());
        builder.define(CHAIRX, (Object)Float.valueOf(0.0f));
        builder.define(CHAIRY, (Object)Float.valueOf(0.0f));
        builder.define(CHAIRZ, (Object)Float.valueOf(0.0f));
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
        nbt.put("connection", (Tag)this.entityData.get(CONNECTION));
        nbt.putFloat("chairX", ((Float)this.entityData.get(CHAIRX)).floatValue());
        nbt.putFloat("chairY", ((Float)this.entityData.get(CHAIRY)).floatValue());
        nbt.putFloat("chairZ", ((Float)this.entityData.get(CHAIRZ)).floatValue());
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
        this.entityData.set(CONNECTION, (Object)nbt.getCompound("connection"));
        this.entityData.set(CHAIRX, (Object)Float.valueOf(nbt.getFloat("chairX")));
        this.entityData.set(CHAIRY, (Object)Float.valueOf(nbt.getFloat("chairY")));
        this.entityData.set(CHAIRZ, (Object)Float.valueOf(nbt.getFloat("chairZ")));
    }

    @Override
    public Level getStructureLevel() {
        return this.level();
    }

    @Override
    public BlockPos getStructurePos() {
        return BlockPos.ZERO;
    }

    @Override
    public void structureDestroyed() {
    }
}

