/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.level.Level;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.mixin.common.entity.PrimedTntAccessor;

public class PrimedSizedTnt
extends PrimedTnt {
    private static final EntityDataAccessor<String> TNTSIZE = SynchedEntityData.defineId(PrimedSizedTnt.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public LittleGrid grid;
    public LittleVec size;

    public PrimedSizedTnt(EntityType<? extends PrimedSizedTnt> type, Level level) {
        super(type, level);
    }

    public PrimedSizedTnt(Level level, double x, double y, double z, @Nullable LivingEntity igniter, LittleGrid grid, LittleVec size) {
        super((EntityType)LittleTilesRegistry.SIZED_TNT_TYPE.get(), level);
        this.setPos(x, y, z);
        double d0 = level.random.nextDouble() * 6.2831854820251465;
        this.setDeltaMovement(-Math.sin(d0) * 0.02, 0.2f, -Math.cos(d0) * 0.02);
        this.setFuse(80);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        ((PrimedTntAccessor)((Object)this)).setOwner(igniter);
        this.setSize(grid, size);
        this.refreshDimensions();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(TNTSIZE, (Object)"1.1.1.1");
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        this.size.save("size", tag);
        this.grid.set(tag);
        super.addAdditionalSaveData(tag);
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.size = new LittleVec("size", tag);
        this.grid = LittleGrid.get(tag);
        super.readAdditionalSaveData(tag);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        if (TNTSIZE.equals(key)) {
            String data = (String)this.entityData.get(TNTSIZE);
            String[] coords = data.split("\\.");
            this.size = new LittleVec(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]));
            this.grid = LittleGrid.get(Integer.parseInt(coords[3]));
        }
        super.onSyncedDataUpdated(key);
    }

    public void setSize(LittleGrid grid, LittleVec size) {
        this.entityData.set(TNTSIZE, (Object)(size.x + "." + size.y + "." + size.z + "." + grid.count));
        this.size = size;
        this.grid = grid;
    }

    protected void explode() {
        this.level().explode((Entity)this, this.getX(), this.getY(0.0625), this.getZ(), (float)(4.0 * this.size.getPercentVolume(this.grid)), Level.ExplosionInteraction.TNT);
    }
}

