/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity.animation;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.client.render.entity.LittleAnimationRenderManager;
import team.creative.littletiles.client.render.entity.LittleEntityRenderManager;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.entity.OrientationAwareEntity;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntityPhysic;
import team.creative.littletiles.common.entity.animation.LittleAnimationLevel;
import team.creative.littletiles.common.level.little.LittleSubLevel;
import team.creative.littletiles.common.math.location.LocalStructureLocation;
import team.creative.littletiles.common.packet.entity.animation.LittleAnimationInitPacket;
import team.creative.littletiles.common.packet.entity.animation.LittleBlockChange;
import team.creative.littletiles.common.placement.Placement;
import team.creative.littletiles.common.placement.PlacementResult;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.connection.children.StructureChildConnection;
import team.creative.littletiles.common.structure.connection.direct.StructureConnection;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.relative.StructureAbsolute;

public class LittleAnimationEntity
extends LittleEntity<LittleAnimationEntityPhysic> {
    private StructureAbsolute center;
    private StructureConnection structure;

    public static void loadBE(LevelAccessor level, CompoundTag nbt, boolean update) {
        BlockState state = BlockTile.getState(nbt.getBoolean("ticking"), nbt.getBoolean("rendered"));
        BlockPos pos = BlockEntity.getPosFromTag((CompoundTag)nbt);
        level.setBlock(pos, state, 0);
        BlockEntity entity = level.getBlockEntity(pos);
        if (entity instanceof BETiles) {
            BETiles be = (BETiles)entity;
            if (be.isClient()) {
                be.handleUpdate(nbt, !update);
                if (!update) {
                    be.render.tilesChanged();
                }
            } else {
                be.loadWithComponents(nbt, (HolderLookup.Provider)level.registryAccess());
                if (update) {
                    be.updateTiles(false, true);
                }
            }
        }
    }

    public static CompoundTag saveBE(BETiles tiles) {
        CompoundTag nbt = tiles.saveWithFullMetadata((HolderLookup.Provider)tiles.getLevel().registryAccess());
        nbt.putBoolean("ticking", tiles.isTicking());
        nbt.putBoolean("rendered", tiles.isRendered());
        return nbt;
    }

    public LittleAnimationEntity(EntityType<?> type, Level level) {
        super(type, level);
    }

    public LittleAnimationEntity(Level level, LittleAnimationLevel subLevel, StructureAbsolute center, Placement placement) throws LittleActionException {
        super((EntityType)LittleTilesRegistry.ENTITY_ANIMATION.get(), level, subLevel, center.rotationCenter);
        this.setCenter(center);
        this.beforeInitalPlacement();
        PlacementResult result = placement.place();
        if (result == null) {
            throw new LittleActionException("Could not be placed");
        }
        this.structure = new StructureConnection((Level)subLevel, new LocalStructureLocation(result.parentStructure));
        ((LittleAnimationEntityPhysic)this.physic).tick();
        ((LittleAnimationEntityPhysic)this.physic).updateBoundingBox();
    }

    protected void beforeInitalPlacement() {
        if (this.level().isClientSide) {
            this.getSubLevel().renderManager = LittleAnimationRenderManager.of(this);
        }
    }

    @Override
    protected LittleSubLevel createLevel() {
        return new LittleAnimationLevel(this.level());
    }

    @Override
    public LittleAnimationLevel getSubLevel() {
        return (LittleAnimationLevel)super.getSubLevel();
    }

    public void setCenter(StructureAbsolute center) {
        this.center = center;
        if (this.getOrigin() != null) {
            this.getOrigin().setCenter(center.rotationCenter);
        }
        for (OrientationAwareEntity entity : this.children()) {
            entity.parentVecOriginChange(this.origin);
        }
    }

    public void setParentLevel(Level subLevel) {
        this.setLevel(subLevel);
        this.getSubLevel().setParent(subLevel);
        this.getSubLevel().setOrigin(this.center.rotationCenter);
        if (this.origin != null) {
            this.getSubLevel().getOrigin().set(this.origin);
        }
        this.origin = this.subLevel.getOrigin();
        this.hasOriginChanged = true;
    }

    public StructureAbsolute getCenter() {
        return this.center;
    }

    public boolean is(LittleStructure structure) {
        return this.structure.is(structure);
    }

    public LittleStructure getStructure() throws CorruptedConnectionException, NotYetConnectedException {
        return this.structure.getStructure();
    }

    public void applyChanges(Iterable<LittleBlockChange> changes) {
        for (LittleBlockChange change : changes) {
            if (change.isEmpty()) {
                this.subLevel.removeBlock(change.pos(), true);
                continue;
            }
            LittleAnimationEntity.loadBE((LevelAccessor)this.subLevel, change.block(), true);
        }
    }

    protected void loadBlocks(CompoundTag nbt) {
        LittleAnimationLevel level = this.getSubLevel();
        ListTag blocks = nbt.getList("b", 10);
        for (int i = 0; i < blocks.size(); ++i) {
            LittleAnimationEntity.loadBE((LevelAccessor)level, blocks.getCompound(i), false);
        }
    }

    protected void saveBlocks(CompoundTag nbt) {
        ListTag blocks = new ListTag();
        for (BETiles block : this.getSubLevel()) {
            blocks.add((Object)LittleAnimationEntity.saveBE(block));
        }
        nbt.put("b", (Tag)blocks);
    }

    @Override
    protected Vec3d loadCenter(CompoundTag nbt) {
        this.center = new StructureAbsolute("c", nbt);
        return this.center.rotationCenter;
    }

    @Override
    public void loadEntity(CompoundTag nbt) {
        this.setCenter(this.center);
        this.loadBlocks(nbt);
        this.structure = new StructureConnection((Level)this.subLevel, nbt.getCompound("s"));
    }

    @Override
    public void saveEntity(CompoundTag nbt) {
        nbt.put("s", (Tag)this.structure.write());
        this.center.save("c", nbt);
        this.saveBlocks(nbt);
    }

    @Override
    public CreativePacket initClientPacket() {
        return new LittleAnimationInitPacket(this);
    }

    public CompoundTag saveExtraClientData() {
        CompoundTag nbt = new CompoundTag();
        nbt.put("physic", (Tag)((LittleAnimationEntityPhysic)this.physic).save());
        this.saveBlocks(nbt);
        nbt.put("st", (Tag)this.structure.write());
        return nbt;
    }

    @Override
    public void prepareChangeLevel(Level oldLevel, Level newLevel) {
        this.setParentLevel(newLevel);
        try {
            StructureChildConnection parent = this.getStructure().getParent();
            if (parent != null) {
                parent.clearCache();
            }
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initSubLevelClient(StructureAbsolute absolute, CompoundTag extraData) {
        if (this.changedLevel) {
            this.changedLevel = false;
            return;
        }
        this.setSubLevel(new LittleAnimationLevel(this.level()), absolute.rotationCenter);
        this.setCenter(absolute);
        ((LittleAnimationLevel)this.subLevel).renderManager = LittleAnimationRenderManager.of(this);
        this.loadBlocks(extraData);
        ((LittleAnimationEntityPhysic)this.physic).load(extraData.getCompound("physic"));
        this.structure = new StructureConnection((Level)this.subLevel, extraData.getCompound("st"));
        ((LittleAnimationEntityPhysic)this.physic).updateBoundingBox();
    }

    @Override
    public void performTick() {
        super.performTick();
        if (!this.level().isClientSide && this.getSubLevel().isEmpty()) {
            this.destroyAnimation();
        }
    }

    @Override
    public void internalTick() {
    }

    @Override
    public void initialTick() {
        this.getSubLevel().initialTick();
    }

    @Override
    protected LittleAnimationEntityPhysic createPhysic() {
        return new LittleAnimationEntityPhysic(this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public LittleEntityRenderManager getRenderManager() {
        return ((LittleAnimationLevel)this.subLevel).renderManager;
    }

    @Override
    public void syncMovement() {
    }

    @Override
    public void startTracking(ServerPlayer player) {
        this.getSubLevel().entityCallback.addTrackingPlayer(player);
    }

    @Override
    public void stopTracking(ServerPlayer player) {
        this.getSubLevel().entityCallback.removeTrackingPlayer(player);
    }

    public void clearTrackingChanges() {
        this.getSubLevel().clearTrackingChanges();
    }

    @Override
    public boolean noClip() {
        try {
            LittleStructure s;
            LittleStructure littleStructure = this.getStructure();
            return littleStructure instanceof LittleStructure && (s = littleStructure).entityNoClip();
        }
        catch (CorruptedConnectionException | NotYetConnectedException e) {
            return false;
        }
    }
}

