/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity.animation;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.util.AbortableIterationConsumer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.entity.EntityInLevelCallback;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;

public class LittleAnimationLevelEntities
implements LevelEntityGetter<Entity> {
    private final Int2ObjectMap<Entity> byId = new Int2ObjectLinkedOpenHashMap();
    private final LevelCallback<Entity> callbacks;
    private final Map<UUID, Entity> byUuid = Maps.newHashMap();

    public LittleAnimationLevelEntities(LevelCallback<Entity> callback) {
        this.callbacks = callback;
    }

    public boolean addNewEntity(Entity entity) {
        return this.addEntity(entity, false);
    }

    public boolean addNewEntityWithoutEvent(Entity entity) {
        return this.addEntityWithoutEvent(entity, false);
    }

    private boolean addEntity(Entity entity, boolean loadedFromDisk) {
        if (((EntityJoinLevelEvent)NeoForge.EVENT_BUS.post((Event)new EntityJoinLevelEvent(entity, entity.level(), loadedFromDisk))).isCanceled()) {
            return false;
        }
        return this.addEntityWithoutEvent(entity, loadedFromDisk);
    }

    private boolean addEntityWithoutEvent(Entity entity, boolean loadedFromDisk) {
        try {
            this.byUuid.putIfAbsent(entity.getUUID(), entity);
            this.byId.put(entity.getId(), (Object)entity);
            entity.setLevelCallback((EntityInLevelCallback)new Callback(entity));
            if (!loadedFromDisk) {
                this.callbacks.onCreated((Object)entity);
            }
            this.startTracking(entity);
            this.startTicking(entity);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public Entity get(int id) {
        return (Entity)this.byId.get(id);
    }

    public Entity get(UUID uuid) {
        return this.byUuid.get(uuid);
    }

    public Iterable<Entity> getAll() {
        return this.byId.values();
    }

    void startTicking(Entity entity) {
        this.callbacks.onTickingStart((Object)entity);
    }

    void stopTicking(Entity entity) {
        this.callbacks.onTickingEnd((Object)entity);
    }

    void startTracking(Entity entity) {
        this.callbacks.onTrackingStart((Object)entity);
    }

    void stopTracking(Entity entity) {
        this.callbacks.onTrackingEnd((Object)entity);
    }

    public <U extends Entity> void get(EntityTypeTest<Entity, U> test, AbortableIterationConsumer<U> consumer) {
        for (Entity entity : this.byId.values()) {
            Entity u = (Entity)test.tryCast((Object)entity);
            if (u == null || !consumer.accept((Object)u).shouldAbort()) continue;
            return;
        }
    }

    public void get(AABB bb, Consumer<Entity> consumer) {
        for (Entity entity : this.byId.values()) {
            if (!entity.getBoundingBox().intersects(bb)) continue;
            consumer.accept(entity);
        }
    }

    public <U extends Entity> void get(EntityTypeTest<Entity, U> test, AABB bb, AbortableIterationConsumer<U> consumer) {
        for (Entity entity : this.byId.values()) {
            Entity u = (Entity)test.tryCast((Object)entity);
            if (u == null || !entity.getBoundingBox().intersects(bb) || !consumer.accept((Object)u).shouldAbort()) continue;
            return;
        }
    }

    public void removeAll() {
        ArrayList<Entity> all = new ArrayList<Entity>(this.byUuid.values());
        for (Entity entity : all) {
            entity.setRemoved(Entity.RemovalReason.UNLOADED_WITH_PLAYER);
        }
    }

    class Callback
    implements EntityInLevelCallback {
        private final Entity entity;

        Callback(Entity entity) {
            this.entity = entity;
        }

        public void onMove() {
        }

        public void onRemove(Entity.RemovalReason remove) {
            LittleAnimationLevelEntities.this.stopTicking(this.entity);
            LittleAnimationLevelEntities.this.stopTracking(this.entity);
            if (remove.shouldDestroy()) {
                LittleAnimationLevelEntities.this.callbacks.onDestroyed((Object)this.entity);
            }
            this.entity.setLevelCallback(NULL);
            LittleAnimationLevelEntities.this.byUuid.remove(this.entity.getUUID());
            LittleAnimationLevelEntities.this.byId.remove(this.entity.getId());
        }
    }
}

