/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.entity.particle;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import team.creative.creativecore.common.util.mc.LanguageUtils;
import team.creative.littletiles.common.entity.particle.LittleParticle;
import team.creative.littletiles.common.entity.particle.LittleParticleRenderType;

public enum LittleParticleTexture {
    dust_fade_out(ResourceLocation.withDefaultNamespace((String)"smoke"), LittleParticleRenderType.PARTICLE_SHEET_OPAQUE){

        @Override
        public void init(LittleParticle particle) {
        }

        @Override
        public void tick(LittleParticle particle) {
            particle.setSpriteFromAge(particle.sprites);
        }
    }
    ,
    dust(ResourceLocation.withDefaultNamespace((String)"smoke"), LittleParticleRenderType.PARTICLE_SHEET_OPAQUE){

        @Override
        public void init(LittleParticle particle) {
            particle.pickSprite(particle.sprites);
        }

        @Override
        public void tick(LittleParticle particle) {
        }
    }
    ,
    dust_grow(ResourceLocation.withDefaultNamespace((String)"smoke"), LittleParticleRenderType.PARTICLE_SHEET_OPAQUE){

        @Override
        public void init(LittleParticle particle) {
        }

        @Override
        public void tick(LittleParticle particle) {
            particle.setSpriteFromAgeReverse(particle.sprites);
        }
    }
    ,
    bubble(ResourceLocation.withDefaultNamespace((String)"bubble"), LittleParticleRenderType.PARTICLE_SHEET_OPAQUE){

        @Override
        public void init(LittleParticle particle) {
            particle.pickSprite(particle.sprites);
        }

        @Override
        public void tick(LittleParticle particle) {
        }
    }
    ,
    diamond(ResourceLocation.withDefaultNamespace((String)"totem_of_undying"), LittleParticleRenderType.PARTICLE_SHEET_TRANSLUCENT){

        @Override
        public void init(LittleParticle particle) {
            particle.pickSprite(particle.sprites);
        }

        @Override
        public void tick(LittleParticle particle) {
        }
    }
    ,
    spark(ResourceLocation.withDefaultNamespace((String)"firework"), LittleParticleRenderType.PARTICLE_SHEET_TRANSLUCENT){

        @Override
        public void init(LittleParticle particle) {
            particle.setSpriteFirst(particle.sprites);
        }

        @Override
        public void tick(LittleParticle particle) {
        }
    }
    ,
    spark_fade_out(ResourceLocation.withDefaultNamespace((String)"firework"), LittleParticleRenderType.PARTICLE_SHEET_TRANSLUCENT){

        @Override
        public void init(LittleParticle particle) {
        }

        @Override
        public void tick(LittleParticle particle) {
            particle.setSpriteFromAge(particle.sprites);
        }
    }
    ,
    spiral(ResourceLocation.withDefaultNamespace((String)"entity_effect"), LittleParticleRenderType.PARTICLE_SHEET_TRANSLUCENT){

        @Override
        public void init(LittleParticle particle) {
        }

        @Override
        public void tick(LittleParticle particle) {
            particle.setSpriteFromAge(particle.sprites);
        }
    }
    ,
    note(ResourceLocation.withDefaultNamespace((String)"note"), LittleParticleRenderType.PARTICLE_SHEET_OPAQUE){

        @Override
        public void init(LittleParticle particle) {
            particle.pickSprite(particle.sprites);
        }

        @Override
        public void tick(LittleParticle particle) {
        }
    }
    ,
    flame(ResourceLocation.withDefaultNamespace((String)"flame"), LittleParticleRenderType.PARTICLE_SHEET_OPAQUE){

        @Override
        public void init(LittleParticle particle) {
            particle.pickSprite(particle.sprites);
        }

        @Override
        public void tick(LittleParticle particle) {
        }
    }
    ,
    happy(ResourceLocation.withDefaultNamespace((String)"happy_villager"), LittleParticleRenderType.PARTICLE_SHEET_OPAQUE){

        @Override
        public void init(LittleParticle particle) {
            particle.pickSprite(particle.sprites);
        }

        @Override
        public void tick(LittleParticle particle) {
        }
    }
    ,
    angry(ResourceLocation.withDefaultNamespace((String)"angry_villager"), LittleParticleRenderType.PARTICLE_SHEET_OPAQUE){

        @Override
        public void init(LittleParticle particle) {
            particle.pickSprite(particle.sprites);
        }

        @Override
        public void tick(LittleParticle particle) {
        }
    }
    ,
    damage(ResourceLocation.withDefaultNamespace((String)"damage_indicator"), LittleParticleRenderType.PARTICLE_SHEET_OPAQUE){

        @Override
        public void init(LittleParticle particle) {
            particle.pickSprite(particle.sprites);
        }

        @Override
        public void tick(LittleParticle particle) {
        }
    }
    ,
    letter(ResourceLocation.withDefaultNamespace((String)"enchant"), LittleParticleRenderType.PARTICLE_SHEET_OPAQUE){

        @Override
        public void init(LittleParticle particle) {
            particle.pickSprite(particle.sprites);
        }

        @Override
        public void tick(LittleParticle particle) {
        }
    }
    ,
    dripping(ResourceLocation.withDefaultNamespace((String)"dripping_water"), LittleParticleRenderType.PARTICLE_SHEET_OPAQUE){

        @Override
        public void init(LittleParticle particle) {
            particle.pickSprite(particle.sprites);
        }

        @Override
        public void tick(LittleParticle particle) {
        }
    }
    ,
    falling(ResourceLocation.withDefaultNamespace((String)"falling_water"), LittleParticleRenderType.PARTICLE_SHEET_OPAQUE){

        @Override
        public void init(LittleParticle particle) {
            particle.pickSprite(particle.sprites);
        }

        @Override
        public void tick(LittleParticle particle) {
        }
    }
    ,
    heart(ResourceLocation.withDefaultNamespace((String)"heart"), LittleParticleRenderType.PARTICLE_SHEET_OPAQUE){

        @Override
        public void init(LittleParticle particle) {
            particle.pickSprite(particle.sprites);
        }

        @Override
        public void tick(LittleParticle particle) {
        }
    }
    ,
    lava(ResourceLocation.withDefaultNamespace((String)"lava"), LittleParticleRenderType.PARTICLE_SHEET_OPAQUE){

        @Override
        public void init(LittleParticle particle) {
            particle.pickSprite(particle.sprites);
        }

        @Override
        public void tick(LittleParticle particle) {
        }
    }
    ,
    soul(ResourceLocation.withDefaultNamespace((String)"soul"), LittleParticleRenderType.PARTICLE_SHEET_TRANSLUCENT){

        @Override
        public void init(LittleParticle particle) {
        }

        @Override
        public void tick(LittleParticle particle) {
            particle.setSpriteFromAge(particle.sprites);
        }
    }
    ,
    soul_flame(ResourceLocation.withDefaultNamespace((String)"soul_fire_flame"), LittleParticleRenderType.PARTICLE_SHEET_OPAQUE){

        @Override
        public void init(LittleParticle particle) {
            particle.pickSprite(particle.sprites);
        }

        @Override
        public void tick(LittleParticle particle) {
        }
    }
    ,
    big_smoke(ResourceLocation.withDefaultNamespace((String)"campfire_cosy_smoke"), LittleParticleRenderType.PARTICLE_SHEET_TRANSLUCENT){

        @Override
        public void init(LittleParticle particle) {
        }

        @Override
        public void tick(LittleParticle particle) {
            particle.setSpriteFromAge(particle.sprites);
        }
    }
    ,
    nautilus(ResourceLocation.withDefaultNamespace((String)"nautilus"), LittleParticleRenderType.PARTICLE_SHEET_OPAQUE){

        @Override
        public void init(LittleParticle particle) {
            particle.pickSprite(particle.sprites);
        }

        @Override
        public void tick(LittleParticle particle) {
        }
    };

    public final ResourceLocation particleTexture;
    public final LittleParticleRenderType type;

    public static LittleParticleTexture get(String name) {
        for (int i = 0; i < LittleParticleTexture.values().length; ++i) {
            if (!LittleParticleTexture.values()[i].name().equals(name)) continue;
            return LittleParticleTexture.values()[i];
        }
        return dust_fade_out;
    }

    private LittleParticleTexture(ResourceLocation particleTexture, LittleParticleRenderType type) {
        this.particleTexture = particleTexture;
        this.type = type;
    }

    public abstract void init(LittleParticle var1);

    public abstract void tick(LittleParticle var1);

    public Component title() {
        return Component.literal((String)LanguageUtils.translateOr((String)("particle.texture." + this.name()), (String)this.name()));
    }
}

