/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.grid;

import java.util.function.Supplier;
import team.creative.littletiles.common.grid.LittleGrid;

public interface IGridBased {
    public LittleGrid getGrid();

    @Deprecated
    default public void forceSameGrid(IGridBased other) {
        if (this.getGrid() != other.getGrid()) {
            if (this.getGrid().count > other.getGrid().count) {
                other.convertTo(this.getGrid());
            } else {
                this.convertTo(other.getGrid());
            }
        }
    }

    @Deprecated
    default public void forceSameGrid(IGridBased ... others) {
        int i;
        LittleGrid grid = this.getGrid();
        for (i = 0; i < others.length; ++i) {
            grid = LittleGrid.max(grid, others[i].getGrid());
        }
        if (grid != this.getGrid()) {
            this.convertTo(grid);
        }
        for (i = 0; i < others.length; ++i) {
            if (others[i].getGrid() == grid) continue;
            others[i].convertTo(grid);
        }
    }

    default public void sameGrid(IGridBased other, Runnable runnable) {
        if (this.getGrid() != other.getGrid()) {
            if (this.getGrid().count > other.getGrid().count) {
                other.convertTo(this.getGrid());
            } else {
                this.convertTo(other.getGrid());
            }
        }
        runnable.run();
        this.convertToSmallest();
        other.convertToSmallest();
    }

    default public <T> T sameGrid(IGridBased other, Supplier<T> supplier) {
        if (this.getGrid() != other.getGrid()) {
            if (this.getGrid().count > other.getGrid().count) {
                other.convertTo(this.getGrid());
            } else {
                this.convertTo(other.getGrid());
            }
        }
        T result = supplier.get();
        this.convertToSmallest();
        other.convertToSmallest();
        return result;
    }

    default public void unsafeSameGridRestore(IGridBased other, Runnable runnable) {
        LittleGrid thisGrid = this.getGrid();
        LittleGrid otherGrid = other.getGrid();
        if (this.getGrid() != other.getGrid()) {
            if (this.getGrid().count > other.getGrid().count) {
                other.convertTo(this.getGrid());
            } else {
                this.convertTo(other.getGrid());
            }
        }
        runnable.run();
        if (thisGrid != this.getGrid()) {
            this.convertTo(thisGrid);
        }
        if (otherGrid != other.getGrid()) {
            other.convertTo(otherGrid);
        }
    }

    default public <T> T unsafeSameGridRestore(IGridBased other, Supplier<T> supplier) {
        LittleGrid thisGrid = this.getGrid();
        LittleGrid otherGrid = other.getGrid();
        if (this.getGrid() != other.getGrid()) {
            if (this.getGrid().count > other.getGrid().count) {
                other.convertTo(this.getGrid());
            } else {
                this.convertTo(other.getGrid());
            }
        }
        T result = supplier.get();
        if (thisGrid != this.getGrid()) {
            this.convertTo(thisGrid);
        }
        if (otherGrid != other.getGrid()) {
            other.convertTo(otherGrid);
        }
        return result;
    }

    public void convertTo(LittleGrid var1);

    public int getSmallest();

    default public void convertToSmallest() {
        LittleGrid grid = LittleGrid.get(this.getSmallest());
        if (grid != this.getGrid()) {
            this.convertTo(grid);
        }
    }

    default public void minGrid(IGridBased other) {
        if (this.getGrid().count < other.getGrid().count) {
            this.convertTo(other.getGrid());
        }
    }

    default public void minGrid(LittleGrid grid) {
        if (this.getGrid().count < grid.count) {
            this.convertTo(grid);
        }
    }
}

