/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.control.animation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.timeline.GuiAnimationHandler;
import team.creative.creativecore.common.gui.control.timeline.GuiTimeline;
import team.creative.creativecore.common.gui.control.timeline.GuiTimelineChannel;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.flow.GuiSizeRule;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipeAnimationHandler;
import team.creative.littletiles.common.structure.animation.AnimationTimeline;
import team.creative.littletiles.common.structure.animation.event.AnimationEvent;

public class GuiTimelinePanel
extends GuiParent {
    public final GuiTimeline time;
    public final GuiRecipeAnimationHandler handler;

    public static List<AnimationTimeline.AnimationEventEntry> extract(AnimationTimeline timeline, Class<? extends AnimationEvent> clazz) {
        if (timeline == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<AnimationTimeline.AnimationEventEntry> events = null;
        for (AnimationTimeline.AnimationEventEntry entry : timeline.allEvents()) {
            if (entry.getEvent().getClass() != clazz) continue;
            if (events == null) {
                events = new ArrayList<AnimationTimeline.AnimationEventEntry>();
            }
            events.add(entry);
        }
        if (events == null) {
            return Collections.EMPTY_LIST;
        }
        return events;
    }

    public static void clearUnusedChannel(List<? extends GuiTimelineChannel> channels) {
        Iterator<? extends GuiTimelineChannel> iterator = channels.iterator();
        while (iterator.hasNext()) {
            GuiTimelineChannel channel = iterator.next();
            if (!channel.isChannelEmpty()) continue;
            channel.removeChannel();
            iterator.remove();
        }
    }

    public GuiTimelinePanel(GuiRecipeAnimationHandler handler, int duration) {
        this.setDim(200, -1);
        this.flow = GuiFlow.STACK_Y;
        this.handler = handler;
        this.setExpandableX();
        this.addBefore();
        this.time = new GuiTimeline((GuiAnimationHandler)handler);
        this.time.setDim((GuiSizeRule)new GuiSizeRule.GuiSizeRules().minHeight(10));
        this.time.setDuration(duration);
        this.add(this.time.setExpandableX());
    }

    protected void addBefore() {
    }

    public void durationChanged(int duration) {
        this.time.setDuration(Math.max(1, duration));
    }
}

