/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.premade;

import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.inventory.GuiInventoryGrid;
import team.creative.creativecore.common.gui.control.inventory.GuiPlayerInventoryGrid;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.mc.PlayerUtils;
import team.creative.creativecore.common.util.text.IComponentMap;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.api.common.tool.ILittlePlacer;
import team.creative.littletiles.client.export.LittleExportType;

public class GuiExport
extends GuiLayer {
    public GuiTextfield textfield;
    public Container exportSlot = new SimpleContainer(1);

    public GuiExport() {
        super("export");
        this.flow = GuiFlow.STACK_Y;
        this.align = Align.STRETCH;
    }

    public void create() {
        this.add((GuiControl)new GuiInventoryGrid("export", this.exportSlot).addListener(x -> {
            ILittlePlacer p;
            Item patt0$temp;
            ItemStack stack = this.exportSlot.getItem(0);
            if (!stack.isEmpty() && (patt0$temp = stack.getItem()) instanceof ILittlePlacer && (p = (ILittlePlacer)patt0$temp).hasTiles(stack)) {
                this.textfield.setText(((LittleExportType)((GuiComboBox)this.get("type")).selected()).export(stack));
            } else {
                this.textfield.setText("");
            }
        }));
        this.add((GuiControl)new GuiComboBox("type", (IComponentMap)new TextMapBuilder().addEntrySet(LittleExportType.REGISTRY.entrySet(), x -> Component.translatable((String)("gui.export." + (String)x.getKey())))));
        GuiParent row = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add((GuiControl)row);
        this.textfield = new GuiTextfield("export");
        this.textfield.setMaxStringLength(Integer.MAX_VALUE);
        row.add((GuiControl)this.textfield);
        if (this.isClient()) {
            row.add((GuiControl)new GuiButton("Copy", x -> Minecraft.getInstance().keyboardHandler.setClipboard(this.textfield.getText())).setTranslate("gui.copy"));
        }
        this.add(new GuiPlayerInventoryGrid(this.getPlayer()).setUnexpandableX());
    }

    public void closed() {
        super.closed();
        PlayerUtils.addOrDrop((Player)this.getPlayer(), (Container)this.exportSlot);
    }
}

