/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.structure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.collection.GuiListBoxBase;
import team.creative.creativecore.common.gui.control.inventory.GuiPlayerInventoryGrid;
import team.creative.creativecore.common.gui.control.inventory.GuiSlot;
import team.creative.creativecore.common.gui.control.inventory.IGuiInventory;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.creativecore.common.util.mc.PlayerUtils;
import team.creative.creativecore.common.util.text.content.ContentItemStack;
import team.creative.littletiles.api.common.tool.ILittlePlacer;
import team.creative.littletiles.api.common.tool.ILittleTool;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.ingredient.BlockIngredient;
import team.creative.littletiles.common.ingredient.BlockIngredientEntry;
import team.creative.littletiles.common.ingredient.ColorIngredient;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.ingredient.LittleInventory;
import team.creative.littletiles.common.ingredient.NotEnoughIngredientsException;
import team.creative.littletiles.common.ingredient.StackIngredient;
import team.creative.littletiles.common.ingredient.StackIngredientEntry;
import team.creative.littletiles.common.item.ItemLittleBlueprint;
import team.creative.littletiles.common.item.ItemMultiTiles;
import team.creative.littletiles.common.mod.chiselsandbits.ChiselsAndBitsManager;

public class GuiWorkbench
extends GuiLayer {
    public SimpleContainer crafting = new SimpleContainer(2);
    public final GuiSyncLocal<EndTag> CRAFT = this.getSyncHolder().register("craft", x -> {
        LittleGroup group;
        ItemStack input1 = this.crafting.getItem(0);
        ItemStack input2 = this.crafting.getItem(1);
        GuiListBoxBase listBox = (GuiListBoxBase)this.get("missing");
        listBox.clearItems();
        if (input1.isEmpty()) return;
        Item patt0$temp = input1.getItem();
        if (patt0$temp instanceof ItemLittleBlueprint) {
            ItemLittleBlueprint item = (ItemLittleBlueprint)patt0$temp;
            if (input2.isEmpty()) {
                if (!item.hasTiles(input1)) {
                    return;
                }
                group = item.getTiles(input1);
                Player player = this.getPlayer();
                LittleInventory inventory = new LittleInventory(player);
                LittleIngredients ingredients = LittleAction.getIngredients((HolderLookup.Provider)this.getPlayer().registryAccess(), group);
                try {
                    if (!LittleAction.checkAndTake(player, inventory, ingredients)) return;
                    ItemStack stack = ItemMultiTiles.of(group);
                    if (player.getInventory().add(stack)) return;
                    player.drop(stack, false);
                    return;
                }
                catch (NotEnoughIngredientsException e2) {
                    StackIngredient stacks;
                    ColorIngredient color;
                    LittleIngredients missing = e2.getIngredients();
                    BlockIngredient blocks = missing.get(BlockIngredient.class);
                    if (blocks != null) {
                        for (BlockIngredientEntry ingredient : blocks) {
                            listBox.addItem((GuiControl)new GuiLabel("").setTitle((Component)MutableComponent.create((ComponentContents)new ContentItemStack(ingredient.getBlockStack())).append(BlockIngredient.printVolume(ingredient.value, true))));
                        }
                    }
                    if ((color = missing.get(ColorIngredient.class)) != null) {
                        if (color.black > 0) {
                            listBox.addItem((GuiControl)new GuiLabel("").setTitle((Component)Component.literal((String)color.getBlackDescription())));
                        }
                        if (color.cyan > 0) {
                            listBox.addItem((GuiControl)new GuiLabel("").setTitle((Component)Component.literal((String)color.getCyanDescription())));
                        }
                        if (color.magenta > 0) {
                            listBox.addItem((GuiControl)new GuiLabel("").setTitle((Component)Component.literal((String)color.getMagentaDescription())));
                        }
                        if (color.yellow > 0) {
                            listBox.addItem((GuiControl)new GuiLabel("").setTitle((Component)Component.literal((String)color.getYellowDescription())));
                        }
                    }
                    if ((stacks = missing.get(StackIngredient.class)) == null) return;
                    Iterator<StackIngredientEntry> iterator = stacks.iterator();
                    while (iterator.hasNext()) {
                        StackIngredientEntry stack = iterator.next();
                        listBox.addItem((GuiControl)new GuiLabel("").setTitle((Component)MutableComponent.create((ComponentContents)new ContentItemStack(stack.stack)).append("" + stack.count)));
                    }
                    return;
                }
            }
        }
        if (ChiselsAndBitsManager.isChiselsAndBitsStructure(input1)) {
            group = ChiselsAndBitsManager.getGroup(input1);
            if (group == null) return;
            if (group.isEmpty()) return;
            if (!input2.isEmpty()) return;
            this.crafting.setItem(0, ItemStack.EMPTY);
            this.crafting.setItem(1, ItemMultiTiles.of(group));
            return;
        }
        if (!(input1.getItem() instanceof ILittlePlacer)) return;
        if (!(input2.getItem() instanceof ItemLittleBlueprint)) return;
        ILittleTool.setData(input2, ILittleTool.getData(input1).copy());
    });

    public GuiWorkbench() {
        super("workbench");
    }

    public void create() {
        this.flow = GuiFlow.STACK_Y;
        this.align = Align.CENTER;
        this.add((GuiControl)new CraftingGrid());
        this.add((GuiControl)new GuiListBoxBase("missing", false, new ArrayList()).setDim(150, 100));
        this.add(new GuiPlayerInventoryGrid(this.getPlayer()).setUnexpandableX());
    }

    public void closed() {
        super.closed();
        PlayerUtils.addOrDrop((Player)this.getPlayer(), (Container)this.crafting);
    }

    public class CraftingGrid
    extends GuiParent
    implements IGuiInventory {
        private List<GuiSlot> slots;

        public CraftingGrid() {
            super("crafting", (GuiFlow)GuiFlow.STACK_X);
            this.slots = new ArrayList<GuiSlot>();
            this.setVAlign(VAlign.CENTER);
            this.addSlot(new GuiSlot((Container)GuiWorkbench.this.crafting, 0));
            this.add((GuiControl)new GuiLabel("->").setTitle((Component)Component.literal((String)"->")));
            this.addSlot(new GuiSlot((Container)GuiWorkbench.this.crafting, 1));
            this.add((GuiControl)new GuiButton("craft", x -> GuiWorkbench.this.CRAFT.sendAndExecute((GuiLayer)GuiWorkbench.this, (Tag)EndTag.INSTANCE)).setTranslate("gui.craft"));
        }

        public GuiSlot addSlot(GuiSlot slot) {
            this.slots.add(slot);
            this.add((GuiControl)slot);
            return slot;
        }

        public GuiSlot getSlot(int index) {
            return this.slots.get(index);
        }

        public int inventorySize() {
            return this.slots.size();
        }

        public String name() {
            return this.name;
        }

        public void setChanged() {
        }

        public void setChanged(int slotIndex) {
        }
    }
}

