/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool.recipe;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import team.creative.creativecore.common.gui.control.timeline.GuiAnimationHandler;
import team.creative.creativecore.common.gui.control.tree.GuiTreeItem;
import team.creative.creativecore.common.util.type.itr.FilterIterator;
import team.creative.creativecore.common.util.type.itr.TreeIterator;
import team.creative.littletiles.common.gui.tool.recipe.GuiTreeItemStructure;
import team.creative.littletiles.common.structure.animation.AnimationTimeline;
import team.creative.littletiles.common.structure.animation.PhysicalState;
import team.creative.littletiles.common.structure.animation.context.AnimationContext;
import team.creative.littletiles.common.structure.animation.event.ChildDoorEvent;
import team.creative.littletiles.common.structure.type.animation.LittleDoor;

public class GuiRecipeAnimationHandler
implements GuiAnimationHandler {
    private int duration = 0;
    private int lastTick = -1;
    private boolean loop = true;
    private boolean playing = false;
    private int tick = 0;
    private AnimationTimeline timeline;
    private GuiTreeItemStructure current;
    private HashMap<GuiTreeItemStructure, ChildAnimationTimeline> childTimelines;

    public void setTimeline(GuiTreeItemStructure current, AnimationTimeline timeline) {
        this.reset();
        this.timeline = timeline;
        this.current = current;
        this.duration = timeline.duration;
        this.tick = Math.min(this.tick, this.duration);
        this.childTimelines = new HashMap();
        this.prepareChildEvents(current, timeline);
        this.updateState();
    }

    protected void prepareChildEvents(GuiTreeItemStructure parent, AnimationTimeline timeline) {
        this.prepareChildEvents(parent, (Iterable<AnimationTimeline.AnimationEventEntry>)new FilterIterator(timeline.allEvents(), x -> x.getEvent().getClass() == ChildDoorEvent.class));
    }

    protected void prepareChildEvents(GuiTreeItemStructure parent, Iterable<AnimationTimeline.AnimationEventEntry> events) {
        for (AnimationTimeline.AnimationEventEntry entry : events) {
            GuiTreeItemStructure item = (GuiTreeItemStructure)parent.getItem(((ChildDoorEvent)entry.getEvent()).childId);
            if (item == null || !(item.structure instanceof LittleDoor)) continue;
            ChildAnimationTimeline timeline = this.childTimelines.get(item);
            if (timeline == null) {
                timeline = new ChildAnimationTimeline(item);
                this.childTimelines.put(item, timeline);
            }
            timeline.add(item, entry);
        }
    }

    public void loop(boolean loop) {
        this.loop = loop;
    }

    public void play() {
        this.playing = true;
    }

    public void pause() {
        this.playing = false;
    }

    public void stop() {
        this.playing = false;
        this.set(0);
    }

    public void set(int tick) {
        this.tick = tick;
    }

    public int get() {
        return this.tick;
    }

    public void reset() {
        if (this.timeline != null) {
            if (this.current != null) {
                for (GuiTreeItem item : new TreeIterator((Object)this.current, x -> x.items().iterator())) {
                    ((GuiTreeItemStructure)item).physicalState.setZero();
                }
            }
            this.timeline = null;
            this.current = null;
            this.childTimelines = null;
        }
    }

    public void tick() {
        if (this.timeline == null) {
            return;
        }
        if (this.playing) {
            if (this.tick > this.timeline.duration) {
                if (this.loop) {
                    this.tick = 0;
                }
            } else {
                ++this.tick;
            }
        }
        if (this.tick != this.lastTick) {
            this.updateState();
        }
    }

    protected void updateState() {
        this.timeline.setStateAtTick(this.tick, this.current.physicalState, this.current);
        for (Map.Entry<GuiTreeItemStructure, ChildAnimationTimeline> entry : this.childTimelines.entrySet()) {
            entry.getValue().setTick(entry.getKey(), this.tick);
        }
        this.lastTick = this.tick;
    }

    public GuiTreeItemStructure current() {
        return this.current;
    }

    public AnimationContext context() {
        return this.current;
    }

    public class ChildAnimationTimeline {
        private List<ChildAnimationTimelineEntry> entries = new ArrayList<ChildAnimationTimelineEntry>();
        private final PhysicalState closed;
        private final PhysicalState opened;

        public ChildAnimationTimeline(GuiTreeItemStructure item) {
            LittleDoor door = (LittleDoor)item.structure;
            this.closed = door.getState("closed");
            this.opened = door.getState("opened");
            this.entries.add(new ChildAnimationTimelineEntryStill(item, 0, false, this.closed));
        }

        public PhysicalState get(boolean opened) {
            return opened ? this.opened : this.closed;
        }

        public void add(GuiTreeItemStructure item, AnimationTimeline.AnimationEventEntry entry) {
            ChildAnimationTimelineEntryStill last = (ChildAnimationTimelineEntryStill)this.entries.get(this.entries.size() - 1);
            if (last.start == entry.start) {
                this.entries.remove(this.entries.size() - 1);
            } else if (last.start > entry.start) {
                return;
            }
            LittleDoor door = (LittleDoor)item.structure;
            AnimationTimeline timeline = door.getTransition(last.opened ? "closing" : "opening");
            timeline = timeline == null ? new AnimationTimeline(door.duration) : timeline.copy();
            if (last.opened) {
                timeline.start(this.opened, this.closed, door.interpolation::create1d);
            } else {
                timeline.start(this.closed, this.opened, door.interpolation::create1d);
            }
            this.entries.add(new ChildAnimationTimelineEntryAnimation(GuiRecipeAnimationHandler.this, item, entry.start, timeline));
            this.entries.add(new ChildAnimationTimelineEntryStill(item, entry.start + timeline.duration + 1, !last.opened, this.get(!last.opened)));
        }

        public void setTick(GuiTreeItemStructure item, int tick) {
            if (this.entries.isEmpty()) {
                return;
            }
            ChildAnimationTimelineEntry last = null;
            for (ChildAnimationTimelineEntry entry : this.entries) {
                if (tick < entry.start) break;
                last = entry;
            }
            last.set(item, tick - last.start);
        }
    }

    public class ChildAnimationTimelineEntryAnimation
    extends ChildAnimationTimelineEntry {
        public final AnimationTimeline timeline;

        public ChildAnimationTimelineEntryAnimation(GuiRecipeAnimationHandler this$0, GuiTreeItemStructure item, int start, AnimationTimeline timeline) {
            super(start);
            this.timeline = timeline;
            this$0.prepareChildEvents(item, timeline);
        }

        @Override
        public void set(GuiTreeItemStructure item, int tick) {
            this.timeline.setStateAtTick(tick, item.physicalState, item);
        }
    }

    public static class ChildAnimationTimelineEntryStill
    extends ChildAnimationTimelineEntry {
        public final boolean opened;
        public final PhysicalState state;

        public ChildAnimationTimelineEntryStill(GuiTreeItemStructure item, int start, boolean opened, PhysicalState state) {
            super(start);
            this.opened = opened;
            this.state = state;
        }

        @Override
        public void set(GuiTreeItemStructure item, int tick) {
            item.physicalState.set(this.state);
        }
    }

    public static abstract class ChildAnimationTimelineEntry {
        public final int start;

        public ChildAnimationTimelineEntry(int start) {
            this.start = start;
        }

        public abstract void set(GuiTreeItemStructure var1, int var2);
    }
}

