/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool.recipe;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.control.simple.GuiArraySlider;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiCheckBox;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.dialog.DialogGuiLayer;
import team.creative.creativecore.common.gui.dialog.GuiDialogHandler;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.text.IComponentMap;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.item.ItemLittleBlueprint;
import team.creative.littletiles.common.item.component.SelectionComponent;
import team.creative.littletiles.common.placement.selection.SelectionMode;
import team.creative.littletiles.common.placement.selection.SelectionParameters;
import team.creative.littletiles.common.placement.selection.SelectionResult;

public class GuiRecipeSelection
extends GuiConfigure {
    public SelectionResult result;
    public final GuiSyncLocal<CompoundTag> SAVE_SELECTION = this.getSyncHolder().register("save_selection", nbt -> {
        try {
            SelectionMode mode = (SelectionMode)SelectionMode.REGISTRY.get(nbt.getString("mode"));
            SelectionParameters selection = new SelectionParameters(this.getPlayer().level(), this.getPlayer(), nbt.getBoolean("includeVanilla"), nbt.getBoolean("includeCB"), nbt.getBoolean("includeLT"), nbt.getBoolean("remember_structure"));
            SelectionComponent component = SelectionComponent.of(mode, nbt.getCompound("sel_config"));
            LittleGroup previews = mode.select(selection, component);
            if (nbt.contains("grid")) {
                LittleGrid grid = LittleGrid.get(nbt.getInt("grid"));
                previews.convertTo(grid);
                LittleGrid aimedGrid = LittleGrid.get(nbt.getInt("aimedGrid"));
                if (aimedGrid.count > grid.count) {
                    LittleGroup.setGridSecretly(previews, aimedGrid);
                } else {
                    LittleGroup.advancedScale(previews, aimedGrid.count, grid.count);
                }
                previews.combineBlockwise();
            }
            previews.removeOffset();
            ((ItemLittleBlueprint)this.tool.get().getItem()).saveTiles(this.tool.get(), previews);
            this.tool.get().remove(LittleTilesRegistry.SELECTION);
            this.tool.get().remove(LittleTilesRegistry.MATRIX);
            this.tool.changed();
            LittleTilesGuiRegistry.OPEN_CONFIG.open(this.getPlayer());
        }
        catch (LittleActionException e) {
            GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"info", (Component)Component.translatable((String)"gui.ok"), (x, y) -> {}, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.OK});
            return;
        }
    });
    public final GuiSyncLocal<EndTag> CLEAR_SELECTION = this.getSyncHolder().register("clear_selection", x -> {
        this.tool.get().remove(LittleTilesRegistry.SELECTION);
        this.tool.changed();
        LittleTilesGuiRegistry.OPEN_CONFIG.open(this.getPlayer());
    });

    public GuiRecipeSelection(ContainerSlotView view) {
        super("recipe_selection", 200, 200, view);
        this.flow = GuiFlow.STACK_Y;
        this.registerEventChanged(x -> {
            if (!x.control.is("scale")) {
                this.updateSlider();
            }
        });
    }

    @Override
    public boolean saveConfiguration(PatchedDataComponentMap data) {
        GuiComboBox box = (GuiComboBox)this.get("selection_mode");
        data.set((DataComponentType)LittleTilesRegistry.SELECTION.get(), (Object)SelectionComponent.getOrDefault(this.tool.get()).withMode((SelectionMode)box.selected((Object)((SelectionMode)SelectionMode.REGISTRY.getDefault()))));
        return false;
    }

    public void create() {
        ItemStack stack = this.tool.get();
        SelectionComponent component = SelectionComponent.getOrDefault(stack);
        GuiComboBox box = new GuiComboBox("selection_mode", (IComponentMap)new TextMapBuilder().addEntrySet(SelectionMode.REGISTRY.entrySet(), x -> ((SelectionMode)x.getValue()).getTranslation()));
        box.select((Object)component.mode);
        this.add(box.setExpandableX());
        this.result = component.mode.scan(this.getPlayer().level(), component);
        GuiCheckBox vanilla = new GuiCheckBox("includeVanilla", false).setTranslate("selection.include.vanilla");
        if (this.result != null && this.result.hasBlocks()) {
            vanilla.setTooltip(this.result.blockInfo());
        } else {
            vanilla.enabled = false;
        }
        this.add((GuiControl)vanilla);
        GuiCheckBox cb = new GuiCheckBox("includeCB", true).setTranslate("selection.include.cb");
        if (this.result != null && this.result.hasCB()) {
            cb.setTooltip(this.result.cbInfo());
        } else {
            cb.enabled = false;
        }
        this.add((GuiControl)cb);
        GuiCheckBox lt = new GuiCheckBox("includeLT", true).setTranslate("selection.include.lt");
        if (this.result != null && this.result.hasTiles()) {
            cb.setTooltip(this.result.ltInfo());
        } else {
            lt.enabled = false;
        }
        this.add((GuiControl)lt);
        this.add((GuiControl)new GuiCheckBox("remember_structure", true).setTranslate("selection.include.structure"));
        GuiParent scale = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add((GuiControl)scale);
        GuiLabel label = new GuiLabel("label_scale").setTitle((Component)Component.translatable((String)"selection.scale").append(": "));
        scale.add((GuiControl)label);
        scale.add(new GuiArraySlider("scale").setExpandableX());
        this.updateSlider();
        GuiLeftRightBox bottom = new GuiLeftRightBox();
        this.add(bottom.setAlign(Align.RIGHT).setExpandableX());
        bottom.addRight((GuiControl)new GuiButton("clear", x -> GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"clear_sekection", (Component)Component.translatable((String)"gui.selection.dialog.clear"), (g, b) -> {
            if (b == DialogGuiLayer.DialogButton.YES) {
                this.CLEAR_SELECTION.send((Tag)EndTag.INSTANCE);
            }
        }, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.NO, DialogGuiLayer.DialogButton.YES})).setTranslate("selection.clear"));
        bottom.addRight(new GuiButton("save", x -> {
            SelectionParameters selection = new SelectionParameters(this.getPlayer().level(), this.getPlayer(), ((GuiCheckBox)this.get((String)"includeVanilla", GuiCheckBox.class)).value, ((GuiCheckBox)this.get((String)"includeCB", GuiCheckBox.class)).value, ((GuiCheckBox)this.get((String)"includeLT", GuiCheckBox.class)).value, ((GuiCheckBox)this.get((String)"remember_structure", GuiCheckBox.class)).value);
            SelectionMode mode = (SelectionMode)box.selected((Object)((SelectionMode)SelectionMode.REGISTRY.getDefault()));
            try {
                if (selection.rememberStructure() && mode.select(selection, component).isEmptyIncludeChildren()) {
                    GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"no_tiles", (Component)Component.translatable((String)"selection.no_tiles"), (g, b) -> {}, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.OK});
                    return;
                }
            }
            catch (LittleActionException e) {
                GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"info", (Component)Component.translatable((String)"gui.ok"), (g, b) -> {}, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.OK});
                return;
            }
            CompoundTag nbt = new CompoundTag();
            nbt.putString("mode", mode.getName());
            nbt.put("sel_config", (Tag)component.getConfig());
            nbt.putBoolean("includeVanilla", selection.includeVanilla());
            nbt.putBoolean("includeCB", selection.includeCB());
            nbt.putBoolean("includeLT", selection.includeLT());
            nbt.putBoolean("remember_structure", selection.rememberStructure());
            LittleGrid minRequired = this.result.minGrid(selection.includeLT(), selection.includeCB());
            LittleGrid selected = LittleGrid.gridByIndex(LittleGrid.gridCount() - 1 - ((GuiArraySlider)this.get("scale")).getIntValue());
            if (minRequired != selected) {
                nbt.putInt("grid", minRequired.count);
                nbt.putInt("aimedGrid", selected.count);
            }
            this.SAVE_SELECTION.send((Tag)nbt);
        }).setTranslate("gui.save").setEnabled(this.result != null));
    }

    public void updateSlider() {
        boolean includeLT;
        GuiArraySlider slider = (GuiArraySlider)this.get("scale");
        boolean includeVanilla = ((GuiCheckBox)this.get((String)"includeVanilla", GuiCheckBox.class)).enabled && ((GuiCheckBox)this.get((String)"includeVanilla", GuiCheckBox.class)).value;
        boolean includeCB = ((GuiCheckBox)this.get((String)"includeCB", GuiCheckBox.class)).enabled && ((GuiCheckBox)this.get((String)"includeCB", GuiCheckBox.class)).value;
        boolean bl = includeLT = ((GuiCheckBox)this.get((String)"includeLT", GuiCheckBox.class)).enabled && ((GuiCheckBox)this.get((String)"includeLT", GuiCheckBox.class)).value;
        if (this.result == null || !includeVanilla && !includeCB && !includeLT) {
            slider.setEnabled(false);
        } else {
            LittleGrid minRequired = this.result.minGrid(includeLT, includeCB);
            String value = slider.get();
            Object[] values = new String[LittleGrid.gridCount()];
            for (LittleGrid context : LittleGrid.grids()) {
                values[values.length - 1 - context.getIndex()] = minRequired.count + ":" + context.count + " x" + context.pixelLength / minRequired.pixelLength;
            }
            slider.setValues((String[])values);
            if (ArrayUtils.contains((Object[])values, (Object)value)) {
                slider.select(value);
            } else {
                slider.select((String)values[values.length - 1 - minRequired.getIndex()]);
            }
            slider.setEnabled(true);
        }
    }
}

