/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.parent.GuiScrollY;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.control.tree.GuiTree;
import team.creative.creativecore.common.gui.control.tree.GuiTreeItem;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.mc.LanguageUtils;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.client.level.little.FakeClientLevel;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.gui.AnimationPreview;
import team.creative.littletiles.common.gui.signal.GuiComponentSearch;
import team.creative.littletiles.common.gui.signal.GuiSignalComponent;
import team.creative.littletiles.common.gui.signal.dialog.GuiDialogSignalEvents;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipe;
import team.creative.littletiles.common.gui.tool.recipe.test.RecipeTestError;
import team.creative.littletiles.common.math.vec.LittleVecGrid;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.animation.PhysicalState;
import team.creative.littletiles.common.structure.animation.context.AnimationContext;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGui;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGuiRegistry;
import team.creative.littletiles.common.structure.relative.StructureAbsolute;
import team.creative.littletiles.common.structure.signal.component.ISignalComponent;
import team.creative.littletiles.common.structure.signal.output.InternalSignalOutput;
import team.creative.littletiles.common.structure.signal.output.SignalExternalOutputHandler;
import team.creative.littletiles.server.level.little.FakeServerLevel;

public class GuiTreeItemStructure
extends GuiTreeItem
implements AnimationContext {
    public final GuiRecipe recipe;
    public LittleGroup group;
    public LittleStructure structure;
    public LittleStructureGui gui;
    public GuiComponentSearch signalSearch = new GuiComponentSearch(this);
    private GuiDialogSignalEvents.GuiSignalEvent[] internalOutputs;
    private HashMap<Integer, GuiDialogSignalEvents.GuiSignalEvent> externalOutputs;
    private LittleVecGrid offset;
    private int index;
    private String title;
    private List<RecipeTestError> errors;
    public PhysicalState physicalState = new PhysicalState();
    private StructureAbsolute center;

    public GuiTreeItemStructure(GuiRecipe recipe, GuiTree tree, LittleGroup group, int index) {
        super("tree_item", tree);
        this.recipe = recipe;
        this.group = group;
        if (group.hasStructure()) {
            this.structure = group.getStructureType().createStructure(null);
            this.structure.load(group.getStructureTag(), recipe.provider());
        }
        this.index = index;
        this.refreshAnimation();
        this.updateTitle();
        this.updateSignalOutputs();
    }

    private void updateSignalOutputs() {
        GuiSignalComponent[] internal = this.signalSearch.internalOutputs();
        if (internal != null) {
            this.internalOutputs = new GuiDialogSignalEvents.GuiSignalEvent[internal.length];
            for (int i = 0; i < internal.length; ++i) {
                this.internalOutputs[i] = this.structure == null ? new GuiDialogSignalEvents.GuiSignalEvent(internal[i], (InternalSignalOutput)null) : new GuiDialogSignalEvents.GuiSignalEvent(internal[i], this.structure.getOutput(i));
            }
        } else {
            this.internalOutputs = null;
        }
        this.externalOutputs = new HashMap();
        for (GuiSignalComponent output : this.signalSearch.externalOutputs()) {
            if (this.structure == null) {
                this.externalOutputs.put(output.index(), new GuiDialogSignalEvents.GuiSignalEvent(output, (InternalSignalOutput)null));
                continue;
            }
            if (!output.external()) continue;
            this.externalOutputs.put(output.index(), new GuiDialogSignalEvents.GuiSignalEvent(output, this.structure.getExternalOutput(output.index())));
        }
    }

    public LittleStructureType getStructureType() {
        if (this.gui != null) {
            return this.gui.type();
        }
        if (this.structure != null) {
            return this.structure.type;
        }
        return null;
    }

    public GuiDialogSignalEvents.GuiSignalEvent[] internalOutputs() {
        return this.internalOutputs;
    }

    public int externalOutputCount() {
        return this.externalOutputs.size();
    }

    public Iterable<GuiDialogSignalEvents.GuiSignalEvent> externalOutputs() {
        return this.externalOutputs.values();
    }

    public GuiDialogSignalEvents.GuiSignalEvent getInternalOutput(int index) {
        if (this.internalOutputs != null && index >= 0 && index < this.internalOutputs.length) {
            return this.internalOutputs[index];
        }
        return null;
    }

    public GuiDialogSignalEvents.GuiSignalEvent getExternalOutput(int index) {
        return this.externalOutputs.get(index);
    }

    public void setInternalOutput(int index, GuiDialogSignalEvents.GuiSignalEvent event) {
        if (this.internalOutputs != null && index >= 0 && index < this.internalOutputs.length) {
            this.internalOutputs[index] = event;
        }
    }

    public void setExternalOutput(int index, GuiDialogSignalEvents.GuiSignalEvent event) {
        this.externalOutputs.put(index, event);
    }

    @Nullable
    public GuiDialogSignalEvents.GuiSignalEvent getSignalOutput(boolean external, int index) {
        if (external) {
            return this.getExternalOutput(index);
        }
        return this.getInternalOutput(index);
    }

    @Nullable
    public void setSignalOutput(boolean external, int index, GuiDialogSignalEvents.GuiSignalEvent event) {
        if (external) {
            this.setExternalOutput(index, event);
        } else {
            this.setInternalOutput(index, event);
        }
    }

    private void setEventsToStructure() {
        if (this.structure == null) {
            return;
        }
        for (int i = 0; i < this.internalOutputs.length; ++i) {
            GuiDialogSignalEvents.GuiSignalEvent event = this.internalOutputs[i];
            InternalSignalOutput output = this.structure.getOutput(i);
            output.condition = event.condition;
            output.handler = event.getHandler(output, this.structure);
        }
        HashMap<Integer, SignalExternalOutputHandler> map = new HashMap<Integer, SignalExternalOutputHandler>();
        for (GuiDialogSignalEvents.GuiSignalEvent event : this.externalOutputs.values()) {
            if (event.condition == null) continue;
            map.put(event.component.index(), new SignalExternalOutputHandler(null, event.component.index(), event.condition, x -> event.getHandler((ISignalComponent)x, this.structure)));
        }
        this.structure.setExternalOutputs(map);
    }

    protected void select() {
        super.select();
        this.updateTitle();
        this.recipe.types.forceSelect((Object)LittleStructureGuiRegistry.get(this.structure != null ? this.structure.type : null, this.group));
    }

    public void onNameChanged(GuiTextfield field) {
        String text = field.getText();
        if (text.isBlank()) {
            text = null;
        }
        this.updateTitle(text, this.gui.type());
        this.tree.reflowTree();
    }

    public void load() {
        this.recipe.animation.reset();
        this.gui = (LittleStructureGui)this.recipe.types.selected();
        this.recipe.control = this.gui.create(this);
        this.recipe.control.setExpandableY();
        this.recipe.config.clear();
        GuiScrollY scroll = new GuiScrollY(this, "config"){

            public ControlFormatting getControlFormatting() {
                return ControlFormatting.TRANSPARENT;
            }
        }.setHover(true);
        scroll.add((GuiControl)this.recipe.control);
        this.recipe.config.add((GuiControl)scroll);
        this.recipe.control.create(this.structure);
        this.recipe.config.init();
        this.recipe.types.setEnabled(this.recipe.control.canChangeType());
        GuiParent info = new GuiParent("infoStructure", (GuiFlow)GuiFlow.STACK_X).setVAlign(VAlign.CENTER);
        this.recipe.config.add((GuiControl)info);
        info.add((GuiControl)new GuiLabel("info").setTitle((Component)Component.literal((String)(this.group.totalTiles() + " " + LanguageUtils.translate((String)"gui.tile.count") + " " + this.group.totalBoxes() + " " + LanguageUtils.translate((String)"gui.box.count")))));
        GuiParent parent = new GuiParent("bottomStructure", (GuiFlow)GuiFlow.STACK_X).setVAlign(VAlign.CENTER);
        this.recipe.config.add((GuiControl)parent);
        parent.add((GuiControl)new GuiLabel("name_label").setTranslate("gui.recipe.structure.name"));
        GuiTextfield text = new GuiTextfield("name");
        if (this.structure != null && this.structure.name != null) {
            text.setText(this.structure.name);
        } else {
            text.setText("");
        }
        parent.add(text.setEnabled(this.gui.supportsName()).setDim(100, 7));
        parent.add(new GuiButton("signal", x -> ((GuiDialogSignalEvents)LittleTilesGuiRegistry.SIGNAL_EVENTS_DIALOG.open(this.getIntegratedParent(), new CompoundTag())).init(this)).setTranslate("gui.signal.events").setEnabled(this.gui.type() != null));
        this.updateSignalOutputs();
        this.onNameChanged(text);
        this.recipe.reflow();
    }

    public void save() {
        LittleStructureType type = ((LittleStructureGui)this.recipe.types.selected()).type();
        this.structure = this.recipe.control.save(type != null ? type.createStructure(null) : null);
        if (this.structure != null) {
            GuiParent parent = (GuiParent)this.recipe.config.get("bottomStructure");
            GuiTextfield textfield = (GuiTextfield)parent.get("name");
            this.structure.name = textfield.getText().isBlank() ? null : textfield.getText();
        }
        this.setEventsToStructure();
        this.updateTitle();
    }

    protected void deselect() {
        super.deselect();
        this.updateTitle();
        this.save();
    }

    public void updateTitle() {
        this.updateTitle(this.structure != null ? this.structure.name : null, this.structure != null ? this.structure.type : null);
    }

    protected void updateTitle(String name, LittleStructureType type) {
        int index = this.getParentItem() != null ? this.getParentItem().indexOf((GuiTreeItem)this) : this.index;
        boolean hasStructureName = true;
        if (name == null) {
            hasStructureName = false;
            name = type != null ? type.id + " " + index : "none " + index;
        }
        if (hasStructureName) {
            name = String.valueOf(ChatFormatting.ITALIC) + (String)name;
        }
        this.title = name;
        if (this.selected()) {
            name = "<" + (String)name + ">";
        }
        if (this.errors != null && !this.errors.isEmpty()) {
            name = String.valueOf(ChatFormatting.RED) + (String)name;
        }
        this.setTitle((Component)Component.literal((String)name));
    }

    public void updateTooltip() {
        if (this.errors == null || this.errors.isEmpty()) {
            this.setTooltip(null);
            return;
        }
        ArrayList<Object> tooltip = new ArrayList<Object>();
        if (this.errors.size() == 1) {
            tooltip.add(GuiTreeItemStructure.translatable((String)"gui.recipe.test.error.single"));
        } else {
            tooltip.add(GuiTreeItemStructure.translatable((String)"gui.recipe.test.error.multiple", (Object[])new Object[]{this.errors.size()}));
        }
        for (RecipeTestError error : this.errors) {
            tooltip.add(error.tooltip(this));
        }
        this.setTooltip(tooltip);
    }

    public void clearErrors() {
        if (this.errors != null) {
            this.errors.clear();
        }
    }

    public void addError(RecipeTestError error) {
        if (this.errors == null) {
            this.errors = new ArrayList<RecipeTestError>();
        }
        this.errors.add(error);
    }

    public String getTitle() {
        return this.title;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void refreshAnimation() {
        FakeClientLevel fakeLevel = FakeServerLevel.createClient("animationViewer");
        CompletableFuture.supplyAsync(() -> {
            try {
                return new AnimationPreview(fakeLevel, this.structure, this.group, this.provider());
            }
            catch (LittleActionException e) {
                throw new RuntimeException(e);
            }
        }).whenComplete((preview, throwable) -> {
            this.recipe.storage.completed(this, (AnimationPreview)preview);
            if (throwable != null) {
                throwable.printStackTrace();
            }
        });
    }

    public void removed() {
        super.removed();
        if (!this.moving) {
            this.recipe.storage.removed(this);
        }
    }

    public GuiTreeItemStructure duplicate() {
        CompoundTag nbt;
        if (this.structure == null) {
            nbt = null;
        } else {
            nbt = new CompoundTag();
            this.structure.save(nbt, this.recipe.provider());
        }
        GuiTreeItemStructure item = new GuiTreeItemStructure(this.recipe, this.tree, new LittleGroup(nbt, this.group.copy(), Collections.EMPTY_LIST), this.getParentItem().itemsCount());
        for (GuiTreeItem child : this.items()) {
            if (!(child instanceof GuiTreeItemStructure)) continue;
            GuiTreeItemStructure s = (GuiTreeItemStructure)child;
            item.addItem(s.duplicate());
        }
        return item;
    }

    public void setOffset(LittleVecGrid vec) {
        this.offset = vec;
    }

    public LittleVecGrid getOffset() {
        return this.offset;
    }

    public void move(LittleVecGrid vec) {
        this.group.move(vec);
        this.refreshAnimation();
        for (GuiTreeItem item : this.items()) {
            ((GuiTreeItemStructure)item).move(vec);
        }
    }

    public void applyOffset() {
        if (this.offset != null) {
            this.move(this.offset);
        }
        this.offset = null;
    }

    public void resetOffset() {
        this.offset = null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void prepareRendering(AnimationPreview preview) {
        preview.set(this.physicalState);
        if (this.hasNewCenter()) {
            preview.setCenter(this.center);
            this.center = null;
        }
    }

    public void setNewCenter(StructureAbsolute center) {
        this.center = center;
    }

    public StructureAbsolute getCenter() {
        return this.center;
    }

    public boolean hasNewCenter() {
        return this.center != null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void play(SoundEvent event, float volume, float pitch) {
        GuiControl.playSound((SoundEvent)event, (float)volume, (float)pitch);
    }

    @Override
    public boolean isGui() {
        return true;
    }

    @Override
    public AnimationContext getChild(int id) {
        if (id < 0 || this.itemsCount() <= id) {
            return null;
        }
        return (AnimationContext)this.getItem(id);
    }

    @Override
    public LittleStructure getChildStructure(int id) {
        if (id < 0 || this.itemsCount() <= id) {
            return null;
        }
        return ((GuiTreeItemStructure)this.getItem((int)id)).structure;
    }

    public HolderLookup.Provider provider() {
        return this.recipe.provider();
    }
}

