/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.ingredient;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import team.creative.creativecore.common.util.ingredient.CreativeIngredient;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.littletiles.common.ingredient.ItemIngredientEntry;
import team.creative.littletiles.common.ingredient.LittleIngredient;

public class ItemIngredient
extends LittleIngredient<ItemIngredient>
implements Iterable<ItemIngredientEntry> {
    private List<ItemIngredientEntry> content = new ArrayList<ItemIngredientEntry>();

    public ItemIngredient() {
    }

    public ItemIngredient(CreativeIngredient ingredient) {
        this.content.add(new ItemIngredientEntry(ingredient, 1));
    }

    public ItemIngredient(CreativeIngredient ... ingredients) {
        for (int i = 0; i < ingredients.length; ++i) {
            this.content.add(new ItemIngredientEntry(ingredients[i], 1));
        }
    }

    @Override
    public Iterator<ItemIngredientEntry> iterator() {
        return this.content.iterator();
    }

    @Override
    public ItemIngredient copy() {
        ItemIngredient copy = new ItemIngredient();
        this.content.forEach(x -> copy.content.add(x.copy()));
        return copy;
    }

    @Override
    public TextBuilder toText() {
        TextBuilder text = new TextBuilder();
        for (ItemIngredientEntry entry : this.content) {
            text.text(entry.toString()).stack(entry.ingredient.getExample());
        }
        return text;
    }

    @Override
    public ItemIngredientEntry add(ItemIngredientEntry ingredient) {
        if (ingredient.isEmpty()) {
            return null;
        }
        for (int i = 0; i < this.content.size(); ++i) {
            ItemIngredientEntry entry = this.content.get(i);
            if (!entry.is(ingredient)) continue;
            entry.count += ingredient.count;
        }
        return ingredient;
    }

    @Override
    public ItemIngredient add(ItemIngredient ingredient) {
        ItemIngredient remaings = null;
        for (ItemIngredientEntry entry : ingredient.content) {
            ItemIngredientEntry remaing = this.add(entry);
            if (remaing == null) continue;
            if (remaings == null) {
                remaings = new ItemIngredient();
            }
            remaings.add(remaing);
        }
        return remaings;
    }

    @Override
    public ItemIngredientEntry sub(ItemIngredientEntry ingredient) {
        if (ingredient.isEmpty()) {
            return null;
        }
        for (int i = this.content.size() - 1; i >= 0; --i) {
            ItemIngredientEntry entry = this.content.get(i);
            if (!entry.equals(ingredient)) continue;
            entry.count -= ingredient.count;
            if (entry.count <= 0) {
                this.content.remove(i);
                if (entry.count < 0) {
                    ingredient = entry;
                    ingredient.count = -ingredient.count;
                    continue;
                }
            }
            return null;
        }
        return ingredient;
    }

    @Override
    public ItemIngredient sub(ItemIngredient ingredient) {
        ItemIngredient remaings = null;
        for (ItemIngredientEntry entry : ingredient.content) {
            ItemIngredientEntry remaing = this.sub(entry);
            if (remaing == null) continue;
            if (remaings == null) {
                remaings = new ItemIngredient();
            }
            remaings.add(remaing);
        }
        return remaings;
    }

    @Override
    public boolean isEmpty() {
        return this.content.isEmpty();
    }

    @Override
    public void scale(int count) {
        for (ItemIngredientEntry entry : this.content) {
            entry.scale(count);
        }
    }

    @Override
    public void scaleAdvanced(double scale) {
        for (ItemIngredientEntry entry : this.content) {
            entry.scaleAdvanced(scale);
        }
    }

    @Override
    public int getMinimumCount(ItemIngredient other, int availableCount) {
        throw new UnsupportedOperationException();
    }

    public List<ItemIngredientEntry> getContent() {
        return this.content;
    }

    @Override
    public void print(TextBuilder text) {
        if (this.content.size() <= 4) {
            for (ItemIngredientEntry entry : this.content) {
                text.stack(entry.ingredient.getExample()).text(" " + entry.count + " ").add(entry.ingredient.description()).newLine();
            }
        } else {
            for (ItemIngredientEntry entry : this.content) {
                text.stack(entry.ingredient.getExample()).text(" " + entry.count + " ");
            }
        }
    }

    public String toString() {
        return this.content.toString();
    }
}

