/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item;

import com.google.common.base.Charsets;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.tool.ILittlePlacer;
import team.creative.littletiles.api.common.tool.ILittleTool;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.tool.LittleTool;
import team.creative.littletiles.client.tool.LittleToolPlacer;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.convertion.OldLittleTilesDataParser;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.gui.tool.GuiModeSelector;
import team.creative.littletiles.common.item.tooltip.IItemTooltip;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVecGrid;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.placement.setting.PlacementPlayerSetting;

public class ItemMultiTiles
extends Item
implements ILittlePlacer,
IItemTooltip {
    private static final List<ItemStack> EXAMPLES = new ArrayList<ItemStack>();

    public static ItemStack of(LittleElement element) {
        return ItemMultiTiles.of(element, LittleGrid.MIN, LittleGrid.MIN.box());
    }

    public static ItemStack of(LittleGroup group) {
        ItemStack stack = new ItemStack((ItemLike)LittleTilesRegistry.ITEM_TILES.value());
        ILittleTool.setData(stack, LittleGroup.save(group));
        return stack;
    }

    public static ItemStack of(LittleElement element, LittleGrid grid, LittleBox box) {
        ItemStack stack = new ItemStack((ItemLike)LittleTilesRegistry.ITEM_TILES.value());
        LittleGroup group = new LittleGroup();
        group.add(grid, element, box);
        ILittleTool.setData(stack, LittleGroup.save(group));
        return stack;
    }

    public static void reloadExampleStructures(ResourceManager manager) {
        EXAMPLES.clear();
        Map files = manager.listResources("example", x -> x.getNamespace().equals("littletiles") && x.getPath().endsWith(".struct"));
        for (Map.Entry file : files.entrySet()) {
            try {
                ItemStack stack = new ItemStack((ItemLike)LittleTilesRegistry.ITEM_TILES.value());
                InputStream in = ((Resource)file.getValue()).open();
                CompoundTag nbt = TagParser.parseTag((String)IOUtils.toString((InputStream)in, (Charset)Charsets.UTF_8));
                if (OldLittleTilesDataParser.isOld(nbt)) {
                    nbt = OldLittleTilesDataParser.convert(nbt);
                }
                ILittleTool.setData(stack, nbt);
                EXAMPLES.add(stack);
                in.close();
            }
            catch (OldLittleTilesDataParser.LittleMissingGridException stack) {
            }
            catch (Exception e) {
                LittleTiles.LOGGER.error("Could not load '" + String.valueOf(file.getKey()) + "' example structure!", (Throwable)e);
            }
        }
    }

    public static void collectExamples(CreativeModeTab.Output output) {
        for (ItemStack stack : EXAMPLES) {
            output.accept(stack);
        }
    }

    public ItemMultiTiles() {
        super(new Item.Properties());
    }

    public static String getStructure(ItemStack stack) {
        CompoundTag data = ILittleTool.getData(stack);
        if (data.contains("s")) {
            return data.getCompound("s").getString("id");
        }
        return "";
    }

    public Component getName(ItemStack stack) {
        CompoundTag data = ILittleTool.getData(stack);
        if (data.contains("s") && data.getCompound("s").contains("n")) {
            return Component.literal((String)data.getCompound("s").getString("n"));
        }
        return super.getName(stack);
    }

    @Override
    public boolean hasTiles(ItemStack stack) {
        return true;
    }

    @Override
    public LittleGroup getTiles(ItemStack stack) {
        return LittleGroup.load(ILittleTool.getData(stack));
    }

    @Override
    public LittleGroup getLow(ItemStack stack) {
        return LittleGroup.loadLow(ILittleTool.getData(stack));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        String id = "none";
        CompoundTag data = ILittleTool.getData(stack);
        if (data.contains("s")) {
            id = data.getCompound("s").getString("id");
        }
        tooltip.add((Component)Component.translatable((String)"gui.structure").append(": ").append((Component)Component.translatable((String)("structure." + id))));
        tooltip.add(LittleGroup.printTooltip(data));
    }

    @Override
    public GuiConfigure getConfigure(Player player, ContainerSlotView view) {
        return new GuiModeSelector(this, view, PlacementPlayerSetting.grid(player), PlacementPlayerSetting.placementMode(player)){

            @Override
            public boolean saveConfiguration(DataComponentMap data, LittleGrid grid, PlacementMode mode) {
                LittleTilesClient.setPlace(grid, mode);
                return false;
            }
        };
    }

    @Override
    public boolean containsIngredients(ItemStack stack) {
        return true;
    }

    @Override
    public LittleVecGrid getCachedSize(ItemStack stack) {
        return LittleGroup.getSize(ILittleTool.getData(stack));
    }

    @Override
    public LittleVecGrid getCachedMin(ItemStack stack) {
        return LittleGroup.getMin(ILittleTool.getData(stack));
    }

    @Override
    public String tooltipTranslateKey(ItemStack stack, String defaultKey) {
        return "littletiles.tiles.tooltip";
    }

    @Override
    public Object[] tooltipData(ItemStack stack) {
        return new Object[]{LittleTilesClient.KEY_CONFIGURE.getTranslatedKeyMessage(), LittleTilesClient.arrowKeysTooltip(), LittleTilesClient.KEY_MIRROR.getTranslatedKeyMessage()};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Iterable<LittleTool> tools(ItemStack stack) {
        return Arrays.asList(new LittleToolPlacer(stack));
    }
}

