/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.item.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.PrimitiveCodec;
import io.netty.buffer.ByteBuf;
import net.minecraft.network.codec.StreamCodec;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3c;
import team.creative.creativecore.common.util.math.utils.IntegerUtils;

public class MatrixDataComponent {
    public static final Codec<MatrixDataComponent> CODEC = new PrimitiveCodec<MatrixDataComponent>(){

        public <T> DataResult<MatrixDataComponent> read(DynamicOps<T> ops, T input) {
            return ops.getNumberValue(input).map(Number::intValue).map(MatrixDataComponent::new);
        }

        public <T> T write(DynamicOps<T> ops, MatrixDataComponent value) {
            return (T)ops.createInt(value.data);
        }

        public String toString() {
            return "Matrix";
        }
    };
    public static final StreamCodec<ByteBuf, MatrixDataComponent> STREAM_CODEC = new StreamCodec<ByteBuf, MatrixDataComponent>(){

        public MatrixDataComponent decode(ByteBuf buf) {
            return new MatrixDataComponent(buf.readInt());
        }

        public void encode(ByteBuf buf, MatrixDataComponent matrix) {
            buf.writeInt(matrix.data);
        }
    };
    private final int data;

    public static MatrixDataComponent of(IntMatrix3c matrix) {
        int[] array = matrix.getAsArray();
        int data = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] > 0) {
                data = IntegerUtils.set((int)data, (int)(i * 2));
                continue;
            }
            if (array[i] >= 0) continue;
            data = IntegerUtils.set((int)data, (int)(i * 2 + 1));
        }
        return new MatrixDataComponent(data);
    }

    private MatrixDataComponent(int data) {
        this.data = data;
    }

    public IntMatrix3 getMatrix() {
        int[] array = new int[9];
        for (int i = 0; i < array.length; ++i) {
            if (IntegerUtils.bitIs((int)this.data, (int)(i * 2))) {
                array[i] = 1;
                continue;
            }
            if (!IntegerUtils.bitIs((int)this.data, (int)(i * 2 + 1))) continue;
            array[i] = -1;
        }
        return new IntMatrix3(array);
    }

    public boolean isEqual(MatrixDataComponent m) {
        return m.data == this.data;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MatrixDataComponent) {
            return true;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.data;
    }
}

