/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.level;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import team.creative.creativecore.common.util.filter.BiFilter;
import team.creative.creativecore.common.util.type.list.Pair;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.box.collection.LittleBoxesSimple;

public class LittleLevelScanner {
    public static LittleBoxes scan(Level level, BlockPos pos, @Nullable BiFilter<IParentCollection, LittleTile> filter) {
        LittleBoxesSimple boxes = new LittleBoxesSimple(pos, LittleGrid.MIN);
        BETiles te = BlockTile.loadBE((BlockGetter)level, pos);
        if (te == null) {
            return boxes;
        }
        for (Pair<IParentCollection, LittleTile> pair : te.allTiles()) {
            if (filter != null && !filter.is((Object)((IParentCollection)pair.key), (Object)((LittleTile)pair.value))) continue;
            boxes.addBoxes((IParentCollection)pair.key, (LittleTile)pair.value);
        }
        return boxes;
    }

    public static LittleBoxes scan(Level level, BlockPos pos, BlockPos pos2, @Nullable BiFilter<IParentCollection, LittleTile> filter) {
        LittleBoxesSimple boxes = new LittleBoxesSimple(pos, LittleGrid.MIN);
        int minX = Math.min(pos.getX(), pos2.getX());
        int maxX = Math.max(pos.getX(), pos2.getX());
        int minY = Math.min(pos.getY(), pos2.getY());
        int maxY = Math.max(pos.getY(), pos2.getY());
        int minZ = Math.min(pos.getZ(), pos2.getZ());
        int maxZ = Math.max(pos.getZ(), pos2.getZ());
        BlockPos.MutableBlockPos position = new BlockPos.MutableBlockPos();
        for (int posX = minX; posX <= maxX; ++posX) {
            for (int posY = minY; posY <= maxY; ++posY) {
                for (int posZ = minZ; posZ <= maxZ; ++posZ) {
                    position.set(posX, posY, posZ);
                    BETiles te = BlockTile.loadBE((BlockGetter)level, (BlockPos)position);
                    if (te == null) continue;
                    for (Pair<IParentCollection, LittleTile> pair : te.allTiles()) {
                        if (filter != null && !filter.is((Object)((IParentCollection)pair.key), (Object)((LittleTile)pair.value))) continue;
                        boxes.addBoxes((IParentCollection)pair.key, (LittleTile)pair.value);
                    }
                }
            }
        }
        return boxes;
    }
}

