/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.level.little;

import java.util.function.Consumer;
import net.minecraft.network.PacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.server.player.LittleServerPlayerConnection;
import team.creative.littletiles.server.player.LittleServerPlayerHandler;

public class LittlePlayerConnection {
    @OnlyIn(value=Dist.CLIENT)
    private static void runInContextClient(LittleLevel level, Player player, Consumer<PacketListener> consumer) {
        LittleTilesClient.PLAYER_CONNECTION.runInContext(level, x -> consumer.accept((PacketListener)x));
    }

    public static void runInContext(LittleLevel level, Player player, Consumer<PacketListener> consumer) {
        if (level.isClientSide()) {
            LittlePlayerConnection.runInContextClient(level, player, consumer);
        } else {
            LittleServerPlayerConnection.runInContext(level, (ServerPlayer)player, (LittleServerPlayerHandler x) -> consumer.accept((PacketListener)x));
        }
    }
}

