/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.box;

import java.util.ArrayList;
import java.util.List;
import team.creative.creativecore.common.util.math.vec.RangedBitSet;
import team.creative.creativecore.common.util.type.set.LineBitSet;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleBoxSorting;
import team.creative.littletiles.common.math.vec.SplitRangeBoxes;

public class LittleBoxCombiner {
    private static List<RangedBitSet.BitRange> ranges(LineBitSet set) {
        ArrayList<RangedBitSet.BitRange> ranges = new ArrayList<RangedBitSet.BitRange>();
        int start = Integer.MIN_VALUE;
        for (Integer index : set) {
            if (start == Integer.MIN_VALUE) {
                start = index;
                continue;
            }
            ranges.add(new RangedBitSet.BitRange(start, index.intValue()));
            start = index;
        }
        return ranges;
    }

    public static boolean separate(LittleGrid grid, List<LittleBox> boxes, boolean sort) {
        LineBitSet xAxis = new LineBitSet();
        LineBitSet yAxis = new LineBitSet();
        LineBitSet zAxis = new LineBitSet();
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (LittleBox box : boxes) {
            xAxis.set(box.minX, true);
            xAxis.set(box.maxX, true);
            yAxis.set(box.minY, true);
            yAxis.set(box.maxY, true);
            zAxis.set(box.minZ, true);
            zAxis.set(box.maxZ, true);
            minX = Math.min(minX, box.minX);
            minY = Math.min(minY, box.minY);
            minZ = Math.min(minZ, box.minZ);
            maxX = Math.max(maxX, box.maxX);
            maxY = Math.max(maxY, box.maxY);
            maxZ = Math.max(maxZ, box.maxZ);
        }
        SplitRangeBoxes ranges = new SplitRangeBoxes(LittleBoxCombiner.ranges(xAxis), LittleBoxCombiner.ranges(yAxis), LittleBoxCombiner.ranges(zAxis));
        ArrayList<LittleBox> original = new ArrayList<LittleBox>(boxes);
        boxes.clear();
        block1: for (LittleBox box : original) {
            for (SplitRangeBoxes.SplitRangeBox range : ranges) {
                if (!range.intersectsWith(box)) continue;
                if (range.isSame(box)) {
                    boxes.add(box);
                    continue block1;
                }
                LittleBox splitted = box.extractBox(grid, range.x.min(), range.y.min(), range.z.min(), range.x.max(), range.y.max(), range.z.max(), null);
                if (splitted == null) continue;
                boxes.add(splitted);
            }
        }
        if (sort) {
            LittleBox.sortListByPosition(boxes, minX, minY, minZ, maxX, maxY, maxZ, LittleBoxSorting.XYZ);
        }
        return original.size() != boxes.size();
    }

    public static boolean combine(List<LittleBox> boxes) {
        int sizeBefore = boxes.size();
        boolean modified = true;
        while (modified) {
            modified = false;
            for (int i = 0; i < boxes.size(); ++i) {
                int j = 0;
                while (j < boxes.size()) {
                    LittleBox box;
                    if (i != j && (box = boxes.get(i).combineBoxes(boxes.get(j))) != null) {
                        boxes.set(i, box);
                        boxes.remove(j);
                        modified = true;
                        if (i <= j) continue;
                        --i;
                        continue;
                    }
                    ++j;
                }
            }
        }
        return sizeBefore != boxes.size();
    }

    public static boolean combineLast(List<LittleBox> boxes) {
        int sizeBefore = boxes.size();
        boolean modified = true;
        while (modified) {
            modified = false;
            for (int i = boxes.size() - 1; i < boxes.size(); ++i) {
                int j = 0;
                while (j < boxes.size()) {
                    LittleBox box;
                    if (i != j && (box = boxes.get(i).combineBoxes(boxes.get(j))) != null) {
                        boxes.set(i, box);
                        boxes.remove(j);
                        modified = true;
                        if (i <= j) continue;
                        --i;
                        continue;
                    }
                    ++j;
                }
            }
        }
        return sizeBefore != boxes.size();
    }
}

