/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.box;

import team.creative.littletiles.common.grid.IGridBased;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVecGrid;

public class LittleBoxGrid
implements IGridBased {
    protected LittleBox box;
    protected LittleGrid grid;

    public LittleBoxGrid(LittleBox box, LittleGrid grid) {
        this.box = box;
        this.grid = grid;
    }

    @Override
    public LittleGrid getGrid() {
        return this.grid;
    }

    @Override
    public void convertTo(LittleGrid to) {
        this.box.convertTo(this.grid, to);
        this.grid = to;
    }

    @Override
    public int getSmallest() {
        return this.box.getSmallest(this.grid);
    }

    public void add(LittleVecGrid vec) {
        this.sameGrid((IGridBased)vec, () -> this.box.add(vec.getVec()));
    }

    public void sub(LittleVecGrid vec) {
        this.sameGrid((IGridBased)vec, () -> this.box.sub(vec.getVec()));
    }

    public LittleBoxGrid copy() {
        return new LittleBoxGrid(this.box.copy(), this.grid);
    }

    public LittleBox getBox() {
        return this.box;
    }

    public void setBox(LittleBox box) {
        this.box = box;
    }

    public LittleVecGrid getMin() {
        return new LittleVecGrid(this.box.getMinVec(), this.grid);
    }

    public LittleVecGrid getSize() {
        return new LittleVecGrid(this.box.getSize(), this.grid);
    }
}

