/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.vec;

import java.security.InvalidParameterException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;
import team.creative.creativecore.common.util.math.matrix.IntMatrix3c;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.common.grid.IGridBased;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.vec.LittleVec;

public class LittleVecGrid
implements IGridBased {
    protected LittleVec vec;
    protected LittleGrid grid;

    public LittleVecGrid() {
        this(new LittleVec(0, 0, 0), LittleGrid.MIN);
    }

    public LittleVecGrid(String name, CompoundTag nbt) {
        int[] array = nbt.getIntArray(name);
        if (array.length == 3) {
            LittleVec vec = new LittleVec(name, nbt);
            this.grid = LittleGrid.overallDefault();
            this.vec = new LittleVec(vec.x, vec.y, vec.z);
        } else if (array.length == 4) {
            this.vec = new LittleVec(array[0], array[1], array[2]);
            this.grid = LittleGrid.get(array[3]);
        } else {
            throw new InvalidParameterException("No valid coords given " + String.valueOf(nbt));
        }
    }

    public LittleVecGrid(LittleVec vec, LittleGrid grid) {
        this.vec = vec;
        this.grid = grid;
    }

    @Override
    public LittleGrid getGrid() {
        return this.grid;
    }

    @Override
    public void convertTo(LittleGrid to) {
        this.vec.convertTo(this.grid, to);
        this.grid = to;
    }

    @Override
    public int getSmallest() {
        return this.vec.getSmallest(this.grid);
    }

    public void add(LittleVecGrid vec) {
        this.sameGrid((IGridBased)vec, () -> this.vec.add(vec.vec));
    }

    public void add(BlockPos pos) {
        this.vec.add(pos, this.grid);
    }

    public void sub(LittleVecGrid vec) {
        this.sameGrid((IGridBased)vec, () -> this.vec.sub(vec.vec));
    }

    public void sub(BlockPos pos) {
        this.vec.sub(pos, this.grid);
    }

    public LittleVecGrid copy() {
        return new LittleVecGrid(this.vec.copy(), this.grid);
    }

    public BlockPos getBlockPos() {
        return this.vec.getBlockPos(this.grid);
    }

    public double getPosX() {
        return this.vec.getPosX(this.grid);
    }

    public double getPosY() {
        return this.vec.getPosY(this.grid);
    }

    public double getPosZ() {
        return this.vec.getPosZ(this.grid);
    }

    public LittleVec getVec() {
        return this.vec;
    }

    public Vec3d getVec3d() {
        return this.vec.getVec(this.grid);
    }

    public Vec3 getVector() {
        return this.vec.getVector(this.grid);
    }

    public LittleVec getVec(LittleGrid grid) {
        if (grid == this.grid) {
            return this.vec.copy();
        }
        LittleVec newVec = this.vec.copy();
        newVec.convertTo(this.grid, grid);
        return newVec;
    }

    public void writeToNBT(String name, CompoundTag nbt) {
        nbt.putIntArray(name, new int[]{this.vec.x, this.vec.y, this.vec.z, this.grid.count});
    }

    public int hashCode() {
        return this.vec.hashCode();
    }

    @Deprecated
    public void overwriteGrid(LittleGrid grid) {
        this.grid = grid;
    }

    public boolean equals(Object paramObject) {
        if (paramObject instanceof LittleVecGrid) {
            LittleVecGrid otherVec = (LittleVecGrid)paramObject;
            LittleGrid oldContext = this.grid;
            LittleGrid oldContextPos = otherVec.grid;
            if (this.getGrid() != otherVec.getGrid()) {
                if (this.getGrid().count > otherVec.getGrid().count) {
                    otherVec.convertTo(this.getGrid());
                } else {
                    this.convertTo(otherVec.getGrid());
                }
            }
            boolean equal = this.grid == otherVec.grid && this.vec.equals(otherVec.vec);
            otherVec.convertTo(oldContextPos);
            this.convertTo(oldContext);
            return equal;
        }
        return super.equals(paramObject);
    }

    public String toString() {
        return "[" + this.vec.x + "," + this.vec.y + "," + this.vec.z + ",grid:" + this.grid.count + "]";
    }

    public void invert() {
        this.vec.invert();
    }

    public LittleVecGrid calculateCenter() {
        return new LittleVecGrid(this.vec.calculateCenter(), this.grid);
    }

    public LittleVecGrid calculateInvertedCenter() {
        return new LittleVecGrid(this.vec.calculateInvertedCenter(), this.grid);
    }

    public void transform(IntMatrix3c matrix) {
        this.vec.transform(matrix);
    }

    public void transformABS(IntMatrix3c matrix) {
        this.vec.transform(matrix);
        this.vec.x = Math.abs(this.vec.x);
        this.vec.y = Math.abs(this.vec.y);
        this.vec.z = Math.abs(this.vec.z);
    }
}

