/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.math.vec;

import java.util.Iterator;
import java.util.List;
import team.creative.creativecore.common.util.math.vec.RangedBitSet;
import team.creative.littletiles.common.math.box.LittleBox;

public class SplitRangeBoxes
implements Iterable<SplitRangeBox> {
    protected List<RangedBitSet.BitRange> xList;
    protected List<RangedBitSet.BitRange> yList;
    protected List<RangedBitSet.BitRange> zList;

    public SplitRangeBoxes(RangedBitSet x, RangedBitSet y, RangedBitSet z) {
        this.xList = x.getRanges();
        this.yList = y.getRanges();
        this.zList = z.getRanges();
    }

    public SplitRangeBoxes(List<RangedBitSet.BitRange> xList, List<RangedBitSet.BitRange> yList, List<RangedBitSet.BitRange> zList) {
        this.xList = xList;
        this.yList = yList;
        this.zList = zList;
    }

    @Override
    public Iterator<SplitRangeBox> iterator() {
        final SplitRangeBox box = new SplitRangeBox();
        return new Iterator<SplitRangeBox>(){
            public int x = 0;
            public int y = 0;
            public int z = 0;
            public int total;
            public int current;
            {
                this.total = SplitRangeBoxes.this.xList.size() * SplitRangeBoxes.this.yList.size() * SplitRangeBoxes.this.zList.size();
                this.current = 0;
            }

            @Override
            public boolean hasNext() {
                return this.current < this.total;
            }

            @Override
            public SplitRangeBox next() {
                box.set(SplitRangeBoxes.this.xList.get(this.x), SplitRangeBoxes.this.yList.get(this.y), SplitRangeBoxes.this.zList.get(this.z));
                ++this.z;
                if (this.z >= SplitRangeBoxes.this.zList.size()) {
                    ++this.y;
                    this.z = 0;
                    if (this.y >= SplitRangeBoxes.this.yList.size()) {
                        ++this.x;
                        this.y = 0;
                    }
                }
                ++this.current;
                return box;
            }
        };
    }

    public static class SplitRangeBox {
        public RangedBitSet.BitRange x;
        public RangedBitSet.BitRange y;
        public RangedBitSet.BitRange z;

        public void set(RangedBitSet.BitRange x, RangedBitSet.BitRange y, RangedBitSet.BitRange z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean intersectsWith(LittleBox box) {
            return box.maxX > this.x.min() && box.minX < this.x.max() && box.maxY > this.y.min() && box.minY < this.y.max() && box.maxZ > this.z.min() && box.minZ < this.z.max();
        }

        public boolean isSame(LittleBox box) {
            return box.minX == this.x.min() && box.maxX == this.x.max() && box.minY == this.y.min() && box.maxY == this.y.max() && box.minZ == this.z.min() && box.maxZ == this.z.max();
        }
    }
}

