/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.packet;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import org.jetbrains.annotations.Nullable;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.network.type.NetworkFieldType;
import team.creative.creativecore.common.network.type.NetworkFieldTypeClass;
import team.creative.creativecore.common.network.type.NetworkFieldTypes;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.type.Bunch;
import team.creative.creativecore.common.util.type.map.HashMapList;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.collection.LittleCollection;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupAbsolute;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupHolder;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleBoxAbsolute;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.box.collection.LittleBoxesNoOverlap;
import team.creative.littletiles.common.math.box.collection.LittleBoxesSimple;
import team.creative.littletiles.common.math.location.StructureLocation;
import team.creative.littletiles.common.math.location.TileLocation;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecAbsolute;
import team.creative.littletiles.common.math.vec.LittleVecGrid;
import team.creative.littletiles.common.packet.entity.animation.LittleBlockChange;
import team.creative.littletiles.common.placement.PlacementPosition;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.placement.setting.PlacementPlayerSetting;
import team.creative.littletiles.common.structure.animation.AnimationTimeline;
import team.creative.littletiles.common.structure.relative.StructureAbsolute;
import team.creative.littletiles.common.structure.relative.StructureRelative;
import team.creative.littletiles.common.structure.signal.SignalState;

public class LittlePacketTypes {
    public static void init() {
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<TileLocation>(){

            protected void writeContent(TileLocation content, RegistryFriendlyByteBuf buffer) {
                buffer.writeBlockPos(content.pos);
                buffer.writeBoolean(content.isStructure);
                buffer.writeInt(content.index);
                NetworkFieldTypes.writeIntArray((int[])content.box.getArray(), (RegistryFriendlyByteBuf)buffer);
                if (content.levelUUID != null) {
                    buffer.writeBoolean(true);
                    buffer.writeUUID(content.levelUUID);
                } else {
                    buffer.writeBoolean(false);
                }
            }

            protected TileLocation readContent(RegistryFriendlyByteBuf buffer) {
                BlockPos pos = buffer.readBlockPos();
                boolean isStructure = buffer.readBoolean();
                int index = buffer.readInt();
                int[] boxArray = NetworkFieldTypes.readIntArray((RegistryFriendlyByteBuf)buffer);
                UUID level = null;
                if (buffer.readBoolean()) {
                    level = buffer.readUUID();
                }
                return new TileLocation(pos, isStructure, index, LittleBox.create(boxArray), level);
            }
        }, TileLocation.class);
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<StructureLocation>(){

            protected void writeContent(StructureLocation content, RegistryFriendlyByteBuf buffer) {
                buffer.writeBlockPos(content.pos);
                buffer.writeInt(content.index);
                if (content.levelUUID != null) {
                    buffer.writeBoolean(true);
                    buffer.writeUUID(content.levelUUID);
                } else {
                    buffer.writeBoolean(false);
                }
            }

            protected StructureLocation readContent(RegistryFriendlyByteBuf buffer) {
                BlockPos pos = buffer.readBlockPos();
                int index = buffer.readInt();
                UUID level = null;
                if (buffer.readBoolean()) {
                    level = buffer.readUUID();
                }
                return new StructureLocation(pos, index, level);
            }
        }, StructureLocation.class);
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<LittleTile>(){

            protected void writeContent(LittleTile content, RegistryFriendlyByteBuf buffer) {
                buffer.writeInt(content.size());
                for (LittleBox box : content) {
                    NetworkFieldTypes.writeIntArray((int[])box.getArray(), (RegistryFriendlyByteBuf)buffer);
                }
                buffer.writeUtf(content.getBlockName());
                buffer.writeInt(content.color);
            }

            protected LittleTile readContent(RegistryFriendlyByteBuf buffer) {
                int size = buffer.readInt();
                ArrayList<LittleBox> boxes = new ArrayList<LittleBox>(size);
                for (int i = 0; i < size; ++i) {
                    boxes.add(LittleBox.create(NetworkFieldTypes.readIntArray((RegistryFriendlyByteBuf)buffer)));
                }
                return new LittleTile(buffer.readUtf(), buffer.readInt(), boxes);
            }
        }, LittleTile.class);
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<LittleCollection>(){

            protected void writeContent(LittleCollection content, RegistryFriendlyByteBuf buffer) {
                buffer.writeInt(content.size());
                for (LittleTile tile : content) {
                    NetworkFieldTypes.write(LittleTile.class, (Object)tile, (RegistryFriendlyByteBuf)buffer, null);
                }
            }

            protected LittleCollection readContent(RegistryFriendlyByteBuf buffer) {
                int size = buffer.readInt();
                LittleCollection collection = new LittleCollection();
                for (int i = 0; i < size; ++i) {
                    collection.add((LittleTile)NetworkFieldTypes.read(LittleTile.class, (RegistryFriendlyByteBuf)buffer, null));
                }
                return collection;
            }
        }, LittleCollection.class);
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<LittleGroup>(){

            protected void writeContent(LittleGroup content, RegistryFriendlyByteBuf buffer) {
                if (content instanceof LittleGroupHolder) {
                    throw new RuntimeException("LittleGroupHolder cannot be send across the network");
                }
                buffer.writeInt(content.children.sizeChildren());
                for (LittleGroup littleGroup : content.children.children()) {
                    NetworkFieldTypes.write(LittleGroup.class, (Object)littleGroup, (RegistryFriendlyByteBuf)buffer, null);
                }
                buffer.writeInt(content.getGrid().count);
                if (content.hasStructure()) {
                    buffer.writeBoolean(true);
                    buffer.writeNbt((Tag)content.getStructureTag());
                } else {
                    buffer.writeBoolean(false);
                }
                NetworkFieldTypes.writeMany(LittleTile.class, (Bunch)content, (RegistryFriendlyByteBuf)buffer, null);
                buffer.writeInt(content.children.sizeExtensions());
                for (Map.Entry entry : content.children.extensionEntries()) {
                    buffer.writeUtf((String)entry.getKey());
                    NetworkFieldTypes.write(LittleGroup.class, (Object)((LittleGroup)entry.getValue()), (RegistryFriendlyByteBuf)buffer, null);
                }
            }

            protected LittleGroup readContent(RegistryFriendlyByteBuf buffer) {
                int size = buffer.readInt();
                ArrayList<LittleGroup> children = new ArrayList<LittleGroup>(size);
                for (int i = 0; i < size; ++i) {
                    children.add((LittleGroup)NetworkFieldTypes.read(LittleGroup.class, (RegistryFriendlyByteBuf)buffer, null));
                }
                LittleGrid grid = LittleGrid.get(buffer.readInt());
                LittleGroup group = new LittleGroup(buffer.readBoolean() ? (CompoundTag)buffer.readNbt(NbtAccounter.unlimitedHeap()) : null, children);
                group.addAll(grid, NetworkFieldTypes.readMany(LittleTile.class, (RegistryFriendlyByteBuf)buffer, null));
                int extensionCount = buffer.readInt();
                for (int i = 0; i < extensionCount; ++i) {
                    group.children.addExtension(buffer.readUtf(), (LittleGroup)NetworkFieldTypes.read(LittleGroup.class, (RegistryFriendlyByteBuf)buffer, null));
                }
                return group;
            }
        }, LittleGroup.class);
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<LittleGroupAbsolute>(){

            protected void writeContent(LittleGroupAbsolute content, RegistryFriendlyByteBuf buffer) {
                buffer.writeBlockPos(content.pos);
                NetworkFieldTypes.write(LittleGroup.class, (Object)content.group, (RegistryFriendlyByteBuf)buffer, null);
            }

            protected LittleGroupAbsolute readContent(RegistryFriendlyByteBuf buffer) {
                return new LittleGroupAbsolute(buffer.readBlockPos(), (LittleGroup)NetworkFieldTypes.read(LittleGroup.class, (RegistryFriendlyByteBuf)buffer, null));
            }
        }, LittleGroupAbsolute.class);
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<PlacementMode>(){

            protected void writeContent(PlacementMode content, RegistryFriendlyByteBuf buffer) {
                buffer.writeUtf(content.getId());
            }

            protected PlacementMode readContent(RegistryFriendlyByteBuf buffer) {
                return PlacementMode.getMode(buffer.readUtf());
            }
        }, PlacementMode.class);
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldType<LittleAction>(){

            public void write(LittleAction content, Class classType, @Nullable Type genericType, RegistryFriendlyByteBuf buffer, PacketFlow flow) {
                buffer.writeUtf(((Object)((Object)content)).getClass().getName());
                LittleTiles.NETWORK.getType(((Object)((Object)content)).getClass()).write((CreativePacket)content, buffer, flow);
            }

            public LittleAction read(Class classType, @Nullable Type genericType, RegistryFriendlyByteBuf buffer, PacketFlow flow) {
                try {
                    Class<?> clazz = Class.forName(buffer.readUtf());
                    return (LittleAction)LittleTiles.NETWORK.getType(clazz).read(buffer, flow);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
        }, LittleAction.class);
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<LittleGrid>(){

            protected void writeContent(LittleGrid content, RegistryFriendlyByteBuf buffer) {
                buffer.writeInt(content.count);
            }

            protected LittleGrid readContent(RegistryFriendlyByteBuf buffer) {
                return LittleGrid.get(buffer.readInt());
            }
        }, LittleGrid.class);
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<LittleVec>(){

            protected void writeContent(LittleVec vec, RegistryFriendlyByteBuf buffer) {
                buffer.writeInt(vec.x);
                buffer.writeInt(vec.y);
                buffer.writeInt(vec.z);
            }

            protected LittleVec readContent(RegistryFriendlyByteBuf buffer) {
                return new LittleVec(buffer.readInt(), buffer.readInt(), buffer.readInt());
            }
        }, LittleVec.class);
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<LittleVecGrid>(){

            protected void writeContent(LittleVecGrid vec, RegistryFriendlyByteBuf buffer) {
                buffer.writeInt(vec.getVec().x);
                buffer.writeInt(vec.getVec().y);
                buffer.writeInt(vec.getVec().z);
                buffer.writeInt(vec.getGrid().count);
            }

            protected LittleVecGrid readContent(RegistryFriendlyByteBuf buffer) {
                return new LittleVecGrid(new LittleVec(buffer.readInt(), buffer.readInt(), buffer.readInt()), LittleGrid.get(buffer.readInt()));
            }
        }, LittleVecGrid.class);
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<LittleVecAbsolute>(){

            protected void writeContent(LittleVecAbsolute content, RegistryFriendlyByteBuf buffer) {
                buffer.writeBlockPos(content.getPos());
                NetworkFieldTypes.write(LittleVecGrid.class, (Object)content.getVecGrid(), (RegistryFriendlyByteBuf)buffer, null);
            }

            protected LittleVecAbsolute readContent(RegistryFriendlyByteBuf buffer) {
                return new LittleVecAbsolute(buffer.readBlockPos(), (LittleVecGrid)NetworkFieldTypes.read(LittleVecGrid.class, (RegistryFriendlyByteBuf)buffer, null));
            }
        }, LittleVecAbsolute.class);
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<PlacementPosition>(){

            protected void writeContent(PlacementPosition content, RegistryFriendlyByteBuf buffer) {
                buffer.writeBlockPos(content.getPos());
                NetworkFieldTypes.write(LittleVecGrid.class, (Object)content.getVecGrid(), (RegistryFriendlyByteBuf)buffer, null);
                buffer.writeInt(content.facing == null ? -1 : content.facing.ordinal());
            }

            protected PlacementPosition readContent(RegistryFriendlyByteBuf buffer) {
                return new PlacementPosition(buffer.readBlockPos(), (LittleVecGrid)NetworkFieldTypes.read(LittleVecGrid.class, (RegistryFriendlyByteBuf)buffer, null), this.readFacing(buffer.readInt()));
            }

            private Facing readFacing(int facing) {
                if (facing == -1) {
                    return null;
                }
                return Facing.VALUES[facing];
            }
        }, PlacementPosition.class);
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<LittleBox>(){

            protected void writeContent(LittleBox content, RegistryFriendlyByteBuf buffer) {
                NetworkFieldTypes.writeIntArray((int[])content.getArray(), (RegistryFriendlyByteBuf)buffer);
            }

            protected LittleBox readContent(RegistryFriendlyByteBuf buffer) {
                return LittleBox.create(NetworkFieldTypes.readIntArray((RegistryFriendlyByteBuf)buffer));
            }
        }, LittleBox.class);
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<LittleBoxAbsolute>(){

            protected void writeContent(LittleBoxAbsolute content, RegistryFriendlyByteBuf buffer) {
                buffer.writeBlockPos(content.pos);
                NetworkFieldTypes.writeIntArray((int[])content.box.getArray(), (RegistryFriendlyByteBuf)buffer);
                buffer.writeInt(content.getGrid().count);
            }

            protected LittleBoxAbsolute readContent(RegistryFriendlyByteBuf buffer) {
                return new LittleBoxAbsolute(buffer.readBlockPos(), LittleBox.create(NetworkFieldTypes.readIntArray((RegistryFriendlyByteBuf)buffer)), LittleGrid.get(buffer.readInt()));
            }
        }, LittleBoxAbsolute.class);
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<StructureRelative>(){

            protected void writeContent(StructureRelative content, RegistryFriendlyByteBuf buffer) {
                NetworkFieldTypes.writeIntArray((int[])content.getBox().getArray(), (RegistryFriendlyByteBuf)buffer);
                buffer.writeInt(content.getGrid().count);
            }

            protected StructureRelative readContent(RegistryFriendlyByteBuf buffer) {
                return new StructureRelative(LittleBox.create(NetworkFieldTypes.readIntArray((RegistryFriendlyByteBuf)buffer)), LittleGrid.get(buffer.readInt()));
            }
        }, (Class[])new Class[]{StructureAbsolute.class});
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<StructureAbsolute>(){

            protected void writeContent(StructureAbsolute content, RegistryFriendlyByteBuf buffer) {
                buffer.writeBlockPos(content.baseOffset);
                NetworkFieldTypes.writeIntArray((int[])content.getBox().getArray(), (RegistryFriendlyByteBuf)buffer);
                buffer.writeInt(content.getGrid().count);
            }

            protected StructureAbsolute readContent(RegistryFriendlyByteBuf buffer) {
                return new StructureAbsolute(buffer.readBlockPos(), LittleBox.create(NetworkFieldTypes.readIntArray((RegistryFriendlyByteBuf)buffer)), LittleGrid.get(buffer.readInt()));
            }
        }, StructureAbsolute.class);
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<LittleBoxes>(){

            protected void writeContent(LittleBoxes content, RegistryFriendlyByteBuf buffer) {
                buffer.writeBlockPos(content.pos);
                buffer.writeInt(content.grid.count);
                if (content instanceof LittleBoxesSimple) {
                    buffer.writeBoolean(true);
                    buffer.writeInt(content.size());
                    for (LittleBox box : content.all()) {
                        NetworkFieldTypes.writeIntArray((int[])box.getArray(), (RegistryFriendlyByteBuf)buffer);
                    }
                } else {
                    buffer.writeBoolean(false);
                    HashMapList<BlockPos, LittleBox> map = content.generateBlockWise();
                    buffer.writeInt(map.size());
                    for (Map.Entry entry : map.entrySet()) {
                        buffer.writeBlockPos((BlockPos)entry.getKey());
                        buffer.writeInt(((ArrayList)entry.getValue()).size());
                        for (LittleBox box : (ArrayList)entry.getValue()) {
                            NetworkFieldTypes.writeIntArray((int[])box.getArray(), (RegistryFriendlyByteBuf)buffer);
                        }
                    }
                }
            }

            protected LittleBoxes readContent(RegistryFriendlyByteBuf buffer) {
                BlockPos pos = buffer.readBlockPos();
                LittleGrid grid = LittleGrid.get(buffer.readInt());
                if (buffer.readBoolean()) {
                    LittleBoxesSimple boxes = new LittleBoxesSimple(pos, grid);
                    int length = buffer.readInt();
                    for (int i = 0; i < length; ++i) {
                        ((LittleBoxes)boxes).add(LittleBox.create(NetworkFieldTypes.readIntArray((RegistryFriendlyByteBuf)buffer)));
                    }
                    return boxes;
                }
                int posCount = buffer.readInt();
                HashMapList map = new HashMapList();
                for (int i = 0; i < posCount; ++i) {
                    BlockPos posList = buffer.readBlockPos();
                    int boxCount = buffer.readInt();
                    ArrayList<LittleBox> blockBoxes = new ArrayList<LittleBox>();
                    for (int j = 0; j < boxCount; ++j) {
                        blockBoxes.add(LittleBox.create(NetworkFieldTypes.readIntArray((RegistryFriendlyByteBuf)buffer)));
                    }
                    map.add((Object)posList, blockBoxes);
                }
                return new LittleBoxesNoOverlap(pos, grid, (HashMapList<BlockPos, LittleBox>)map);
            }
        }, (Class[])new Class[]{LittleBoxes.class, LittleBoxesNoOverlap.class, LittleBoxesSimple.class});
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<PlacementPreview>(){

            protected void writeContent(PlacementPreview content, RegistryFriendlyByteBuf buffer) {
                if (content.levelUUID != null) {
                    buffer.writeBoolean(true);
                    buffer.writeUUID(content.levelUUID);
                } else {
                    buffer.writeBoolean(false);
                }
                NetworkFieldTypes.write(LittleGroup.class, (Object)content.previews, (RegistryFriendlyByteBuf)buffer, null);
                NetworkFieldTypes.write(PlacementMode.class, (Object)content.mode, (RegistryFriendlyByteBuf)buffer, null);
                NetworkFieldTypes.write(PlacementPosition.class, (Object)content.position, (RegistryFriendlyByteBuf)buffer, null);
            }

            protected PlacementPreview readContent(RegistryFriendlyByteBuf buffer) {
                return PlacementPreview.load(buffer.readBoolean() ? buffer.readUUID() : null, (LittleGroup)NetworkFieldTypes.read(LittleGroup.class, (RegistryFriendlyByteBuf)buffer, null), (PlacementMode)NetworkFieldTypes.read(PlacementMode.class, (RegistryFriendlyByteBuf)buffer, null), (PlacementPosition)NetworkFieldTypes.read(PlacementPosition.class, (RegistryFriendlyByteBuf)buffer, null));
            }
        }, PlacementPreview.class);
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<SignalState>(){

            protected void writeContent(SignalState content, RegistryFriendlyByteBuf buffer) {
                content.write((FriendlyByteBuf)buffer);
            }

            protected SignalState readContent(RegistryFriendlyByteBuf buffer) {
                return SignalState.read((FriendlyByteBuf)buffer);
            }
        }, SignalState.class);
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<LittleBlockChange>(){

            protected void writeContent(LittleBlockChange content, RegistryFriendlyByteBuf buffer) {
                buffer.writeBlockPos(content.pos());
                if (content.block() != null) {
                    buffer.writeBoolean(true);
                    buffer.writeNbt((Tag)content.block());
                } else {
                    buffer.writeBoolean(false);
                }
            }

            protected LittleBlockChange readContent(RegistryFriendlyByteBuf buffer) {
                return new LittleBlockChange(buffer.readBlockPos(), buffer.readBoolean() ? (CompoundTag)buffer.readNbt(NbtAccounter.unlimitedHeap()) : null);
            }
        }, LittleBlockChange.class);
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<AnimationTimeline>(){

            protected void writeContent(AnimationTimeline content, RegistryFriendlyByteBuf buffer) {
                buffer.writeNbt((Tag)content.save());
            }

            protected AnimationTimeline readContent(RegistryFriendlyByteBuf buffer) {
                return new AnimationTimeline((CompoundTag)buffer.readNbt(NbtAccounter.unlimitedHeap()));
            }
        }, AnimationTimeline.class);
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<PlacementPlayerSetting>(){

            protected void writeContent(PlacementPlayerSetting content, RegistryFriendlyByteBuf buffer) {
                buffer.writeNbt((Tag)content.save());
            }

            protected PlacementPlayerSetting readContent(RegistryFriendlyByteBuf buffer) {
                return new PlacementPlayerSetting((CompoundTag)buffer.readNbt(NbtAccounter.unlimitedHeap()));
            }
        }, PlacementPlayerSetting.class);
    }
}

