/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.packet.action;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.creativecore.common.network.CanBeNull;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.mc.PlayerUtils;
import team.creative.creativecore.common.util.mc.TickUtils;
import team.creative.creativecore.common.util.type.itr.FunctionIterator;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.api.common.tool.ILittlePlacer;
import team.creative.littletiles.api.common.tool.ILittleTool;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;

public class BlockPacket
extends CreativePacket {
    public BlockPos blockPos;
    public Vec3 pos;
    public Vec3 look;
    public BlockPacketAction action;
    public CompoundTag nbt;
    @CanBeNull
    public UUID uuid;

    public BlockPacket() {
    }

    public BlockPacket(Level level, BlockPos blockPos, Player player, BlockPacketAction action) {
        this(level, blockPos, player, action, new CompoundTag());
    }

    public BlockPacket(Level level, BlockPos blockPos, Player player, BlockPacketAction action, CompoundTag nbt) {
        this.blockPos = blockPos;
        this.action = action;
        float partialTickTime = TickUtils.getFrameTime((LevelAccessor)level);
        this.pos = player.getEyePosition(partialTickTime);
        double distance = PlayerUtils.getReach((Player)player);
        Vec3 view = player.getViewVector(partialTickTime);
        this.look = this.pos.add(view.x * distance, view.y * distance, view.z * distance);
        this.nbt = nbt;
        if (level instanceof ISubLevel) {
            ISubLevel subLevel = (ISubLevel)level;
            this.uuid = subLevel.getHolder().getUUID();
        }
    }

    public void executeClient(Player player) {
    }

    public void executeServer(ServerPlayer player) {
        BlockEntity blockEntity;
        Object level = player.level();
        if (this.uuid != null) {
            LittleEntity entity = LittleTiles.ANIMATION_HANDLERS.find(false, this.uuid);
            if (entity == null) {
                return;
            }
            if (!LittleAction.isAllowedToInteract((Player)player, entity, this.action.rightClick)) {
                return;
            }
            level = entity.getSubLevel();
            this.pos = entity.getOrigin().transformPointToFakeWorld(this.pos);
            this.look = entity.getOrigin().transformPointToFakeWorld(this.look);
        }
        if ((blockEntity = level.getBlockEntity(this.blockPos)) instanceof BETiles) {
            BETiles be = (BETiles)blockEntity;
            LittleTileContext context = be.getFocusedTile(this.pos, this.look);
            if (!LittleAction.isAllowedToInteract((LevelAccessor)level, (Player)player, this.blockPos, this.action.rightClick, Facing.EAST)) {
                LittleAction.sendBlockResetToClient((LevelAccessor)level, (Player)player, (BlockEntity)be);
                return;
            }
            if (context.isComplete()) {
                ItemStack stack = player.getMainHandItem();
                this.action.action((Level)level, be, context, stack, (Player)player, be.rayTrace(this.pos, this.look), this.blockPos, this.nbt);
                player.inventoryMenu.broadcastChanges();
            }
        }
    }

    public static enum BlockPacketAction {
        WRENCH(true){

            @Override
            public void action(Level level, BETiles be, LittleTileContext context, ItemStack stack, Player player, BlockHitResult moving, BlockPos pos, CompoundTag nbt) {
                player.sendSystemMessage((Component)Component.literal((String)("grid:" + String.valueOf(be.getGrid()))));
                be.combineAllTiles(true);
                be.convertBlockToVanilla();
                be.updateTiles();
            }
        }
        ,
        WRENCH_INFO(true){

            @Override
            public void action(Level level, BETiles be, LittleTileContext context, ItemStack stack, Player player, BlockHitResult moving, BlockPos pos, CompoundTag nbt) {
                if (context.parent.isStructure()) {
                    try {
                        String info = context.parent.getStructure().info();
                        if (!info.isEmpty()) {
                            player.sendSystemMessage((Component)Component.literal((String)info));
                        }
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                        // empty catch block
                    }
                }
            }
        }
        ,
        BLUEPRINT(false){

            @Override
            public void action(Level level, BETiles be, LittleTileContext context, ItemStack stack, Player player, BlockHitResult moving, BlockPos pos, CompoundTag nbt) {
                LittleGroup previews;
                if (((ILittlePlacer)stack.getItem()).hasTiles(stack)) {
                    return;
                }
                if (context.parent.isStructure()) {
                    if (nbt.getBoolean("secondMode")) {
                        try {
                            previews = context.parent.getStructure().getPreviews(pos);
                        }
                        catch (CorruptedConnectionException | NotYetConnectedException e) {
                            return;
                        }
                    } else {
                        try {
                            previews = context.parent.getStructure().findTopStructure().getPreviews(pos);
                        }
                        catch (CorruptedConnectionException | NotYetConnectedException e) {
                            return;
                        }
                    }
                } else {
                    previews = new LittleGroup();
                    if (nbt.getBoolean("secondMode")) {
                        for (IParentCollection collection : be.groups()) {
                            previews.addAll(be.getGrid(), (Iterable<LittleTile>)new FunctionIterator((Iterable)collection, x -> x.copy()));
                        }
                    } else {
                        previews.addTile(be.getGrid(), context.tile.copy());
                    }
                }
                ILittleTool.setData(stack, LittleGroup.save(previews));
            }
        };

        public final boolean rightClick;

        private BlockPacketAction(boolean rightClick) {
            this.rightClick = rightClick;
        }

        public abstract void action(Level var1, BETiles var2, LittleTileContext var3, ItemStack var4, Player var5, BlockHitResult var6, BlockPos var7, CompoundTag var8);
    }
}

