/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.packet.update;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.creativecore.common.network.CanBeNull;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.entity.LittleEntity;

public class BlocksUpdate
extends CreativePacket {
    public List<BlockPos> positions;
    public List<BlockState> states;
    public List<CompoundTag> tags;
    @CanBeNull
    public UUID uuid;

    public BlocksUpdate(LevelAccessor level, Set<BlockPos> positions) {
        this.positions = new ArrayList<BlockPos>(positions.size());
        this.states = new ArrayList<BlockState>(positions.size());
        this.tags = new ArrayList<CompoundTag>(positions.size());
        for (BlockPos pos : positions) {
            this.positions.add(pos);
            this.states.add(level.getBlockState(pos));
            BlockEntity be = level.getBlockEntity(pos);
            if (be != null) {
                this.tags.add(be.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess()));
                continue;
            }
            this.tags.add(null);
        }
        if (level instanceof ISubLevel) {
            ISubLevel subLevel = (ISubLevel)level;
            this.uuid = subLevel.getHolder().getUUID();
        }
    }

    public BlocksUpdate(LevelAccessor level, Iterable<? extends BlockEntity> blockEntities) {
        this.positions = new ArrayList<BlockPos>();
        this.states = new ArrayList<BlockState>();
        this.tags = new ArrayList<CompoundTag>();
        for (BlockEntity blockEntity : blockEntities) {
            this.positions.add(blockEntity.getBlockPos());
            this.states.add(level.getBlockState(blockEntity.getBlockPos()));
            this.tags.add(blockEntity.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess()));
        }
        if (level instanceof ISubLevel) {
            ISubLevel subLevel = (ISubLevel)level;
            this.uuid = subLevel.getHolder().getUUID();
        }
    }

    public BlocksUpdate() {
    }

    public void executeClient(Player player) {
        Object level = player.level();
        if (this.uuid != null) {
            LittleEntity entity = LittleTiles.ANIMATION_HANDLERS.find(true, this.uuid);
            if (entity == null) {
                return;
            }
            level = entity.getSubLevel();
        }
        for (int i = 0; i < this.positions.size(); ++i) {
            if (level instanceof ClientLevel) {
                ClientLevel c = (ClientLevel)level;
                c.setBlocksDirty(this.positions.get(i), this.states.get(i), this.states.get(i));
                if (this.tags.get(i) == null) continue;
                level.getBlockEntity(this.positions.get(i)).loadWithComponents(this.tags.get(i), (HolderLookup.Provider)level.registryAccess());
                continue;
            }
            level.setBlock(this.positions.get(i), this.states.get(i), 3);
            if (this.tags.get(i) == null) continue;
            level.getBlockEntity(this.positions.get(i)).loadWithComponents(this.tags.get(i), (HolderLookup.Provider)level.registryAccess());
        }
    }

    public void executeServer(ServerPlayer player) {
    }
}

