/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.shape;

import com.google.common.base.Objects;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.network.type.NetworkFieldType;
import team.creative.creativecore.common.network.type.NetworkFieldTypeClass;
import team.creative.creativecore.common.network.type.NetworkFieldTypes;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.ShapeRegistry;
import team.creative.littletiles.common.placement.shape.config.LittleShapeConfig;

public class LittleShapeInstance {
    public static final Codec<LittleShapeInstance> CODEC = RecordCodecBuilder.create(x -> x.group((App)Codec.STRING.fieldOf("shape").forGetter(e -> ShapeRegistry.REGISTRY.getId((Object)e.shape)), (App)CompoundTag.CODEC.fieldOf("config").forGetter(e -> e.config)).apply((Applicative)x, LittleShapeInstance::new));
    public static final StreamCodec<FriendlyByteBuf, LittleShapeInstance> STREAM_CODEC = StreamCodec.of((buffer, i) -> {
        buffer.writeUtf(ShapeRegistry.REGISTRY.getId((Object)i.shape));
        buffer.writeNbt((Tag)i.config);
    }, buffer -> new LittleShapeInstance(buffer.readUtf(), buffer.readNbt()));
    public final LittleShape shape;
    private final CompoundTag config;

    public static LittleShapeInstance of(LittleShape shape) {
        return new LittleShapeInstance(shape, new CompoundTag());
    }

    public static LittleShapeInstance getOrCreate(ItemStack stack, LittleShape defaultShape) {
        LittleShapeInstance in = (LittleShapeInstance)stack.get(LittleTilesRegistry.SHAPE);
        if (in != null) {
            return in;
        }
        return new LittleShapeInstance(defaultShape, new CompoundTag());
    }

    private LittleShapeInstance(String id, CompoundTag config) {
        this(ShapeRegistry.get(id), config);
    }

    private LittleShapeInstance(LittleShape shape, CompoundTag config) {
        this.shape = shape;
        this.config = config;
    }

    public LittleShapeConfig getConfig(HolderLookup.Provider provider, Side side) {
        return this.loadOtherConfig(provider, this.shape, side);
    }

    public LittleShapeConfig loadOtherConfig(HolderLookup.Provider provider, LittleShape shape, Side side) {
        String shapeId = ShapeRegistry.getConfig(shape);
        if (shapeId != null) {
            return (LittleShapeConfig)ShapeRegistry.SHAPE_CONFIG_REGISTRY.loadOrCreateDefault(provider, this.config, shapeId, side);
        }
        return null;
    }

    public LittleShapeInstance configure(HolderLookup.Provider provider, LittleShapeConfig config, Side side) {
        return this.configure(provider, this.shape, config, side);
    }

    public <T extends LittleShapeConfig> LittleShapeInstance configure(HolderLookup.Provider provider, LittleShape<T> shape, @Nullable T config, Side side) {
        CompoundTag tag = this.config.copy();
        if (config != null) {
            ShapeRegistry.SHAPE_CONFIG_REGISTRY.save(provider, config, tag, side);
        }
        return new LittleShapeInstance(shape, tag);
    }

    public void appendInformation(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"gui.shape").append(": ").append(this.shape.translatable()));
        LittleShapeConfig config = this.getConfig(context.registries(), Side.CLIENT);
        if (config != null) {
            tooltip.addAll(config.information());
        }
    }

    public Component translatable() {
        return this.shape.translatable();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LittleShapeInstance) {
            LittleShapeInstance i = (LittleShapeInstance)obj;
            return i.shape == this.shape && Objects.equal((Object)i.config, (Object)this.config);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.shape.hashCode() + this.config.hashCode();
    }

    static {
        NetworkFieldTypes.register((NetworkFieldType)new NetworkFieldTypeClass<LittleShapeInstance>(){

            protected void writeContent(LittleShapeInstance content, RegistryFriendlyByteBuf buffer) {
                buffer.writeUtf(content.shape.getKey());
                buffer.writeNbt((Tag)content.config);
            }

            protected LittleShapeInstance readContent(RegistryFriendlyByteBuf buffer) {
                return new LittleShapeInstance(buffer.readUtf(), buffer.readNbt());
            }
        }, LittleShapeInstance.class);
    }
}

