/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.shape;

import java.util.HashMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import team.creative.creativecore.common.util.registry.ConfigTypeRegistry;
import team.creative.creativecore.common.util.registry.NamedHandlerRegistry;
import team.creative.creativecore.common.util.type.tree.NamedTree;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.config.AxisHollowThicknessShapeConfig;
import team.creative.littletiles.common.placement.shape.config.AxisShapeConfig;
import team.creative.littletiles.common.placement.shape.config.AxisThicknessShapeConfig;
import team.creative.littletiles.common.placement.shape.config.BrushSizeShapeConfig;
import team.creative.littletiles.common.placement.shape.config.CornerShapeConfig;
import team.creative.littletiles.common.placement.shape.config.FacingShapeConfig;
import team.creative.littletiles.common.placement.shape.config.HollowThicknessConfig;
import team.creative.littletiles.common.placement.shape.config.InterpolationAxisThicknessConfig;
import team.creative.littletiles.common.placement.shape.config.InterpolationThicknessConfig;
import team.creative.littletiles.common.placement.shape.config.LittleShapeConfig;
import team.creative.littletiles.common.placement.shape.config.MatrixShapeConfig;
import team.creative.littletiles.common.placement.shape.config.PillarShapeConfig;
import team.creative.littletiles.common.placement.shape.type.LittleShapeBlob;
import team.creative.littletiles.common.placement.shape.type.LittleShapeConnected;
import team.creative.littletiles.common.placement.shape.type.LittleShapeCube;
import team.creative.littletiles.common.placement.shape.type.LittleShapeCurve;
import team.creative.littletiles.common.placement.shape.type.LittleShapeCurveWall;
import team.creative.littletiles.common.placement.shape.type.LittleShapeCylinder;
import team.creative.littletiles.common.placement.shape.type.LittleShapeDragBox;
import team.creative.littletiles.common.placement.shape.type.LittleShapeInnerCorner;
import team.creative.littletiles.common.placement.shape.type.LittleShapeOuterCorner;
import team.creative.littletiles.common.placement.shape.type.LittleShapePillar;
import team.creative.littletiles.common.placement.shape.type.LittleShapePixel;
import team.creative.littletiles.common.placement.shape.type.LittleShapePolygon;
import team.creative.littletiles.common.placement.shape.type.LittleShapePyramid;
import team.creative.littletiles.common.placement.shape.type.LittleShapeSlope;
import team.creative.littletiles.common.placement.shape.type.LittleShapeSphere;
import team.creative.littletiles.common.placement.shape.type.LittleShapeTile;
import team.creative.littletiles.common.placement.shape.type.LittleShapeType;
import team.creative.littletiles.common.placement.shape.type.LittleShapeWall;

public class ShapeRegistry {
    public static final LittleShapeTile TILE_SHAPE = new LittleShapeTile();
    public static final LittleShapeDragBox DRAG_BOX = new LittleShapeDragBox();
    public static final LittleShapeSphere DRAG_SPHERE = new LittleShapeSphere();
    public static final NamedHandlerRegistry<LittleShape> REGISTRY = new NamedHandlerRegistry((Object)DRAG_BOX);
    public static final ConfigTypeRegistry<LittleShapeConfig> SHAPE_CONFIG_REGISTRY = new ConfigTypeRegistry();
    public static final NamedTree<LittleShape> SHAPE_TREE = new NamedTree();
    private static final HashMap<String, String> SHAPE_TO_CONFIG = new HashMap();

    public static <T extends LittleShapeConfig> void registerConfig(String id, Class<T> clazz, Supplier<T> supplier) {
        SHAPE_CONFIG_REGISTRY.register(id, clazz, (Object)((LittleShapeConfig)supplier.get()), supplier);
    }

    private static LittleShape registerShapeInternal(String id, LittleShape shape, String path) {
        REGISTRY.register(id, (Object)shape);
        SHAPE_TREE.add(path + "." + id, (Object)shape);
        shape.setTranslation("shape." + path + "." + id);
        return shape;
    }

    public static LittleShape registerShape(String id, LittleShape<Void> shape, String path) {
        return ShapeRegistry.registerShapeInternal(id, shape, path);
    }

    public static <T extends LittleShapeConfig> LittleShape registerShape(String id, LittleShape<T> shape, @Nullable Class<T> configClass, String path) {
        if (configClass != null) {
            if (!SHAPE_CONFIG_REGISTRY.contains(configClass)) {
                throw new IllegalArgumentException("Config class for shape " + id + " is not registered");
            }
            SHAPE_TO_CONFIG.put(id, SHAPE_CONFIG_REGISTRY.getId(configClass));
        }
        return ShapeRegistry.registerShapeInternal(id, shape, path);
    }

    public static LittleShape get(String name) {
        return (LittleShape)REGISTRY.get(name);
    }

    public static String getConfig(LittleShape shape) {
        return SHAPE_TO_CONFIG.get(REGISTRY.getId((Object)shape));
    }

    public static LittleShapeConfig createConfigDefault(LittleShape shape) {
        String id = ShapeRegistry.getConfig(shape);
        if (id != null) {
            return (LittleShapeConfig)SHAPE_CONFIG_REGISTRY.createDefault(id);
        }
        return null;
    }

    static {
        ShapeRegistry.registerConfig("axis", AxisShapeConfig.class, AxisShapeConfig::new);
        ShapeRegistry.registerConfig("aht", AxisHollowThicknessShapeConfig.class, AxisHollowThicknessShapeConfig::new);
        ShapeRegistry.registerConfig("at", AxisThicknessShapeConfig.class, AxisThicknessShapeConfig::new);
        ShapeRegistry.registerConfig("corner", CornerShapeConfig.class, CornerShapeConfig::new);
        ShapeRegistry.registerConfig("facing", FacingShapeConfig.class, FacingShapeConfig::new);
        ShapeRegistry.registerConfig("hollow", HollowThicknessConfig.class, HollowThicknessConfig::new);
        ShapeRegistry.registerConfig("iat", InterpolationAxisThicknessConfig.class, InterpolationAxisThicknessConfig::new);
        ShapeRegistry.registerConfig("it", InterpolationThicknessConfig.class, InterpolationThicknessConfig::new);
        ShapeRegistry.registerConfig("matrix", MatrixShapeConfig.class, MatrixShapeConfig::new);
        ShapeRegistry.registerConfig("pillar", PillarShapeConfig.class, PillarShapeConfig::new);
        ShapeRegistry.registerConfig("size", BrushSizeShapeConfig.class, BrushSizeShapeConfig::new);
        ShapeRegistry.registerShape("pixel", new LittleShapePixel(), "brush");
        ShapeRegistry.registerShape("blob", new LittleShapeBlob(), BrushSizeShapeConfig.class, "brush");
        ShapeRegistry.registerShape("cube", new LittleShapeCube(), BrushSizeShapeConfig.class, "brush");
        ShapeRegistry.registerShape("box", DRAG_BOX, HollowThicknessConfig.class, "drag");
        ShapeRegistry.registerShape("wall", new LittleShapeWall(), AxisThicknessShapeConfig.class, "drag");
        ShapeRegistry.registerShape("curve", new LittleShapeCurve(), InterpolationThicknessConfig.class, "drag");
        ShapeRegistry.registerShape("curvewall", new LittleShapeCurveWall(), InterpolationAxisThicknessConfig.class, "drag");
        ShapeRegistry.registerShape("polygon", new LittleShapePolygon(), "drag");
        ShapeRegistry.registerShape("cylinder", new LittleShapeCylinder(), AxisHollowThicknessShapeConfig.class, "drag");
        ShapeRegistry.registerShape("sphere", DRAG_SPHERE, HollowThicknessConfig.class, "drag");
        ShapeRegistry.registerShape("pillar", new LittleShapePillar(), PillarShapeConfig.class, "drag");
        ShapeRegistry.registerShape("pyramid", new LittleShapePyramid(), FacingShapeConfig.class, "drag");
        ShapeRegistry.registerShape("slope", new LittleShapeSlope(), MatrixShapeConfig.class, "drag.slope");
        ShapeRegistry.registerShape("inner_corner", new LittleShapeInnerCorner(), CornerShapeConfig.class, "drag.slope");
        ShapeRegistry.registerShape("outer_corner", new LittleShapeOuterCorner(), CornerShapeConfig.class, "drag.slope");
        ShapeRegistry.registerShape("tile", TILE_SHAPE, "tiles");
        ShapeRegistry.registerShape("same_type", new LittleShapeType(), "tiles");
        ShapeRegistry.registerShape("connected", new LittleShapeConnected(), "tiles");
    }
}

