/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.shape.config;

import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.api.IntRangeSupplier;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.common.placement.shape.config.LittleShapeConfig;

public class HollowThicknessConfig
extends LittleShapeConfig {
    public boolean hollow;
    @CreativeConfig.IntRangeSupplier(supplier=GridRange.class)
    public int thickness = 1;

    public HollowThicknessConfig() {
        this(false, 1);
    }

    public HollowThicknessConfig(boolean hollow, int thickness) {
        this.hollow = hollow;
        this.thickness = thickness;
    }

    @Override
    public List<Component> information() {
        TextBuilder text = new TextBuilder();
        text.color(-1).translate("shape.config.hollow").text(": ").bool(this.hollow);
        if (this.hollow) {
            text.newLine().color(-1).translate("shape.config.thickness").text(": ").color(-5592406).text("" + this.thickness);
        }
        return text.build();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean react(Player player, KeyMapping key) {
        return false;
    }

    public static class GridRange
    implements IntRangeSupplier {
        public int getMin() {
            return 1;
        }

        public int getMax() {
            return LittleTilesClient.ACTION_HANDLER.setting.grid().count;
        }
    }
}

