/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement.shape.type;

import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.littletiles.client.tool.shaper.ShapeSelection;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.collection.LittleBoxes;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.config.AxisHollowThicknessShapeConfig;

public class LittleShapeCylinder
extends LittleShape<AxisHollowThicknessShapeConfig> {
    public LittleShapeCylinder() {
        super(2);
    }

    @Override
    protected void build(LittleBoxes boxes, ShapeSelection selection, AxisHollowThicknessShapeConfig config) {
        LittleBox box = selection.getOverallBox();
        boolean hollow = config.hollow;
        LittleVec size = box.getSize();
        int sizeA = size.x;
        int sizeB = size.z;
        if (config.axis == Axis.X) {
            sizeA = size.y;
            sizeB = size.z;
        } else if (config.axis == Axis.Z) {
            sizeA = size.x;
            sizeB = size.y;
        }
        double a = Math.pow(Math.max(1.0, (double)sizeA / 2.0), 2.0);
        double b = Math.pow(Math.max(1.0, (double)sizeB / 2.0), 2.0);
        double a2 = 1.0;
        double b2 = 1.0;
        int thickness = config.thickness;
        if (hollow && sizeA > thickness * 2 && sizeB > thickness * 2) {
            int sizeAValue = sizeA - thickness - 1;
            int sizeBValue = sizeB - thickness - 1;
            a2 = Math.pow(Math.max(1.0, (double)sizeAValue / 2.0), 2.0);
            b2 = Math.pow(Math.max(1.0, (double)sizeBValue / 2.0), 2.0);
        } else {
            hollow = false;
        }
        boolean stretchedA = sizeA % 2 == 0;
        boolean stretchedB = sizeB % 2 == 0;
        double centerA = sizeA / 2;
        double centerB = sizeB / 2;
        LittleVec min = box.getMinVec();
        LittleVec max = box.getMaxVec();
        for (int incA = 0; incA < sizeA; ++incA) {
            for (int incB = 0; incB < sizeB; ++incB) {
                LittleBox toAdd;
                double valueB;
                double posA = (double)incA - centerA + (stretchedA ? 0.5 : 0.0);
                double posB = (double)incB - centerB + (stretchedB ? 0.5 : 0.0);
                double valueA = Math.pow(posA, 2.0) / a;
                if (!(valueA + (valueB = Math.pow(posB, 2.0) / b) <= 1.0)) continue;
                switch (config.axis) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case X: {
                        LittleBox littleBox = new LittleBox(min.x, min.y + incA, min.z + incB, max.x, min.y + incA + 1, min.z + incB + 1);
                        break;
                    }
                    case Y: {
                        LittleBox littleBox = new LittleBox(min.x + incA, min.y, min.z + incB, min.x + incA + 1, max.y, min.z + incB + 1);
                        break;
                    }
                    case Z: {
                        LittleBox littleBox = toAdd = new LittleBox(min.x + incA, min.y + incB, min.z, min.x + incA + 1, min.y + incB + 1, max.z);
                    }
                }
                if (hollow) {
                    double valueB2;
                    double valueA2 = Math.pow(posA, 2.0) / a2;
                    if (valueA2 + (valueB2 = Math.pow(posB, 2.0) / b2) <= 1.0) continue;
                    boxes.add(toAdd);
                    continue;
                }
                boxes.add(toAdd);
            }
        }
        boxes.combineBoxesBlocks();
    }
}

