/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.relative;

import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecAbsolute;
import team.creative.littletiles.common.math.vec.LittleVecGrid;
import team.creative.littletiles.common.structure.relative.StructureRelative;

public class StructureAbsolute
extends StructureRelative {
    public final LittleVecGrid inBlockOffset;
    public final BlockPos baseOffset;
    public final SectionPos chunkOffset;
    public final BlockPos chunkOrigin;
    public final BlockPos inChunkOffset;
    public final Vec3d rotationCenter;
    public final Vec3d rotationCenterInsideBlock;

    public static int intFloorDiv(int coord, int bucketSize) {
        return coord < 0 ? -((-coord - 1) / bucketSize) - 1 : coord / bucketSize;
    }

    public StructureAbsolute(BlockPos pos, LittleBox box, LittleGrid grid) {
        super(box, grid);
        LittleVecGrid minVec = this.getMinVec();
        BlockPos minPosOffset = minVec.getBlockPos();
        this.sub(minPosOffset);
        this.inBlockOffset = minVec;
        this.baseOffset = pos.offset((Vec3i)minPosOffset);
        this.chunkOffset = SectionPos.of((BlockPos)this.baseOffset);
        this.chunkOrigin = this.chunkOffset.origin();
        int chunkX = StructureAbsolute.intFloorDiv(this.baseOffset.getX(), 16);
        int chunkY = StructureAbsolute.intFloorDiv(this.baseOffset.getY(), 16);
        int chunkZ = StructureAbsolute.intFloorDiv(this.baseOffset.getZ(), 16);
        this.inChunkOffset = new BlockPos(this.baseOffset.getX() - chunkX * 16, this.baseOffset.getY() - chunkY * 16, this.baseOffset.getZ() - chunkZ * 16);
        this.rotationCenterInsideBlock = this.getCenter();
        this.rotationCenter = new Vec3d(this.rotationCenterInsideBlock);
        this.rotationCenter.x += (double)this.baseOffset.getX();
        this.rotationCenter.y += (double)this.baseOffset.getY();
        this.rotationCenter.z += (double)this.baseOffset.getZ();
    }

    public StructureAbsolute(LittleVecAbsolute pos, LittleBox box, LittleGrid grid) {
        super(box, grid);
        this.add(pos.getVecGrid());
        LittleVecGrid minVec = this.getMinVec();
        BlockPos minPosOffset = minVec.getBlockPos();
        this.sub(minPosOffset);
        minVec.sub(minPosOffset);
        this.inBlockOffset = minVec;
        this.baseOffset = pos.getPos().offset((Vec3i)minPosOffset);
        this.chunkOffset = SectionPos.of((BlockPos)this.baseOffset);
        this.chunkOrigin = this.chunkOffset.origin();
        int chunkX = StructureAbsolute.intFloorDiv(this.baseOffset.getX(), 16);
        int chunkY = StructureAbsolute.intFloorDiv(this.baseOffset.getY(), 16);
        int chunkZ = StructureAbsolute.intFloorDiv(this.baseOffset.getZ(), 16);
        this.inChunkOffset = new BlockPos(this.baseOffset.getX() - chunkX * 16, this.baseOffset.getY() - chunkY * 16, this.baseOffset.getZ() - chunkZ * 16);
        this.rotationCenterInsideBlock = this.getCenter();
        this.rotationCenter = new Vec3d(this.rotationCenterInsideBlock);
        this.rotationCenter.x += (double)this.baseOffset.getX();
        this.rotationCenter.y += (double)this.baseOffset.getY();
        this.rotationCenter.z += (double)this.baseOffset.getZ();
    }

    public StructureAbsolute(LittleVecAbsolute pos, StructureRelative relative) {
        this(pos, relative.box.copy(), relative.grid);
    }

    public StructureAbsolute(String name, CompoundTag nbt) {
        this(StructureAbsolute.getPos(nbt.getIntArray(name + "_pos")), LittleBox.create(nbt.getIntArray(name + "_box")), LittleGrid.get(nbt.getInt(name + "_grid")));
    }

    public StructureAbsolute(LittleVecAbsolute axis, LittleVec additional) {
        this(axis.getPos(), StructureAbsolute.convertAxisToBox(axis.getVecGrid(), additional), axis.getGrid());
    }

    public void save(String name, CompoundTag nbt) {
        nbt.putIntArray(name + "_pos", new int[]{this.baseOffset.getX(), this.baseOffset.getY(), this.baseOffset.getZ()});
        nbt.putInt(name + "_grid", this.grid.count);
        nbt.putIntArray(name + "_box", this.box.getArray());
    }

    @Override
    public LittleVec getDoubledCenterVec() {
        return new LittleVec((this.box.maxX * 2 - this.box.minX * 2) / 2, (this.box.maxY * 2 - this.box.minY * 2) / 2, (this.box.maxZ * 2 - this.box.minZ * 2) / 2);
    }

    private static BlockPos getPos(int[] array) {
        return new BlockPos(array[0], array[1], array[2]);
    }

    public static LittleBox convertAxisToBox(LittleVecGrid vec, LittleVec additional) {
        if (additional.x == 0) {
            return new LittleBox(vec.getVec().x - 1, vec.getVec().y - 1, vec.getVec().z - 1, vec.getVec().x + 1, vec.getVec().y + 1, vec.getVec().z + 1);
        }
        return new LittleBox(additional.x > 0 ? vec.getVec().x : vec.getVec().x - 1, additional.y > 0 ? vec.getVec().y : vec.getVec().y - 1, additional.z > 0 ? vec.getVec().z : vec.getVec().z - 1, additional.x > 0 ? vec.getVec().x + 1 : vec.getVec().x, additional.y > 0 ? vec.getVec().y + 1 : vec.getVec().y, additional.z > 0 ? vec.getVec().z + 1 : vec.getVec().z);
    }
}

