/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.input;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.lang3.ArrayUtils;
import team.creative.creativecore.common.util.type.itr.ArrayIterator;
import team.creative.creativecore.common.util.type.itr.SingleIterator;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.input.SignalInputVariable;
import team.creative.littletiles.common.structure.signal.logic.SignalLogicOperator;
import team.creative.littletiles.common.structure.signal.logic.SignalPatternParser;
import team.creative.littletiles.common.structure.signal.logic.SignalTarget;

public abstract class SignalInputCondition {
    public static SignalInputCondition parseInput(String pattern) throws ParseException {
        SignalPatternParser parser = new SignalPatternParser(pattern);
        SignalInputCondition input = SignalInputCondition.tryParseNextCondition(parser, true, false, true);
        if (input != null && !parser.hasNext()) {
            return input;
        }
        return SignalInputCondition.parseExpression(new SignalPatternParser(pattern), new char[0], true, false);
    }

    public static SignalInputCondition parseNextCondition(SignalPatternParser parser, boolean includeBitwise, boolean insideVariable) throws ParseException {
        return SignalInputCondition.parseNextCondition(parser, includeBitwise, insideVariable, false);
    }

    public static SignalInputCondition parseNextCondition(SignalPatternParser parser, boolean includeBitwise, boolean insideVariable, boolean forceBitwise) throws ParseException {
        SignalInputCondition condition = SignalInputCondition.tryParseNextCondition(parser, includeBitwise, insideVariable, forceBitwise);
        if (condition == null) {
            throw parser.exception("Invalid signal pattern");
        }
        return condition;
    }

    public static SignalInputCondition tryParseNextCondition(SignalPatternParser parser, boolean includeBitwise, boolean insideVariable, boolean forceBitwise) throws ParseException {
        if (parser.hasNext()) {
            char next = parser.lookForNext(true);
            int type = Character.getType(next);
            if (next == '(') {
                parser.next(true);
                SignalInputCondition condition = SignalInputCondition.parseExpression(parser, new char[]{')'}, SignalLogicOperator.getHighest(includeBitwise), includeBitwise, insideVariable);
                parser.next(true);
                return condition;
            }
            if (next == '!') {
                parser.next(true);
                return new SignalInputConditionNot(SignalInputCondition.parseNextCondition(parser, includeBitwise, insideVariable, forceBitwise));
            }
            if (next == '~') {
                parser.next(true);
                return new SignalInputConditionNotBitwise(SignalInputCondition.parseNextCondition(parser, includeBitwise, insideVariable, forceBitwise));
            }
            if (next == 'v') {
                char current;
                parser.next(true);
                next = parser.next(true);
                if (next != '[') {
                    throw parser.invalidChar(next);
                }
                ArrayList<SignalInputCondition> array = new ArrayList<SignalInputCondition>();
                do {
                    if (parser.lookForNext(true) == ']') continue;
                    array.add(SignalInputCondition.parseExpression(parser, new char[]{',', ']'}, includeBitwise, insideVariable));
                } while ((current = parser.next(true)) == ',');
                if (current != ']') {
                    throw parser.exception("Invalid signal pattern");
                }
                return new SignalInputVirtualVariable(array.toArray(new SignalInputCondition[array.size()]));
            }
            if (next == 'n') {
                parser.next(true);
                return new SignalInputVirtualNumber(parser.parseNumber());
            }
            if (type == 2) {
                return SignalInputVariable.parseInput(parser, insideVariable, forceBitwise);
            }
            if (type == 1) {
                return SignalInputVariable.parseInput(parser, insideVariable, forceBitwise);
            }
            return null;
        }
        return null;
    }

    private static SignalInputCondition parseLowerExpression(SignalPatternParser parser, char[] until, SignalLogicOperator operator, boolean includeBitwise, boolean insideVariable) throws ParseException {
        if (operator.lower() != null) {
            return SignalInputCondition.parseExpression(parser, until, operator.lower(), includeBitwise, insideVariable);
        }
        return SignalInputCondition.parseNextCondition(parser, includeBitwise, insideVariable);
    }

    public static SignalInputCondition parseExpression(SignalPatternParser parser, char[] until, boolean includeBitwise, boolean insideVariable) throws ParseException {
        return SignalInputCondition.parseExpression(parser, until, SignalLogicOperator.getHighest(includeBitwise), includeBitwise, insideVariable);
    }

    public static SignalInputCondition parseExpression(SignalPatternParser parser, char[] until, SignalLogicOperator operator, boolean includeBitwise, boolean insideVariable) throws ParseException {
        SignalInputCondition first = SignalInputCondition.parseLowerExpression(parser, until, operator, includeBitwise, insideVariable);
        if (!parser.hasNext() || ArrayUtils.contains((char[])until, (char)parser.lookForNext(true))) {
            return first;
        }
        if (operator.goOn(parser)) {
            ArrayList<SignalInputCondition> conditions = new ArrayList<SignalInputCondition>();
            conditions.add(first);
            conditions.add(SignalInputCondition.parseLowerExpression(parser, until, operator, includeBitwise, insideVariable));
            while (operator.goOn(parser)) {
                conditions.add(SignalInputCondition.parseLowerExpression(parser, until, operator, includeBitwise, insideVariable));
            }
            return operator.create(conditions.toArray(new SignalInputCondition[conditions.size()]));
        }
        return first;
    }

    public abstract SignalState test(LittleStructure var1, boolean var2);

    public abstract boolean testIndex(SignalState var1);

    public abstract String write();

    protected abstract double internalDelay();

    public double calculateDelay() {
        return this.internalDelay() * LittleTiles.CONFIG.signal.overallDurationScale;
    }

    public String toString() {
        return this.write();
    }

    public abstract Iterator<SignalInputCondition> nested();

    public abstract SignalTarget target();

    public static class SignalInputConditionNot
    extends SignalInputConditionOperator {
        public SignalInputCondition condition;

        public SignalInputConditionNot(SignalInputCondition condition) {
            this.condition = condition;
        }

        @Override
        public SignalState test(LittleStructure structure) {
            return SignalState.copy(this.condition.test(structure, false)).invert();
        }

        @Override
        public boolean testIndex(SignalState state) {
            return !this.condition.testIndex(state);
        }

        @Override
        public String write() {
            return "!(" + this.condition.write() + ")";
        }

        @Override
        protected double internalDelay() {
            return LittleTiles.CONFIG.signal.notDuration + this.condition.calculateDelay();
        }

        @Override
        public Iterator<SignalInputCondition> nested() {
            return new SingleIterator((Object)this.condition);
        }

        @Override
        public SignalTarget target() {
            return null;
        }
    }

    public static class SignalInputConditionNotBitwise
    extends SignalInputConditionOperator {
        public SignalInputCondition condition;

        public SignalInputConditionNotBitwise(SignalInputCondition condition) {
            this.condition = condition;
        }

        @Override
        public SignalState test(LittleStructure structure) {
            return SignalState.copy(this.condition.test(structure, true)).invert();
        }

        @Override
        public boolean testIndex(SignalState state) {
            return !this.condition.testIndex(state);
        }

        @Override
        public String write() {
            return "~(" + this.condition.write() + ")";
        }

        @Override
        protected double internalDelay() {
            return LittleTiles.CONFIG.signal.bnotDuration + this.condition.calculateDelay();
        }

        @Override
        public Iterator<SignalInputCondition> nested() {
            return new SingleIterator((Object)this.condition);
        }

        @Override
        public SignalTarget target() {
            return null;
        }
    }

    public static class SignalInputVirtualVariable
    extends SignalInputCondition {
        public SignalInputCondition[] conditions;

        public SignalInputVirtualVariable(SignalInputCondition[] conditions) {
            this.conditions = conditions;
        }

        @Override
        public SignalState test(LittleStructure structure, boolean forceBitwise) {
            SignalState state = SignalState.create(this.conditions.length);
            for (int i = 0; i < this.conditions.length; ++i) {
                state = state.set(i, this.conditions[i].test(structure, false).any());
            }
            return state;
        }

        @Override
        public boolean testIndex(SignalState state) {
            return false;
        }

        @Override
        public String write() {
            Object result = "v[";
            for (int i = 0; i < this.conditions.length; ++i) {
                if (i > 0) {
                    result = (String)result + ",";
                }
                result = (String)result + this.conditions[i].write();
            }
            return (String)result + "]";
        }

        @Override
        protected double internalDelay() {
            double delay = LittleTiles.CONFIG.signal.andDuration * (double)this.conditions.length;
            for (int i = 0; i < this.conditions.length; ++i) {
                delay += this.conditions[i].calculateDelay();
            }
            return delay;
        }

        @Override
        public Iterator<SignalInputCondition> nested() {
            return new ArrayIterator((Object[])this.conditions);
        }

        @Override
        public SignalTarget target() {
            return null;
        }
    }

    public static class SignalInputVirtualNumber
    extends SignalInputCondition {
        public int number;

        public SignalInputVirtualNumber(int number) {
            this.number = number;
        }

        @Override
        public SignalState test(LittleStructure structure, boolean forceBitwise) {
            return SignalState.of(this.number);
        }

        @Override
        public boolean testIndex(SignalState state) {
            return false;
        }

        @Override
        public String write() {
            return "n" + this.number;
        }

        @Override
        protected double internalDelay() {
            return 0.0;
        }

        @Override
        public Iterator<SignalInputCondition> nested() {
            return Collections.emptyIterator();
        }

        @Override
        public SignalTarget target() {
            return null;
        }
    }

    public static abstract class SignalInputConditionOperator
    extends SignalInputCondition {
        @Override
        public SignalState test(LittleStructure structure, boolean forceBitwise) {
            return this.test(structure);
        }

        public abstract SignalState test(LittleStructure var1);
    }
}

