/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import team.creative.creativecore.common.util.inventory.InventoryUtils;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.gui.structure.GuiStorage;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.ingredient.StackIngredient;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.attribute.LittleAttributeBuilder;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.SignalState;

public class LittleStorage
extends LittleStructure {
    private List<GuiStorage> openContainers = new ArrayList<GuiStorage>();
    public static int maxSlotStackSize = 64;
    public int inventorySize = 0;
    public int stackSizeLimit = 0;
    public int numberOfSlots = 0;
    public int lastSlotStackSize = 0;
    public SimpleContainer inventory = null;
    public boolean invisibleStorageTiles = false;

    public LittleStorage(LittleStructureType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    public void updateNumberOfSlots() {
        float slots = (float)this.inventorySize / (float)this.stackSizeLimit;
        this.numberOfSlots = (int)Math.ceil(slots);
        this.lastSlotStackSize = (int)(slots % 1.0f * (float)this.stackSizeLimit);
    }

    @Override
    protected void loadExtra(CompoundTag nbt, HolderLookup.Provider provider) {
        this.inventorySize = nbt.getInt("inventorySize");
        this.stackSizeLimit = nbt.getInt("stackSizeLimit");
        this.numberOfSlots = nbt.getInt("numberOfSlots");
        this.lastSlotStackSize = nbt.getInt("lastSlot");
        this.inventory = nbt.contains("inventory") ? InventoryUtils.load((HolderLookup.Provider)provider, (CompoundTag)nbt.getCompound("inventory")) : null;
        if (this.inventory != null) {
            this.inventory.addListener(x -> this.onInventoryChanged());
        }
        this.invisibleStorageTiles = nbt.getBoolean("invisibleStorage");
    }

    @Override
    protected void saveExtra(CompoundTag nbt, HolderLookup.Provider provider) {
        if (this.inventory != null) {
            nbt.putInt("inventorySize", this.inventorySize);
            nbt.putInt("stackSizeLimit", this.stackSizeLimit);
            nbt.putInt("numberOfSlots", this.numberOfSlots);
            nbt.putInt("lastSlot", this.lastSlotStackSize);
            nbt.put("inventory", (Tag)InventoryUtils.save((HolderLookup.Provider)provider, (SimpleContainer)this.inventory));
        }
        nbt.putBoolean("invisibleStorage", this.invisibleStorageTiles);
    }

    @Override
    public void structureDestroyed() {
        super.structureDestroyed();
        if (!this.isClient()) {
            for (GuiStorage container : this.openContainers) {
                container.storage = null;
                container.closeThisLayer();
            }
        }
    }

    public static int getSizeOfInventory(LittleGroup previews) {
        double size = 0.0;
        String name = ((Block)LittleTilesRegistry.STORAGE_BLOCK.value()).builtInRegistryHolder().getRegisteredName();
        Iterator<LittleTile> iterator = previews.iterator();
        while (iterator.hasNext()) {
            LittleTile tile = iterator.next();
            if (!tile.getBlock().blockName().equals(name)) continue;
            size += tile.getPercentVolume(previews.getGrid()) * 4096.0 * (double)LittleTiles.CONFIG.general.storagePerPixel;
        }
        return (int)size;
    }

    public boolean hasPlayerOpened(Player player) {
        for (GuiStorage container : this.openContainers) {
            if (container.getPlayer() != player) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canInteract() {
        return true;
    }

    @Override
    public InteractionResult use(Level level, LittleTileContext context, BlockPos pos, Player player, BlockHitResult result) {
        if (!level.isClientSide && !this.hasPlayerOpened(player)) {
            LittleTilesGuiRegistry.STORAGE.open(player, this);
        }
        return InteractionResult.SUCCESS;
    }

    protected void updateInput() {
        this.getInput(0).updateState(SignalState.of(!this.openContainers.isEmpty()));
    }

    public void onInventoryChanged() {
        if (this.isClient()) {
            return;
        }
        if (!this.openContainers.isEmpty()) {
            for (GuiStorage gui : this.openContainers) {
                gui.inventoryChanged();
            }
        }
        int used = 0;
        boolean allSlotsFilled = true;
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            ItemStack stack = this.inventory.getItem(i);
            if (stack.isEmpty()) {
                allSlotsFilled = false;
                continue;
            }
            used += stack.getCount();
        }
        if (allSlotsFilled) {
            used = this.inventorySize;
        }
        int filled = (int)Math.ceil((double)used / (double)this.inventorySize * 65535.0);
        this.getInput(1).updateState(SignalState.of(filled));
    }

    public void openContainer(GuiStorage container) {
        this.openContainers.add(container);
        this.updateInput();
    }

    public void closeContainer(GuiStorage container) {
        this.openContainers.remove((Object)container);
        this.updateInput();
        this.onInventoryChanged();
    }

    @Override
    public void afterPlaced() {
        super.afterPlaced();
        double volume = 0.0;
        try {
            for (IStructureParentCollection list : this.blocksList()) {
                for (LittleTile tile : list) {
                    if (tile.getBlock() != LittleTilesRegistry.STORAGE_BLOCK.value()) continue;
                    volume += tile.getPercentVolume(list.getGrid());
                }
            }
            this.inventorySize = (int)(volume *= (double)(4096.0f * LittleTiles.CONFIG.general.storagePerPixel));
            this.stackSizeLimit = maxSlotStackSize;
            this.updateNumberOfSlots();
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
    }

    public static class LittleStorageType
    extends LittleStructureType {
        public <T extends LittleStructure> LittleStorageType(String id, Class<T> structureClass, BiFunction<LittleStructureType, IStructureParentCollection, T> factory, LittleAttributeBuilder attribute) {
            super(id, structureClass, factory, attribute);
        }

        @Override
        public void addIngredients(HolderLookup.Provider provider, LittleGroup previews, LittleIngredients ingredients) {
            super.addIngredients(provider, previews, ingredients);
            SimpleContainer inventory = InventoryUtils.load((HolderLookup.Provider)provider, (CompoundTag)previews.getStructureTag().getCompound("inventory"));
            if (inventory != null) {
                ingredients.add(new StackIngredient((Container)inventory));
            }
        }
    }
}

