/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type;

import com.mojang.brigadier.StringReader;
import com.mojang.serialization.Codec;
import net.minecraft.commands.ParserUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.commons.lang3.StringUtils;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.signal.output.InternalSignalOutput;

public class LittleStructureMessage
extends LittleStructure {
    public String text;
    public boolean allowRightClick = true;
    public boolean status = false;

    public LittleStructureMessage(LittleStructureType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    @Override
    public boolean canInteract() {
        return this.allowRightClick;
    }

    @Override
    public InteractionResult use(Level level, LittleTileContext context, BlockPos pos, Player player, BlockHitResult result) {
        if (this.allowRightClick) {
            if (!level.isClientSide) {
                player.displayClientMessage(this.message(), this.status);
            }
            return InteractionResult.SUCCESS;
        }
        return super.use(level, context, pos, player, result);
    }

    @Override
    protected void loadExtra(CompoundTag nbt, HolderLookup.Provider provider) {
        this.text = StringUtils.truncate((String)nbt.getString("text"), (int)LittleTiles.CONFIG.general.messageStructureLength);
        this.allowRightClick = nbt.getBoolean("right");
        this.status = nbt.getBoolean("status");
    }

    @Override
    protected void saveExtra(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putString("text", this.text);
        nbt.putBoolean("right", this.allowRightClick);
        nbt.putBoolean("status", this.status);
    }

    public Component message() {
        try {
            return (Component)ParserUtils.parseJson((HolderLookup.Provider)this.getStructureLevel().registryAccess(), (StringReader)new StringReader(this.text), (Codec)ComponentSerialization.CODEC);
        }
        catch (Exception exception) {
            return Component.literal((String)this.text);
        }
    }

    @Override
    public void performInternalOutputChange(InternalSignalOutput output) {
        if (((LittleStructureType.InternalComponentOutput)output.component).is("message")) {
            Level level = this.getStructureLevel();
            if (level.isClientSide) {
                return;
            }
            LevelChunk chunk = level.getChunkAt(this.getStructurePos());
            if (chunk != null) {
                ((ServerChunkCache)chunk.getLevel().getChunkSource()).chunkMap.getPlayers(chunk.getPos(), false).forEach(x -> x.sendSystemMessage(this.message(), this.status));
            }
        }
    }
}

