/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type.animation;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.client.sound.EntitySound;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.vec.Vec1d;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.action.LittleActionException;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntity;
import team.creative.littletiles.common.entity.animation.LittleAnimationEntityPhysic;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.vec.LittleVecAbsolute;
import team.creative.littletiles.common.packet.entity.EntityOriginChanged;
import team.creative.littletiles.common.packet.structure.StructureStartAnimationPacket;
import team.creative.littletiles.common.placement.Placement;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.animation.AnimationState;
import team.creative.littletiles.common.structure.animation.AnimationTimeline;
import team.creative.littletiles.common.structure.animation.AnimationTransition;
import team.creative.littletiles.common.structure.animation.PhysicalState;
import team.creative.littletiles.common.structure.animation.context.AnimationContext;
import team.creative.littletiles.common.structure.animation.curve.ValueCurve;
import team.creative.littletiles.common.structure.attribute.LittleAttributeBuilder;
import team.creative.littletiles.common.structure.directional.StructureDirectional;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotEnoughSpaceForStructureException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.relative.StructureAbsolute;
import team.creative.littletiles.common.structure.relative.StructureRelative;
import team.creative.littletiles.common.structure.signal.logic.SignalMode;

public abstract class LittleStateStructure<T extends AnimationState>
extends LittleStructure
implements AnimationContext {
    @StructureDirectional(saveKey="s")
    private List<T> states = new ArrayList<T>();
    private int currentState;
    private int aimedState = -1;
    private AnimationTimeline timeline;
    private PhysicalState physical;
    @StructureDirectional(color=-65536)
    public StructureRelative center;
    public boolean stayAnimated = false;

    public LittleStateStructure(LittleStateStructureType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    protected abstract AnimationTimeline generateTimeline(T var1, T var2);

    protected abstract ValueCurve<Vec1d> createEmptyCurve();

    protected abstract T getEmptyState();

    protected boolean startTransition(AnimationTransition transition) {
        return this.startTransition(transition.start, transition.end, transition.timeline);
    }

    protected boolean startTransition(int start, int end, @Nullable AnimationTimeline timeline) {
        if (this.isChanging()) {
            return false;
        }
        if (start != this.currentState) {
            LittleTiles.LOGGER.error("Tried to trigger transition, but start does not match. Expected: {} got: {} ", (Object)start, (Object)this.currentState);
            return false;
        }
        if (end < 0 || end > this.states.size()) {
            LittleTiles.LOGGER.error("Tried to trigger transition, but end does not match. State {} does not exist. There are only {} states in total ", (Object)end, (Object)this.states.size());
            return false;
        }
        if (timeline == null) {
            timeline = this.generateTimeline((AnimationState)this.states.get(start), (AnimationState)this.states.get(end));
        }
        if (timeline == null) {
            LittleTiles.LOGGER.error("Transition from {} to {} cannot be done, it does not exist.", (Object)start, (Object)end);
            return false;
        }
        try {
            LittleStateStructure structure = this;
            if (!(((AnimationState)this.states.get(end)).isAligned() && ((AnimationState)this.states.get(start)).equals(this.states.get(end)) || this.isAnimated())) {
                structure = (LittleStateStructure)this.changeToEntityForm().getStructure();
            }
            structure.aimedState = end;
            structure.timeline = timeline;
            structure.timeline.start((PhysicalState)this.states.get(start), (PhysicalState)this.states.get(end), this::createEmptyCurve);
            structure.physical = new PhysicalState();
            LittleTiles.NETWORK.sendToClient((CreativePacket)new StructureStartAnimationPacket(structure.getStructureLocation(), structure.timeline.copy()), structure.getStructureLevel(), structure.getStructurePos());
            structure.queueForNextTick();
            return true;
        }
        catch (LittleActionException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean queuedTick() {
        if (this.mainBlock.isRemoved()) {
            return false;
        }
        if (this.timeline == null) {
            if (!(this.isClient() || ((AnimationState)this.states.get(this.currentState)).isAligned() || this.isAnimated())) {
                try {
                    LittleAnimationEntity animation = this.changeToEntityForm();
                    if (animation != null) {
                        ((LittleAnimationEntityPhysic)animation.physic).ignoreCollision(() -> ((LittleAnimationEntityPhysic)animation.physic).set((PhysicalState)this.states.get(this.currentState)));
                        LittleTiles.NETWORK.sendToClientTracking((CreativePacket)new EntityOriginChanged(animation), (Entity)animation);
                    }
                }
                catch (LittleActionException e) {
                    e.printStackTrace();
                }
            }
            return false;
        }
        LittleAnimationEntity animation = this.getAnimationEntity();
        boolean done = this.timeline.tick(this.physical, this);
        if (animation != null) {
            ((LittleAnimationEntityPhysic)animation.physic).set(this.physical);
        }
        if (this.isClient()) {
            if (done) {
                this.timeline = null;
                this.aimedState = -1;
                this.physical = null;
            }
            return this.timeline != null;
        }
        if (done) {
            this.endTransition();
        }
        return this.isChanging();
    }

    protected abstract boolean shouldStayAnimatedAfterTransitionEnd();

    protected void endTransition() {
        this.currentState = this.aimedState;
        this.aimedState = -1;
        this.timeline.end();
        this.timeline = null;
        this.physical = null;
        T state = this.current();
        if (!this.shouldStayAnimatedAfterTransitionEnd() && !this.stayAnimated && ((AnimationState)state).shouldGoBackToBlockform() && ((PhysicalState)state).isAligned()) {
            try {
                this.changeToBlockForm();
            }
            catch (LittleActionException e) {
                if (!(e instanceof NotEnoughSpaceForStructureException)) {
                    e.printStackTrace();
                }
            }
        } else {
            this.updateStructure();
        }
    }

    @Override
    public StructureAbsolute createAnimationCenter(BlockPos pos, LittleGrid grid) {
        return new StructureAbsolute(new LittleVecAbsolute(pos, grid), this.center);
    }

    public boolean canRightClick() {
        return !this.isChanging();
    }

    public boolean hasState(int index) {
        return index >= 0 && index < this.states.size();
    }

    public T current() {
        if (this.currentState >= 0 || this.currentState < this.states.size()) {
            return (T)((AnimationState)this.states.get(this.currentState));
        }
        return this.getEmptyState();
    }

    public int currentIndex() {
        return this.currentState;
    }

    public boolean isChanging() {
        return this.aimedState != -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setClientTimeline(AnimationTimeline timeline) {
        this.timeline = timeline;
        this.physical = new PhysicalState();
        this.queueForNextTick();
    }

    @Override
    protected void loadExtra(CompoundTag nbt, HolderLookup.Provider provider) {
        this.currentState = nbt.getInt("cS");
        this.aimedState = nbt.getInt("aS");
        if (this.aimedState >= this.states.size()) {
            throw new RuntimeException("Invalid state structure! Aimed State " + this.aimedState + " not found. Only got " + this.states.size() + " states");
        }
        this.timeline = nbt.contains("timeline") ? new AnimationTimeline(nbt.getCompound("timeline")) : null;
        this.physical = nbt.contains("cP") ? new PhysicalState(nbt.getCompound("cP")) : null;
        this.stayAnimated = nbt.getBoolean("stay");
        if (this.isChanging()) {
            this.queueForNextTick();
        }
    }

    @Override
    protected void saveExtra(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putInt("cS", this.currentState);
        nbt.putInt("aS", this.aimedState);
        if (this.timeline != null) {
            nbt.put("timeline", (Tag)this.timeline.save());
        }
        if (this.physical != null) {
            nbt.put("cP", (Tag)this.physical.save());
        }
        if (this.stayAnimated) {
            nbt.putBoolean("stay", this.stayAnimated);
        } else {
            nbt.remove("stay");
        }
    }

    public T getState(String name) {
        for (int i = 0; i < this.states.size(); ++i) {
            if (!((AnimationState)this.states.get((int)i)).name.equals(name)) continue;
            return (T)((AnimationState)this.states.get(i));
        }
        return null;
    }

    public int indexOfState(String name) {
        for (int i = 0; i < this.states.size(); ++i) {
            if (!((AnimationState)this.states.get((int)i)).name.equals(name)) continue;
            return i;
        }
        return -1;
    }

    public int putState(T state) {
        for (int i = 0; i < this.states.size(); ++i) {
            if (!((AnimationState)this.states.get((int)i)).name.equals(((AnimationState)state).name)) continue;
            this.states.set(i, state);
            return i;
        }
        this.states.add(state);
        return this.states.size() - 1;
    }

    @Override
    public boolean isClient() {
        return super.isClient();
    }

    @Override
    public boolean isGui() {
        return false;
    }

    @Override
    public AnimationContext getChild(int id) {
        try {
            LittleStructure structure = this.children.getChild(id).getStructure();
            if (structure instanceof AnimationContext) {
                AnimationContext context = (AnimationContext)((Object)structure);
                return context;
            }
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public LittleStructure getChildStructure(int id) {
        try {
            return this.children.getChild(id).getStructure();
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            return null;
        }
    }

    @Override
    public void play(SoundEvent event, float volume, float pitch) {
        if (this.isClient()) {
            this.playClient(event, volume, pitch);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void playClient(SoundEvent event, float volume, float pitch) {
        GuiControl.playSound((SoundInstance)new EntitySound(event, (Entity)this.getAnimationEntity(), volume, pitch, SoundSource.BLOCKS));
    }

    @Override
    public void finishedPlacement(Placement placement) {
        super.finishedPlacement(placement);
        if (!this.isClient() && !((AnimationState)this.states.get(this.currentState)).isAligned()) {
            this.queueForNextTick();
        }
    }

    public static class LittleStateStructureType
    extends LittleStructureType {
        public <T extends LittleStateStructure> LittleStateStructureType(String id, Class<T> structureClass, BiFunction<? extends LittleStateStructureType, IStructureParentCollection, T> factory, LittleAttributeBuilder attribute, int bandwidth, SignalMode mode) {
            super(id, structureClass, factory, attribute);
            this.addOutput("state", bandwidth, mode);
        }
    }
}

