/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type.bed;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.util.Unit;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.event.EventHooks;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.packet.structure.BedUpdate;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.LittleStructureType;
import team.creative.littletiles.common.structure.directional.StructureDirectional;
import team.creative.littletiles.common.structure.directional.StructureDirectionalField;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.type.bed.ILittleBedPlayerExtension;

public class LittleBed
extends LittleStructure {
    private Player sleepingPlayer = null;
    @OnlyIn(value=Dist.CLIENT)
    public Vec3d playerPostion;
    @StructureDirectional
    public Facing direction;

    public LittleBed(LittleStructureType type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    @Override
    protected void loadExtra(CompoundTag nbt, HolderLookup.Provider provider) {
    }

    @Override
    protected void saveExtra(CompoundTag nbt, HolderLookup.Provider provider) {
    }

    @Override
    protected Object failedLoadingRelative(CompoundTag nbt, StructureDirectionalField field) {
        if (field.key.equals("facing")) {
            return Facing.get((int)nbt.getInt("direction"));
        }
        return super.failedLoadingRelative(nbt, field);
    }

    @Override
    public boolean isBed(LivingEntity player) {
        return true;
    }

    @Override
    public Direction getBedDirection() {
        return this.direction.toVanilla();
    }

    public Player getSleepingPlayer() {
        return this.sleepingPlayer;
    }

    public void wakeUp() {
        if (!this.isClient()) {
            this.broadcastPacket(new BedUpdate(this.getStructureLocation(), this.getSleepingPlayer(), true));
        }
        this.setSleepingPlayer(null);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setSleepingPlayerClient(Player player) {
        this.sleepingPlayer = player;
    }

    private void setSleepingPlayer(Player player) {
        this.sleepingPlayer = player;
        if (!this.isClient()) {
            this.getInput(0).updateState(SignalState.of(player != null));
        }
    }

    public Player.BedSleepingProblem trySleep(ServerPlayer player, Vec3d highest) {
        BlockPos pos = this.getStructurePos();
        Either vanillaResult = ((Supplier<Either>)() -> {
            if (player.isSleeping() || !player.isAlive()) {
                return Either.left((Object)Player.BedSleepingProblem.OTHER_PROBLEM);
            }
            if (!player.level().dimensionType().natural()) {
                return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_HERE);
            }
            player.setRespawnPosition(player.level().dimension(), pos, player.getYRot(), false, true);
            if (player.level().isDay()) {
                return Either.left((Object)Player.BedSleepingProblem.NOT_POSSIBLE_NOW);
            }
            if (!player.isCreative()) {
                Vec3 vec3 = highest.toVanilla();
                List list = player.level().getEntitiesOfClass(Monster.class, new AABB(vec3.x() - 8.0, vec3.y() - 5.0, vec3.z() - 8.0, vec3.x() + 8.0, vec3.y() + 5.0, vec3.z() + 8.0), monster -> monster.isPreventingPlayerRest((Player)player));
                if (!list.isEmpty()) {
                    return Either.left((Object)Player.BedSleepingProblem.NOT_SAFE);
                }
            }
            return Either.right((Object)Unit.INSTANCE);
        }).get();
        if ((vanillaResult = EventHooks.canPlayerStartSleeping((ServerPlayer)player, (BlockPos)pos, (Either)vanillaResult)).left().isPresent()) {
            return (Player.BedSleepingProblem)vanillaResult.left().get();
        }
        ((ILittleBedPlayerExtension)player).setSleepingCounter(0);
        if (player.isPassenger()) {
            player.stopRiding();
        }
        this.setSleepingPlayer((Player)player);
        ((ILittleBedPlayerExtension)player).setBed(this);
        this.broadcastPacket(new BedUpdate(this.getStructureLocation(), (Player)player, false));
        player.setPose(Pose.SLEEPING);
        ((ILittleBedPlayerExtension)player).setPositionToBed();
        player.setSleepingPos(this.getStructurePos());
        player.setDeltaMovement(Vec3.ZERO);
        player.hasImpulse = true;
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = player;
            player.awardStat(Stats.SLEEP_IN_BED);
            CriteriaTriggers.SLEPT_IN_BED.trigger(sPlayer);
            if (!sPlayer.serverLevel().canSleepThroughNights()) {
                player.displayClientMessage((Component)Component.translatable((String)"sleep.not_possible"), true);
            }
            sPlayer.serverLevel().updateSleepingPlayerList();
        }
        return null;
    }

    @Override
    public void tileDestroyed() throws CorruptedConnectionException, NotYetConnectedException {
        super.tileDestroyed();
        if (this.sleepingPlayer != null) {
            ((ILittleBedPlayerExtension)this.sleepingPlayer).setBed(null);
        }
    }

    @Override
    public boolean canInteract() {
        return true;
    }

    @Override
    protected void transferOverFormChange(LittleStructure newStructure) {
        super.transferOverFormChange(newStructure);
        LittleBed bed = (LittleBed)newStructure;
        if (this.sleepingPlayer != null) {
            ((ILittleBedPlayerExtension)this.sleepingPlayer).setBed(bed);
            bed.sleepingPlayer = this.sleepingPlayer;
        }
    }

    @Override
    public InteractionResult use(Level level, LittleTileContext context, BlockPos pos, Player player, BlockHitResult result) {
        try {
            this.checkConnections();
            if (!LittleTiles.CONFIG.general.enableBed) {
                return InteractionResult.PASS;
            }
            if (level.isClientSide) {
                return InteractionResult.CONSUME;
            }
            if (level instanceof ISubLevel) {
                ISubLevel l = (ISubLevel)level;
                level = l.getRealLevel();
            }
            if (level.dimensionType().bedWorks()) {
                Vec3d vec = this.getHighestCenterVec();
                if (this.sleepingPlayer != null) {
                    player.sendSystemMessage((Component)Component.translatable((String)"tile.bed.occupied", (Object[])new Object[0]));
                    return InteractionResult.SUCCESS;
                }
                Player.BedSleepingProblem problem = this.trySleep((ServerPlayer)player, vec);
                if (problem != null) {
                    player.displayClientMessage(problem.getMessage(), true);
                }
                return InteractionResult.SUCCESS;
            }
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
        return InteractionResult.SUCCESS;
    }
}

