/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.mixin.client.render;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import org.lwjgl.system.MemoryUtil;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import team.creative.littletiles.client.render.cache.buffer.ChunkBufferUploader;
import team.creative.littletiles.mixin.client.render.ByteBufferBuilderAccessor;

@Mixin(value={BufferBuilder.class})
public abstract class BufferBuilderMixin
implements ChunkBufferUploader {
    @Final
    @Shadow
    private ByteBufferBuilder buffer;
    @Final
    @Shadow
    private VertexFormat format;
    @Shadow
    private int vertices;
    @Shadow
    private long vertexPointer = -1L;
    @Shadow
    private int vertexSize;

    @Override
    public int uploadIndex() {
        return ((ByteBufferBuilderAccessor)this.buffer).getWriteOffset();
    }

    @Override
    public void upload(ByteBuffer buffer) {
        this.ensureBuilding();
        this.endLastVertex();
        this.vertices += buffer.limit() / this.vertexSize;
        this.vertexPointer = this.buffer.reserve(buffer.capacity());
        long address = MemoryUtil.memAddress((ByteBuffer)buffer);
        MemoryUtil.memCopy((long)address, (long)this.vertexPointer, (long)buffer.capacity());
    }

    @Shadow
    public abstract void ensureBuilding();

    @Shadow
    public abstract void endLastVertex();

    @Override
    public boolean hasFacingSupport() {
        return false;
    }

    @Override
    public int uploadIndex(int facing) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void upload(int facing, ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addTexture(TextureAtlasSprite texture) {
    }
}

