/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.server.level.little;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.entity.PartEntity;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.entity.animation.LittleAnimationLevel;
import team.creative.littletiles.common.level.little.LittleAnimationLevelCallback;
import team.creative.littletiles.common.packet.entity.LittleVanillaPacket;
import team.creative.littletiles.server.level.little.LittleServerEntity;

public class LittleAnimationLevelServerCallback
extends LittleAnimationLevelCallback {
    private final Int2ObjectMap<LittleServerEntity> entities = new Int2ObjectLinkedOpenHashMap();
    private final List<ServerPlayer> seenBy = new ArrayList<ServerPlayer>();
    private final BiConsumer<ServerPlayer, Packet<?>> broadcast = (x, y) -> LittleTiles.NETWORK.sendToClient((CreativePacket)new LittleVanillaPacket(this.level, (Packet)y), x);

    public LittleAnimationLevelServerCallback(LittleAnimationLevel level) {
        super(level);
    }

    public void onCreated(Entity entity) {
    }

    public void onDestroyed(Entity entity) {
        this.level.getScoreboard().entityRemoved(entity);
    }

    @Override
    public void tick() {
        super.tick();
        for (ServerEntity entity : this.entities.values()) {
            entity.sendChanges();
        }
    }

    public void onTrackingStart(Entity entity) {
        EntityType entitytype = entity.getType();
        if (entitytype.clientTrackingRange() * 16 != 0) {
            LittleServerEntity server = new LittleServerEntity((ServerLevel)this.level.getRealLevel(), entity, entitytype.updateInterval(), entitytype.trackDeltas(), this::broadcast, this.broadcast);
            this.entities.put(entity.getId(), (Object)server);
            for (ServerPlayer player : this.seenBy) {
                if (!entity.broadcastToPlayer(player)) continue;
                server.addPairing(player);
            }
            entity.updateDynamicGameEventListener(DynamicGameEventListener::add);
        }
    }

    public void onTrackingEnd(Entity entity) {
        ServerEntity server = (ServerEntity)this.entities.remove(entity.getId());
        for (ServerPlayer player : this.seenBy) {
            server.removePairing(player);
        }
        entity.updateDynamicGameEventListener(DynamicGameEventListener::remove);
        entity.onRemovedFromLevel();
        NeoForge.EVENT_BUS.post((Event)new EntityLeaveLevelEvent(entity, (Level)this.level));
    }

    @Override
    public void addTrackingPlayer(ServerPlayer player) {
        if (this.seenBy.add(player)) {
            for (ServerEntity entity : this.entities.values()) {
                entity.addPairing(player);
            }
        }
    }

    @Override
    public void removeTrackingPlayer(ServerPlayer player) {
        if (this.seenBy.remove(player)) {
            for (ServerEntity entity : this.entities.values()) {
                entity.removePairing(player);
            }
        }
    }

    public void broadcast(Packet<?> packet) {
        LittleVanillaPacket lt = new LittleVanillaPacket(this.level, packet);
        for (ServerPlayer player : this.seenBy) {
            LittleTiles.NETWORK.sendToClient((CreativePacket)lt, player);
        }
    }

    private boolean shouldDiscardEntity(Entity entity) {
        MinecraftServer server = this.level.getServer();
        if (server.isSpawningAnimals() || !(entity instanceof Animal) && !(entity instanceof WaterAnimal)) {
            return !server.areNpcsEnabled() && entity instanceof Npc;
        }
        return true;
    }

    @Override
    public void tickEntity(Entity entity) {
        if (entity.isRemoved()) {
            return;
        }
        if (this.shouldDiscardEntity(entity)) {
            entity.discard();
            return;
        }
        entity.checkDespawn();
        Entity vehicle = entity.getVehicle();
        if (vehicle != null) {
            if (!vehicle.isRemoved() && vehicle.hasPassenger(entity)) {
                return;
            }
            entity.stopRiding();
        }
        if (!entity.isRemoved() && !(entity instanceof PartEntity)) {
            this.level.guardEntityTick(this::tickNonPassenger, entity);
        }
    }

    public void tickNonPassenger(Entity entity) {
        entity.setOldPosAndRot();
        ++entity.tickCount;
        entity.tick();
        for (Entity passenger : entity.getPassengers()) {
            this.tickPassenger(entity, passenger);
        }
    }

    private void tickPassenger(Entity vehicle, Entity entity) {
        if (!entity.isRemoved() && entity.getVehicle() == vehicle) {
            if (entity instanceof Player || this.tickingEntities.contains(entity)) {
                entity.setOldPosAndRot();
                ++entity.tickCount;
                entity.rideTick();
                for (Entity passenger : entity.getPassengers()) {
                    this.tickPassenger(entity, passenger);
                }
            }
        } else {
            entity.stopRiding();
        }
    }
}

