/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.server.player;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.common.ServerboundPongPacket;
import net.minecraft.network.protocol.common.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.cookie.ServerboundCookieResponsePacket;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundTagQueryPacket;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket;
import net.minecraft.network.protocol.game.ServerboundBlockEntityTagQueryPacket;
import net.minecraft.network.protocol.game.ServerboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandSignedPacket;
import net.minecraft.network.protocol.game.ServerboundChatPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.network.protocol.game.ServerboundCommandSuggestionPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.game.ServerboundContainerButtonClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.network.protocol.game.ServerboundContainerSlotStateChangedPacket;
import net.minecraft.network.protocol.game.ServerboundDebugSampleSubscriptionPacket;
import net.minecraft.network.protocol.game.ServerboundEditBookPacket;
import net.minecraft.network.protocol.game.ServerboundEntityTagQueryPacket;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.network.protocol.game.ServerboundJigsawGeneratePacket;
import net.minecraft.network.protocol.game.ServerboundLockDifficultyPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemPacket;
import net.minecraft.network.protocol.game.ServerboundPlaceRecipePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerInputPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookChangeSettingsPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookSeenRecipePacket;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket;
import net.minecraft.network.protocol.game.ServerboundSelectTradePacket;
import net.minecraft.network.protocol.game.ServerboundSetBeaconPacket;
import net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ServerboundSetCommandBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSetCommandMinecartPacket;
import net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket;
import net.minecraft.network.protocol.game.ServerboundSetJigsawBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSetStructureBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSignUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundSwingPacket;
import net.minecraft.network.protocol.game.ServerboundTeleportToEntityPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemPacket;
import net.minecraft.network.protocol.ping.ServerboundPingRequestPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RunningOnDifferentThreadException;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.StringUtil;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.network.connection.ConnectionType;
import org.apache.logging.log4j.Logger;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.level.little.LittleLevel;
import team.creative.littletiles.common.packet.entity.LittleVanillaPacket;
import team.creative.littletiles.mixin.server.network.ServerGamePacketListenerImplAccessor;
import team.creative.littletiles.server.player.LittleServerPlayerConnection;

public class LittleServerPlayerHandler
implements ServerPlayerConnection,
TickablePacketListener,
ServerGamePacketListener {
    private static final Logger LOGGER = LittleTiles.LOGGER;
    private final MinecraftServer server;
    public final ServerPlayer player;
    public Level level;
    private boolean isDestroyingBlock;
    private int destroyProgressStart;
    private BlockPos destroyPos = BlockPos.ZERO;
    private Level destroyLevel;
    private int gameTicks;
    private boolean hasDelayedDestroy;
    private BlockPos delayedDestroyPos = BlockPos.ZERO;
    private int delayedTickStart;
    private int lastSentState = -1;
    private Object2IntMap<Level> ackBlockChanges = new Object2IntArrayMap();

    LittleServerPlayerHandler(ServerPlayer player) {
        this.server = player.getServer();
        this.player = player;
    }

    public void ensureRunningOnSameThread(Packet packet) throws RunningOnDifferentThreadException {
        if (!this.server.isSameThread()) {
            this.server.executeIfPossible(() -> LittleServerPlayerConnection.runInContext((LittleLevel)this.level, this.player, x -> packet.handle((PacketListener)x)));
            throw RunningOnDifferentThreadException.RUNNING_ON_DIFFERENT_THREAD;
        }
    }

    public ServerLevel requiresServerLevel() {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel s = (ServerLevel)level;
            return s;
        }
        throw new RuntimeException("Cannot run this packet on this level " + String.valueOf(this.level));
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public ServerGamePacketListenerImpl getVanilla() {
        return this.player.connection;
    }

    public void handlePlayerInput(ServerboundPlayerInputPacket packet) {
        this.getVanilla().handlePlayerInput(packet);
    }

    public void handleMoveVehicle(ServerboundMoveVehiclePacket packet) {
        this.getVanilla().handleMoveVehicle(packet);
    }

    public void handleAcceptTeleportPacket(ServerboundAcceptTeleportationPacket packet) {
        this.getVanilla().handleAcceptTeleportPacket(packet);
    }

    public void handleRecipeBookSeenRecipePacket(ServerboundRecipeBookSeenRecipePacket packet) {
        this.getVanilla().handleRecipeBookSeenRecipePacket(packet);
    }

    public void handleRecipeBookChangeSettingsPacket(ServerboundRecipeBookChangeSettingsPacket packet) {
        this.getVanilla().handleRecipeBookChangeSettingsPacket(packet);
    }

    public void handleSeenAdvancements(ServerboundSeenAdvancementsPacket packet) {
        this.getVanilla().handleSeenAdvancements(packet);
    }

    public void handleCustomCommandSuggestions(ServerboundCommandSuggestionPacket packet) {
        this.getVanilla().handleCustomCommandSuggestions(packet);
    }

    public void handleSetCommandBlock(ServerboundSetCommandBlockPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        if (!this.server.isCommandBlockEnabled()) {
            this.player.sendSystemMessage((Component)Component.translatable((String)"advMode.notEnabled"));
        } else if (!this.player.canUseGameMasterBlocks()) {
            this.player.sendSystemMessage((Component)Component.translatable((String)"advMode.notAllowed"));
        } else {
            BaseCommandBlock basecommandblock = null;
            CommandBlockEntity commandblockentity = null;
            BlockPos blockpos = packet.getPos();
            BlockEntity blockentity = this.level.getBlockEntity(blockpos);
            if (blockentity instanceof CommandBlockEntity) {
                commandblockentity = (CommandBlockEntity)blockentity;
                basecommandblock = commandblockentity.getCommandBlock();
            }
            String s = packet.getCommand();
            boolean flag = packet.isTrackOutput();
            if (basecommandblock != null) {
                CommandBlockEntity.Mode commandblockentity$mode = commandblockentity.getMode();
                BlockState blockstate = this.level.getBlockState(blockpos);
                Direction direction = (Direction)blockstate.getValue((Property)CommandBlock.FACING);
                BlockState blockstate1 = switch (packet.getMode()) {
                    case CommandBlockEntity.Mode.SEQUENCE -> Blocks.CHAIN_COMMAND_BLOCK.defaultBlockState();
                    case CommandBlockEntity.Mode.AUTO -> Blocks.REPEATING_COMMAND_BLOCK.defaultBlockState();
                    default -> Blocks.COMMAND_BLOCK.defaultBlockState();
                };
                BlockState blockstate2 = (BlockState)((BlockState)blockstate1.setValue((Property)CommandBlock.FACING, (Comparable)direction)).setValue((Property)CommandBlock.CONDITIONAL, (Comparable)Boolean.valueOf(packet.isConditional()));
                if (blockstate2 != blockstate) {
                    this.level.setBlock(blockpos, blockstate2, 2);
                    blockentity.setBlockState(blockstate2);
                    this.level.getChunkAt(blockpos).setBlockEntity(blockentity);
                }
                basecommandblock.setCommand(s);
                basecommandblock.setTrackOutput(flag);
                if (!flag) {
                    basecommandblock.setLastOutput((Component)null);
                }
                commandblockentity.setAutomatic(packet.isAutomatic());
                if (commandblockentity$mode != packet.getMode()) {
                    commandblockentity.onModeSwitch();
                }
                basecommandblock.onUpdated();
                if (!StringUtil.isNullOrEmpty((String)s)) {
                    this.player.sendSystemMessage((Component)Component.translatable((String)"advMode.setCommand.success", (Object[])new Object[]{s}));
                }
            }
        }
    }

    public void handleSetCommandMinecart(ServerboundSetCommandMinecartPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        if (!this.server.isCommandBlockEnabled()) {
            this.player.sendSystemMessage((Component)Component.translatable((String)"advMode.notEnabled"));
        } else if (!this.player.canUseGameMasterBlocks()) {
            this.player.sendSystemMessage((Component)Component.translatable((String)"advMode.notAllowed"));
        } else {
            BaseCommandBlock basecommandblock = packet.getCommandBlock(this.level);
            if (basecommandblock != null) {
                basecommandblock.setCommand(packet.getCommand());
                basecommandblock.setTrackOutput(packet.isTrackOutput());
                if (!packet.isTrackOutput()) {
                    basecommandblock.setLastOutput((Component)null);
                }
                basecommandblock.onUpdated();
                this.player.sendSystemMessage((Component)Component.translatable((String)"advMode.setCommand.success", (Object[])new Object[]{packet.getCommand()}));
            }
        }
    }

    public void handlePickItem(ServerboundPickItemPacket packet) {
        this.getVanilla().handlePickItem(packet);
    }

    public void handleRenameItem(ServerboundRenameItemPacket packet) {
        this.getVanilla().handleRenameItem(packet);
    }

    public void handleSetBeaconPacket(ServerboundSetBeaconPacket packet) {
        this.getVanilla().handleSetBeaconPacket(packet);
    }

    public void handleSetStructureBlock(ServerboundSetStructureBlockPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        ServerLevel level = this.requiresServerLevel();
        if (this.player.canUseGameMasterBlocks()) {
            BlockPos blockpos = packet.getPos();
            BlockState blockstate = level.getBlockState(blockpos);
            BlockEntity blockentity = level.getBlockEntity(blockpos);
            if (blockentity instanceof StructureBlockEntity) {
                StructureBlockEntity structure = (StructureBlockEntity)blockentity;
                structure.setMode(packet.getMode());
                structure.setStructureName(packet.getName());
                structure.setStructurePos(packet.getOffset());
                structure.setStructureSize(packet.getSize());
                structure.setMirror(packet.getMirror());
                structure.setRotation(packet.getRotation());
                structure.setMetaData(packet.getData());
                structure.setIgnoreEntities(packet.isIgnoreEntities());
                structure.setShowAir(packet.isShowAir());
                structure.setShowBoundingBox(packet.isShowBoundingBox());
                structure.setIntegrity(packet.getIntegrity());
                structure.setSeed(packet.getSeed());
                if (structure.hasStructureName()) {
                    String s = structure.getStructureName();
                    if (packet.getUpdateType() == StructureBlockEntity.UpdateType.SAVE_AREA) {
                        if (structure.saveStructure()) {
                            this.player.displayClientMessage((Component)Component.translatable((String)"structure_block.save_success", (Object[])new Object[]{s}), false);
                        } else {
                            this.player.displayClientMessage((Component)Component.translatable((String)"structure_block.save_failure", (Object[])new Object[]{s}), false);
                        }
                    } else if (packet.getUpdateType() == StructureBlockEntity.UpdateType.LOAD_AREA) {
                        if (!structure.isStructureLoadable()) {
                            this.player.displayClientMessage((Component)Component.translatable((String)"structure_block.load_not_found", (Object[])new Object[]{s}), false);
                        } else if (structure.placeStructureIfSameSize(level)) {
                            this.player.displayClientMessage((Component)Component.translatable((String)"structure_block.load_success", (Object[])new Object[]{s}), false);
                        } else {
                            this.player.displayClientMessage((Component)Component.translatable((String)"structure_block.load_prepare", (Object[])new Object[]{s}), false);
                        }
                    } else if (packet.getUpdateType() == StructureBlockEntity.UpdateType.SCAN_AREA) {
                        if (structure.detectSize()) {
                            this.player.displayClientMessage((Component)Component.translatable((String)"structure_block.size_success", (Object[])new Object[]{s}), false);
                        } else {
                            this.player.displayClientMessage((Component)Component.translatable((String)"structure_block.size_failure"), false);
                        }
                    }
                } else {
                    this.player.displayClientMessage((Component)Component.translatable((String)"structure_block.invalid_structure_name", (Object[])new Object[]{packet.getName()}), false);
                }
                structure.setChanged();
                level.sendBlockUpdated(blockpos, blockstate, blockstate, 3);
            }
        }
    }

    public void handleSetJigsawBlock(ServerboundSetJigsawBlockPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        if (this.player.canUseGameMasterBlocks()) {
            BlockPos blockpos = packet.getPos();
            BlockState blockstate = this.level.getBlockState(blockpos);
            BlockEntity blockentity = this.level.getBlockEntity(blockpos);
            if (blockentity instanceof JigsawBlockEntity) {
                JigsawBlockEntity jigsaw = (JigsawBlockEntity)blockentity;
                jigsaw.setName(packet.getName());
                jigsaw.setTarget(packet.getTarget());
                jigsaw.setPool(ResourceKey.create((ResourceKey)Registries.TEMPLATE_POOL, (ResourceLocation)packet.getPool()));
                jigsaw.setFinalState(packet.getFinalState());
                jigsaw.setJoint(packet.getJoint());
                jigsaw.setChanged();
                this.level.sendBlockUpdated(blockpos, blockstate, blockstate, 3);
            }
        }
    }

    public void handleJigsawGenerate(ServerboundJigsawGeneratePacket packet) {
        BlockEntity blockentity;
        this.ensureRunningOnSameThread((Packet)packet);
        ServerLevel level = this.requiresServerLevel();
        if (this.player.canUseGameMasterBlocks() && (blockentity = level.getBlockEntity(packet.getPos())) instanceof JigsawBlockEntity) {
            JigsawBlockEntity jigsawblockentity = (JigsawBlockEntity)blockentity;
            jigsawblockentity.generate(level, packet.levels(), packet.keepJigsaws());
        }
    }

    public void handleSelectTrade(ServerboundSelectTradePacket packet) {
        this.getVanilla().handleSelectTrade(packet);
    }

    public void handleEditBook(ServerboundEditBookPacket packet) {
        this.getVanilla().handleEditBook(packet);
    }

    public void handleEntityTagQuery(ServerboundEntityTagQueryPacket packet) {
        Entity entity;
        this.ensureRunningOnSameThread((Packet)packet);
        if (this.player.hasPermissions(2) && (entity = this.level.getEntity(packet.getEntityId())) != null) {
            this.send((Packet<?>)new ClientboundTagQueryPacket(packet.getTransactionId(), entity.saveWithoutId(new CompoundTag())));
        }
    }

    public void handleBlockEntityTagQuery(ServerboundBlockEntityTagQueryPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        if (this.player.hasPermissions(2)) {
            BlockEntity blockentity = this.level.getBlockEntity(packet.getPos());
            CompoundTag compoundtag = blockentity != null ? blockentity.saveWithoutMetadata((HolderLookup.Provider)this.level.registryAccess()) : null;
            this.send((Packet<?>)new ClientboundTagQueryPacket(packet.getTransactionId(), compoundtag));
        }
    }

    public void handleMovePlayer(ServerboundMovePlayerPacket packet) {
        this.getVanilla().handleMovePlayer(packet);
    }

    public void handlePlayerAction(ServerboundPlayerActionPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        BlockPos blockpos = packet.getPos();
        this.player.resetLastActionTime();
        switch (packet.getAction()) {
            case SWAP_ITEM_WITH_OFFHAND: 
            case DROP_ITEM: 
            case DROP_ALL_ITEMS: 
            case RELEASE_USE_ITEM: {
                this.getVanilla().handlePlayerAction(packet);
                return;
            }
            case START_DESTROY_BLOCK: 
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                this.handleBlockBreakAction(blockpos, packet.getAction(), packet.getDirection(), this.level.getMaxBuildHeight(), packet.getSequence());
                this.ackBlockChangesUpTo(this.level, packet.getSequence());
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    private static boolean wasBlockPlacementAttempt(ServerPlayer player, ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        Item item = stack.getItem();
        return (item instanceof BlockItem || item instanceof BucketItem) && !player.getCooldowns().isOnCooldown(item);
    }

    public void handleUseItemOn(ServerboundUseItemOnPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        this.ackBlockChangesUpTo(this.level, packet.getSequence());
        this.player.connection.ackBlockChangesUpTo(packet.getSequence());
        InteractionHand interactionhand = packet.getHand();
        ItemStack itemstack = this.player.getItemInHand(interactionhand);
        if (itemstack.isItemEnabled(this.level.enabledFeatures())) {
            BlockHitResult blockhitresult = packet.getHitResult();
            Vec3 vec3 = blockhitresult.getLocation();
            BlockPos blockpos = blockhitresult.getBlockPos();
            Vec3 vec31 = Vec3.atCenterOf((Vec3i)blockpos);
            if (this.player.canInteractWithBlock(blockpos, 1.0)) {
                Vec3 vec32 = vec3.subtract(vec31);
                if (Math.abs(vec32.x()) < 1.0000001 && Math.abs(vec32.y()) < 1.0000001 && Math.abs(vec32.z()) < 1.0000001) {
                    Direction direction = blockhitresult.getDirection();
                    this.player.resetLastActionTime();
                    int i = this.level.getMaxBuildHeight();
                    if (blockpos.getY() < i) {
                        if (((ServerGamePacketListenerImplAccessor)this.getVanilla()).getAwaitingPositionFromClient() == null && this.level.mayInteract((Player)this.player, blockpos)) {
                            InteractionResult interactionresult = this.player.gameMode.useItemOn(this.player, this.level, itemstack, interactionhand, blockhitresult);
                            if (direction == Direction.UP && !interactionresult.consumesAction() && blockpos.getY() >= i - 1 && LittleServerPlayerHandler.wasBlockPlacementAttempt(this.player, itemstack)) {
                                MutableComponent component = Component.translatable((String)"build.tooHigh", (Object[])new Object[]{i - 1}).withStyle(ChatFormatting.RED);
                                this.player.sendSystemMessage((Component)component, true);
                            } else if (interactionresult.shouldSwing()) {
                                this.player.swing(interactionhand, true);
                            }
                        }
                    } else {
                        MutableComponent component1 = Component.translatable((String)"build.tooHigh", (Object[])new Object[]{i - 1}).withStyle(ChatFormatting.RED);
                        this.player.sendSystemMessage((Component)component1, true);
                    }
                    this.send(this.level, (Packet<?>)new ClientboundBlockUpdatePacket((BlockGetter)this.level, blockpos));
                    this.send(this.level, (Packet<?>)new ClientboundBlockUpdatePacket((BlockGetter)this.level, blockpos.relative(direction)));
                } else {
                    LOGGER.warn("Rejecting UseItemOnPacket from {}: Location {} too far away from hit block {}.", (Object)this.player.getGameProfile().getName(), (Object)vec3, (Object)blockpos);
                }
            }
        }
    }

    public void handleUseItem(ServerboundUseItemPacket packet) {
        this.ensureRunningOnSameThread((Packet)packet);
        this.ackBlockChangesUpTo(this.level, packet.getSequence());
        InteractionHand interactionhand = packet.getHand();
        ItemStack itemstack = this.player.getItemInHand(interactionhand);
        this.player.resetLastActionTime();
        if (!itemstack.isEmpty() && itemstack.isItemEnabled(this.level.enabledFeatures()) && this.useItem(this.level, itemstack, interactionhand).shouldSwing()) {
            this.player.swing(interactionhand, true);
        }
    }

    public void handleTeleportToEntityPacket(ServerboundTeleportToEntityPacket packet) {
        this.getVanilla().handleTeleportToEntityPacket(packet);
    }

    public void handleResourcePackResponse(ServerboundResourcePackPacket packet) {
        this.getVanilla().handleResourcePackResponse(packet);
    }

    public void handlePaddleBoat(ServerboundPaddleBoatPacket packet) {
        this.getVanilla().handlePaddleBoat(packet);
    }

    public void handlePong(ServerboundPongPacket packet) {
        this.getVanilla().handlePong(packet);
    }

    public void disconnect(Component reason) {
        this.getVanilla().disconnect(reason);
    }

    public void ackBlockChangesUpTo(Level level, int sequence) {
        if (sequence < 0) {
            throw new IllegalArgumentException("Expected packet sequence nr >= 0");
        }
        this.ackBlockChanges.put((Object)level, Math.max(sequence, this.ackBlockChanges.getOrDefault((Object)level, -1)));
    }

    public void send(Packet<?> packet) {
        this.send(this.level, packet);
    }

    public void send(Level level, Packet<?> packet) {
        this.send(level, packet, null);
    }

    public void send(Level level, Packet<?> packet, @Nullable PacketSendListener listener) {
        try {
            LittleTiles.NETWORK.sendToClient((CreativePacket)new LittleVanillaPacket((LittleLevel)level, packet), this.player);
            if (listener != null) {
                listener.onSuccess();
            }
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.forThrowable((Throwable)throwable, (String)"Sending packet");
            CrashReportCategory crashreportcategory = crashreport.addCategory("Packet being sent");
            crashreportcategory.setDetail("Packet class", () -> packet.getClass().getCanonicalName());
            throw new ReportedException(crashreport);
        }
    }

    public void handleSetCarriedItem(ServerboundSetCarriedItemPacket packet) {
        this.getVanilla().handleSetCarriedItem(packet);
    }

    public void handleChat(ServerboundChatPacket packet) {
        this.getVanilla().handleChat(packet);
    }

    public void handleChatCommand(ServerboundChatCommandPacket packet) {
        this.getVanilla().handleChatCommand(packet);
    }

    public void handleChatAck(ServerboundChatAckPacket packet) {
        this.getVanilla().handleChatAck(packet);
    }

    public void handleAnimate(ServerboundSwingPacket packet) {
        this.getVanilla().handleAnimate(packet);
    }

    public void handlePlayerCommand(ServerboundPlayerCommandPacket packet) {
        this.getVanilla().handlePlayerCommand(packet);
    }

    public void handleInteract(ServerboundInteractPacket packet) {
        this.getVanilla().handleInteract(packet);
    }

    public void handleClientCommand(ServerboundClientCommandPacket packet) {
        this.getVanilla().handleClientCommand(packet);
    }

    public void handleContainerClose(ServerboundContainerClosePacket packet) {
        this.getVanilla().handleContainerClose(packet);
    }

    public void handleContainerClick(ServerboundContainerClickPacket packet) {
        this.getVanilla().handleContainerClick(packet);
    }

    public void handlePlaceRecipe(ServerboundPlaceRecipePacket packet) {
        this.getVanilla().handlePlaceRecipe(packet);
    }

    public void handleContainerButtonClick(ServerboundContainerButtonClickPacket packet) {
        this.getVanilla().handleContainerButtonClick(packet);
    }

    public void handleSetCreativeModeSlot(ServerboundSetCreativeModeSlotPacket packet) {
        this.getVanilla().handleSetCreativeModeSlot(packet);
    }

    public void handleSignUpdate(ServerboundSignUpdatePacket packet) {
        List<String> list = Stream.of(packet.getLines()).map(ChatFormatting::stripFormatting).collect(Collectors.toList());
        ((ServerGamePacketListenerImplAccessor)this.getVanilla()).callFilterTextPacket(list).thenAcceptAsync(lines -> this.updateSignText(packet, (List<FilteredText>)lines), (Executor)this.server);
    }

    private void updateSignText(ServerboundSignUpdatePacket packet, List<FilteredText> lines) {
        this.player.resetLastActionTime();
        BlockPos blockpos = packet.getPos();
        if (this.level.hasChunkAt(blockpos)) {
            BlockEntity blockentity = this.level.getBlockEntity(blockpos);
            if (!(blockentity instanceof SignBlockEntity)) {
                return;
            }
            SignBlockEntity signblockentity = (SignBlockEntity)blockentity;
            signblockentity.updateSignText((Player)this.player, packet.isFrontText(), lines);
        }
    }

    public void handleKeepAlive(ServerboundKeepAlivePacket packet) {
        this.getVanilla().handleKeepAlive(packet);
    }

    public void handlePlayerAbilities(ServerboundPlayerAbilitiesPacket packet) {
        this.getVanilla().handlePlayerAbilities(packet);
    }

    public void handleClientInformation(ServerboundClientInformationPacket packet) {
        this.getVanilla().handleClientInformation(packet);
    }

    public void handleCustomPayload(ServerboundCustomPayloadPacket packet) {
        this.getVanilla().handleCustomPayload(packet);
    }

    public void handleChangeDifficulty(ServerboundChangeDifficultyPacket packet) {
        this.getVanilla().handleChangeDifficulty(packet);
    }

    public void handleLockDifficulty(ServerboundLockDifficultyPacket packet) {
        this.getVanilla().handleLockDifficulty(packet);
    }

    public void handleChatSessionUpdate(ServerboundChatSessionUpdatePacket packet) {
        this.getVanilla().handleChatSessionUpdate(packet);
    }

    public void tick() {
        if (!this.ackBlockChanges.isEmpty()) {
            for (Object2IntMap.Entry entry : this.ackBlockChanges.object2IntEntrySet()) {
                this.send((Level)entry.getKey(), (Packet<?>)new ClientboundBlockChangedAckPacket(entry.getIntValue()));
            }
            this.ackBlockChanges.clear();
        }
        ++this.gameTicks;
        if (this.hasDelayedDestroy) {
            BlockState blockstate = this.destroyLevel.getBlockState(this.delayedDestroyPos);
            if (blockstate.isAir()) {
                this.hasDelayedDestroy = false;
            } else {
                float f = this.incrementDestroyProgress(this.destroyLevel, blockstate, this.delayedDestroyPos, this.delayedTickStart);
                if (f >= 1.0f) {
                    this.hasDelayedDestroy = false;
                    this.destroyBlock(this.destroyLevel, this.delayedDestroyPos);
                    this.destroyLevel = null;
                }
            }
        } else if (this.isDestroyingBlock) {
            BlockState blockstate1 = this.destroyLevel.getBlockState(this.destroyPos);
            if (blockstate1.isAir()) {
                this.destroyLevel.destroyBlockProgress(this.player.getId(), this.destroyPos, -1);
                this.lastSentState = -1;
                this.isDestroyingBlock = false;
                this.destroyLevel = null;
            } else {
                this.incrementDestroyProgress(this.destroyLevel, blockstate1, this.destroyPos, this.destroyProgressStart);
            }
        }
    }

    private float incrementDestroyProgress(Level level, BlockState state, BlockPos pos, int ticks) {
        int i = this.gameTicks - ticks;
        float f = state.getDestroyProgress((Player)this.player, (BlockGetter)level, pos) * (float)(i + 1);
        int j = (int)(f * 10.0f);
        if (j != this.lastSentState) {
            level.destroyBlockProgress(this.player.getId(), pos, j);
            this.lastSentState = j;
        }
        return f;
    }

    private void debugLogging(BlockPos pos, boolean p_215127_, int sequence, String message) {
    }

    public boolean isCreative() {
        return this.player.isCreative();
    }

    public GameType getGameMode() {
        return this.player.gameMode.getGameModeForPlayer();
    }

    public void handleBlockBreakAction(BlockPos pos, ServerboundPlayerActionPacket.Action action, Direction direction, int buildHeight, int sequence) {
        PlayerInteractEvent.LeftClickBlock event = CommonHooks.onLeftClickBlock((Player)this.player, (BlockPos)pos, (Direction)direction, (ServerboundPlayerActionPacket.Action)action);
        if (event.isCanceled()) {
            return;
        }
        if (!this.player.canInteractWithBlock(pos, 1.0)) {
            this.debugLogging(pos, false, sequence, "too far");
        } else if (pos.getY() >= buildHeight) {
            this.send((Packet<?>)new ClientboundBlockUpdatePacket(pos, this.level.getBlockState(pos)));
            this.debugLogging(pos, false, sequence, "too high");
        } else if (action == ServerboundPlayerActionPacket.Action.START_DESTROY_BLOCK) {
            if (!this.level.mayInteract((Player)this.player, pos)) {
                this.send((Packet<?>)new ClientboundBlockUpdatePacket(pos, this.level.getBlockState(pos)));
                this.debugLogging(pos, false, sequence, "may not interact");
                return;
            }
            if (this.isCreative()) {
                this.destroyAndAck(this.level, pos, sequence, "creative destroy");
                return;
            }
            if (this.player.blockActionRestricted(this.level, pos, this.getGameMode())) {
                this.send((Packet<?>)new ClientboundBlockUpdatePacket(pos, this.level.getBlockState(pos)));
                this.debugLogging(pos, false, sequence, "block action restricted");
                return;
            }
            this.destroyProgressStart = this.gameTicks;
            float f = 1.0f;
            BlockState blockstate = this.level.getBlockState(pos);
            if (!blockstate.isAir()) {
                Level level = this.level;
                if (level instanceof ServerLevel) {
                    ServerLevel s = (ServerLevel)level;
                    EnchantmentHelper.onHitBlock((ServerLevel)s, (ItemStack)this.player.getMainHandItem(), (LivingEntity)this.player, (Entity)this.player, (EquipmentSlot)EquipmentSlot.MAINHAND, (Vec3)Vec3.atCenterOf((Vec3i)pos), (BlockState)blockstate, x -> this.player.onEquippedItemBroken(x, EquipmentSlot.MAINHAND));
                }
                if (event.getUseBlock() != TriState.FALSE) {
                    blockstate.attack(this.level, pos, (Player)this.player);
                }
                f = blockstate.getDestroyProgress((Player)this.player, (BlockGetter)this.level, pos);
            }
            if (!blockstate.isAir() && f >= 1.0f) {
                this.destroyAndAck(this.level, pos, sequence, "insta mine");
            } else {
                if (this.isDestroyingBlock) {
                    this.send((Packet<?>)new ClientboundBlockUpdatePacket(this.destroyPos, this.level.getBlockState(this.destroyPos)));
                    this.debugLogging(pos, false, sequence, "abort destroying since another started (client insta mine, server disagreed)");
                }
                this.isDestroyingBlock = true;
                this.destroyPos = pos.immutable();
                this.destroyLevel = this.level;
                int i = (int)(f * 10.0f);
                this.level.destroyBlockProgress(this.player.getId(), pos, i);
                this.debugLogging(pos, true, sequence, "actual start of destroying");
                this.lastSentState = i;
            }
        } else if (action == ServerboundPlayerActionPacket.Action.STOP_DESTROY_BLOCK) {
            if (pos.equals((Object)this.destroyPos) && this.destroyLevel == this.level) {
                int j = this.gameTicks - this.destroyProgressStart;
                BlockState blockstate1 = this.level.getBlockState(pos);
                if (!blockstate1.isAir()) {
                    float f1 = blockstate1.getDestroyProgress((Player)this.player, (BlockGetter)this.level, pos) * (float)(j + 1);
                    if (f1 >= 0.7f) {
                        this.isDestroyingBlock = false;
                        this.level.destroyBlockProgress(this.player.getId(), pos, -1);
                        this.destroyAndAck(this.level, pos, sequence, "destroyed");
                        this.destroyLevel = null;
                        return;
                    }
                    if (!this.hasDelayedDestroy) {
                        this.isDestroyingBlock = false;
                        this.hasDelayedDestroy = true;
                        this.delayedDestroyPos = pos;
                        this.delayedTickStart = this.destroyProgressStart;
                        this.destroyLevel = null;
                    }
                }
            }
            this.debugLogging(pos, true, sequence, "stopped destroying");
        } else if (action == ServerboundPlayerActionPacket.Action.ABORT_DESTROY_BLOCK) {
            this.isDestroyingBlock = false;
            if (!Objects.equals(this.destroyPos, pos)) {
                LOGGER.warn("Mismatch in destroy block pos: {} {}", (Object)this.destroyPos, (Object)pos);
                this.destroyLevel.destroyBlockProgress(this.player.getId(), this.destroyPos, -1);
                this.debugLogging(pos, true, sequence, "aborted mismatched destroying");
            }
            if (!Objects.equals(this.destroyLevel, this.level)) {
                LOGGER.warn("Mismatch in destroy level: {} {}", (Object)this.destroyLevel, (Object)this.level);
                this.destroyLevel.destroyBlockProgress(this.player.getId(), this.destroyPos, -1);
                this.debugLogging(pos, true, sequence, "aborted mismatched destroying");
            }
            this.destroyLevel.destroyBlockProgress(this.player.getId(), pos, -1);
            this.destroyLevel = null;
            this.debugLogging(pos, true, sequence, "aborted destroying");
        }
    }

    public void destroyAndAck(Level level, BlockPos pos, int sequence, String message) {
        if (this.destroyBlock(level, pos)) {
            this.debugLogging(pos, true, sequence, message);
        } else {
            this.send(level, (Packet<?>)new ClientboundBlockUpdatePacket(pos, level.getBlockState(pos)));
            this.debugLogging(pos, false, sequence, message);
        }
    }

    public boolean destroyBlock(Level level, BlockPos pos) {
        BlockState blockstate1 = level.getBlockState(pos);
        BlockEvent.BreakEvent event = CommonHooks.fireBlockBreak((Level)level, (GameType)this.getGameMode(), (ServerPlayer)this.player, (BlockPos)pos, (BlockState)blockstate1);
        if (event.isCanceled()) {
            return false;
        }
        BlockEntity blockentity = level.getBlockEntity(pos);
        Block block = blockstate1.getBlock();
        if (block instanceof GameMasterBlock && !this.player.canUseGameMasterBlocks()) {
            level.sendBlockUpdated(pos, blockstate1, blockstate1, 3);
            return false;
        }
        if (this.player.blockActionRestricted(level, pos, this.getGameMode())) {
            return false;
        }
        BlockState blockstate = block.playerWillDestroy(level, pos, blockstate1, (Player)this.player);
        if (this.isCreative()) {
            this.removeBlock(level, pos, blockstate, false);
            return true;
        }
        ItemStack itemstack = this.player.getMainHandItem();
        ItemStack itemstack1 = itemstack.copy();
        boolean flag1 = blockstate.canHarvestBlock((BlockGetter)level, pos, (Player)this.player);
        itemstack.mineBlock(level, blockstate, pos, (Player)this.player);
        boolean flag = this.removeBlock(level, pos, blockstate, flag1);
        if (flag1 && flag) {
            block.playerDestroy(level, (Player)this.player, pos, blockstate, blockentity, itemstack1);
        }
        if (itemstack.isEmpty() && !itemstack1.isEmpty()) {
            EventHooks.onPlayerDestroyItem((Player)this.player, (ItemStack)itemstack1, (InteractionHand)InteractionHand.MAIN_HAND);
        }
        return true;
    }

    private boolean removeBlock(Level level, BlockPos pos, BlockState state, boolean canHarvest) {
        boolean removed = state.onDestroyedByPlayer(level, pos, (Player)this.player, canHarvest, level.getFluidState(pos));
        if (removed) {
            state.getBlock().destroy((LevelAccessor)level, pos, state);
        }
        return removed;
    }

    public InteractionResult useItem(Level level, ItemStack stack, InteractionHand hand) {
        if (this.getGameMode() == GameType.SPECTATOR) {
            return InteractionResult.PASS;
        }
        if (this.player.getCooldowns().isOnCooldown(stack.getItem())) {
            return InteractionResult.PASS;
        }
        InteractionResult cancelResult = CommonHooks.onItemRightClick((Player)this.player, (InteractionHand)hand);
        if (cancelResult != null) {
            return cancelResult;
        }
        int i = stack.getCount();
        int j = stack.getDamageValue();
        InteractionResultHolder result = stack.use(level, (Player)this.player, hand);
        ItemStack itemstack = (ItemStack)result.getObject();
        if (itemstack == stack && itemstack.getCount() == i && itemstack.getUseDuration((LivingEntity)this.player) <= 0 && itemstack.getDamageValue() == j) {
            return result.getResult();
        }
        if (result.getResult() == InteractionResult.FAIL && itemstack.getUseDuration((LivingEntity)this.player) > 0 && !this.player.isUsingItem()) {
            return result.getResult();
        }
        if (stack != itemstack) {
            this.player.setItemInHand(hand, itemstack);
        }
        if (this.isCreative()) {
            itemstack.setCount(i);
            if (itemstack.isDamageableItem() && itemstack.getDamageValue() != j) {
                itemstack.setDamageValue(j);
            }
        }
        if (itemstack.isEmpty()) {
            this.player.setItemInHand(hand, ItemStack.EMPTY);
        }
        if (!this.player.isUsingItem()) {
            this.player.inventoryMenu.sendAllDataToRemote();
        }
        return result.getResult();
    }

    public InteractionResult useItemOn(Level level, ItemStack stack, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result;
        BlockPos blockpos = hit.getBlockPos();
        BlockState blockstate = level.getBlockState(blockpos);
        if (!blockstate.getBlock().isEnabled(level.enabledFeatures())) {
            return InteractionResult.FAIL;
        }
        PlayerInteractEvent.RightClickBlock event = CommonHooks.onRightClickBlock((Player)this.player, (InteractionHand)hand, (BlockPos)blockpos, (BlockHitResult)hit);
        if (event.isCanceled()) {
            return event.getCancellationResult();
        }
        if (this.getGameMode() == GameType.SPECTATOR) {
            MenuProvider menuprovider = blockstate.getMenuProvider(level, blockpos);
            if (menuprovider != null) {
                this.player.openMenu(menuprovider);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.PASS;
        }
        UseOnContext useoncontext = new UseOnContext(level, (Player)this.player, hand, stack, hit);
        if (event.getUseItem() != TriState.FALSE && (result = stack.onItemUseFirst(useoncontext)) != InteractionResult.PASS) {
            return result;
        }
        boolean flag = !this.player.getMainHandItem().isEmpty() || !this.player.getOffhandItem().isEmpty();
        boolean flag1 = this.player.isSecondaryUseActive() && flag && (!this.player.getMainHandItem().doesSneakBypassUse((LevelReader)level, blockpos, (Player)this.player) || !this.player.getOffhandItem().doesSneakBypassUse((LevelReader)level, blockpos, (Player)this.player));
        ItemStack itemstack = stack.copy();
        if (event.getUseBlock().isTrue() || event.getUseBlock().isDefault() && !flag1) {
            InteractionResult interactionresult;
            ItemInteractionResult iteminteractionresult = blockstate.useItemOn(this.player.getItemInHand(hand), level, (Player)this.player, hand, hit);
            if (iteminteractionresult.consumesAction()) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(this.player, blockpos, itemstack);
                return iteminteractionresult.result();
            }
            if (iteminteractionresult == ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION && hand == InteractionHand.MAIN_HAND && (interactionresult = blockstate.useWithoutItem(level, (Player)this.player, hit)).consumesAction()) {
                CriteriaTriggers.DEFAULT_BLOCK_USE.trigger(this.player, blockpos);
                return interactionresult;
            }
        }
        if (event.getUseItem().isTrue() || !stack.isEmpty() && !this.player.getCooldowns().isOnCooldown(stack.getItem())) {
            InteractionResult interactionresult1;
            if (event.getUseItem().isFalse()) {
                return InteractionResult.PASS;
            }
            if (this.isCreative()) {
                int i = stack.getCount();
                interactionresult1 = stack.useOn(useoncontext);
                stack.setCount(i);
            } else {
                interactionresult1 = stack.useOn(useoncontext);
            }
            if (interactionresult1.consumesAction()) {
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(this.player, blockpos, itemstack);
            }
            return interactionresult1;
        }
        return InteractionResult.PASS;
    }

    public boolean isAcceptingMessages() {
        return this.getVanilla().isAcceptingMessages();
    }

    public void onDisconnect(DisconnectionDetails details) {
        this.getVanilla().onDisconnect(details);
    }

    public void handlePingRequest(ServerboundPingRequestPacket packet) {
        this.getVanilla().handlePingRequest(packet);
    }

    public void handleCookieResponse(ServerboundCookieResponsePacket packet) {
        this.getVanilla().handleCookieResponse(packet);
    }

    public void send(Packet<?> packet, @org.jetbrains.annotations.Nullable PacketSendListener listener) {
        this.send(this.level, packet, listener);
    }

    public Connection getConnection() {
        return this.getVanilla().getConnection();
    }

    public ReentrantBlockableEventLoop<?> getMainThreadEventLoop() {
        return this.getVanilla().getMainThreadEventLoop();
    }

    public ConnectionType getConnectionType() {
        return this.getVanilla().getConnectionType();
    }

    public void handleSignedChatCommand(ServerboundChatCommandSignedPacket packet) {
        this.getVanilla().handleSignedChatCommand(packet);
    }

    public void handleContainerSlotStateChanged(ServerboundContainerSlotStateChangedPacket packet) {
        this.getVanilla().handleContainerSlotStateChanged(packet);
    }

    public void handleConfigurationAcknowledged(ServerboundConfigurationAcknowledgedPacket packet) {
        this.getVanilla().handleConfigurationAcknowledged(packet);
    }

    public void handleChunkBatchReceived(ServerboundChunkBatchReceivedPacket packet) {
        this.getVanilla().handleChunkBatchReceived(packet);
    }

    public void handleDebugSampleSubscription(ServerboundDebugSampleSubscriptionPacket packet) {
        this.getVanilla().handleDebugSampleSubscription(packet);
    }

    @FunctionalInterface
    static interface EntityInteraction {
        public InteractionResult run(ServerPlayer var1, Entity var2, InteractionHand var3);
    }
}

