/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.client.tool;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4fStack;
import team.creative.creativecore.common.network.CreativePacket;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.mc.PlayerUtils;
import team.creative.creativecore.common.util.mc.TickUtils;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.api.common.tool.ILittleTransformer;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.client.action.LittleActionHandlerClient;
import team.creative.littletiles.client.tool.LittleTool;
import team.creative.littletiles.client.tool.shaper.ShapePosition;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.grid.IGridBased;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.LittleBoxAbsolute;
import team.creative.littletiles.common.math.box.LittleTransformableBox;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.math.vec.LittleVecAbsolute;
import team.creative.littletiles.common.packet.action.ChangedElementPacket;
import team.creative.littletiles.common.placement.PlacementHelper;
import team.creative.littletiles.common.placement.PreviewMode;

public class LittleToolTransformer
extends LittleTool {
    private ShapePosition first;
    private ShapePosition last;
    private LittleBoxAbsolute box = null;
    private LittleVecAbsolute[] corners = new LittleVecAbsolute[BoxCorner.values().length];
    private int marked = -1;
    private ILittleTransformer transformer;

    public LittleToolTransformer(ItemStack stack) {
        super(stack);
        this.transformer = (ILittleTransformer)stack.getItem();
    }

    @Override
    public void tick(Level level, Player player, @Nullable BlockHitResult blockHit) {
        if (blockHit == null) {
            return;
        }
        this.last = new ShapePosition(player, PlacementHelper.getPosition(level, blockHit, this.transformer.getPositionGrid(player, this.stack), this.stack), blockHit, false, this.transformer.previewInside(player, this.stack));
    }

    protected LittleBoxAbsolute getSelectionBox() {
        LittleGrid grid;
        BlockPos pos = this.last.getPos();
        LittleBox selectionBox = LittleBox.ofNothing();
        if (this.first != null) {
            grid = this.first.unsafeSameGridRestore((IGridBased)this.last, () -> {
                selectionBox.growToIncludePixel(this.first.getRelative(pos));
                selectionBox.growToIncludePixel(this.last.getRelative(pos));
                return this.first.getGrid();
            });
        } else {
            selectionBox.growToIncludePixel(this.last.getRelative(pos));
            grid = this.last.getGrid();
        }
        return new LittleBoxAbsolute(pos, selectionBox, grid);
    }

    protected void updateBox() {
        LittleTransformableBox tBox;
        LittleBox overallBox = LittleBox.ofNothing();
        BlockPos pos = this.corners[0].getPos();
        LittleGrid grid = this.corners[0].getGrid();
        LittleVec[] relativeCorners = new LittleVec[this.corners.length];
        for (int i = 0; i < this.corners.length; ++i) {
            LittleVecAbsolute corner = this.corners[i];
            LittleVec vec = corner.getRelative(pos);
            if (corner.getGrid().count > grid.count) {
                for (int j = 0; j < i; ++j) {
                    relativeCorners[j].convertTo(grid, corner.getGrid());
                }
                overallBox.convertTo(grid, corner.getGrid());
                grid = corner.getGrid();
            } else if (corner.getGrid().count < grid.count) {
                vec.convertTo(corner.getGrid(), grid);
            }
            overallBox.growToIncludePixel(vec);
            BoxCorner c = BoxCorner.values()[i];
            if (c.x.positive) {
                ++vec.x;
            }
            if (c.y.positive) {
                ++vec.y;
            }
            if (c.z.positive) {
                ++vec.z;
            }
            relativeCorners[i] = vec;
        }
        LittleTransformableBox littleTransformableBox = tBox = new LittleTransformableBox(overallBox, new int[1]);
        Objects.requireNonNull(littleTransformableBox);
        LittleTransformableBox.CornerCache cache = new LittleTransformableBox.CornerCache(littleTransformableBox, false);
        for (int i = 0; i < relativeCorners.length; ++i) {
            cache.setAbsolute(BoxCorner.values()[i], relativeCorners[i]);
        }
        int[] data = cache.getData();
        if (data.length == 1) {
            this.box = new LittleBoxAbsolute(pos, overallBox, grid);
        } else {
            tBox.setData(cache.getData());
            this.box = new LittleBoxAbsolute(pos, tBox, grid);
        }
    }

    @Override
    public void render(Level level, Player player, PoseStack pose, Vec3 cam, boolean lines) {
        BlockPos pos;
        MeshData mesh;
        if (this.transformer.previewMode(player, this.stack) == PreviewMode.LINES != lines) {
            return;
        }
        BufferBuilder builder = this.createTesselatorBuilder(lines);
        if (this.box != null) {
            pose.pushPose();
            pose.translate((float)(-cam.x), (float)(-cam.y), (float)(-cam.z));
            for (int i = 0; i < this.corners.length; ++i) {
                this.corners[i].render(pose, this.marked == i);
            }
            pose.popPose();
            this.buildBox(pose, this.box.getRenderingBox(), builder, 255, lines);
            mesh = builder.build();
            pos = this.box.pos;
        } else {
            if (this.last == null) {
                return;
            }
            LittleBoxAbsolute selectionBox = this.getSelectionBox();
            this.buildBox(pose, selectionBox.getRenderingBox(), builder, 255, lines);
            pos = selectionBox.pos;
            mesh = builder.build();
        }
        if (mesh != null) {
            Matrix4fStack matrix = RenderSystem.getModelViewStack();
            matrix.pushMatrix();
            matrix.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
            matrix.translate((float)(-cam.x), (float)(-cam.y), (float)(-cam.z));
            RenderSystem.applyModelViewMatrix();
            this.setupPreviewRenderer(lines);
            BufferUploader.drawWithShader((MeshData)mesh);
            matrix.popMatrix();
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.applyModelViewMatrix();
    }

    @Override
    public boolean onMouseWheelClickBlock(Level level, Player player, BlockHitResult result) {
        BlockState state = level.getBlockState(result.getBlockPos());
        if (LittleAction.isBlockValid(state)) {
            LittleTiles.NETWORK.sendToServer((CreativePacket)new ChangedElementPacket(new LittleElement(state, -1)));
            return true;
        }
        if (state.getBlock() instanceof BlockTile) {
            LittleTileContext context = LittleTileContext.selectFocused((BlockGetter)level, result.getBlockPos(), player);
            if (context.isComplete()) {
                LittleTiles.NETWORK.sendToServer((CreativePacket)new ChangedElementPacket(context.tile));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean onRightClick(Level level, Player player, @Nullable BlockHitResult result) {
        if (LittleActionHandlerClient.isUsingSecondMode()) {
            this.first = null;
            this.box = null;
            Arrays.fill(this.corners, null);
            return true;
        }
        if (this.box == null) {
            LittleBoxAbsolute selectionBox;
            if (this.first == null) {
                this.first = this.last.copy();
                return true;
            }
            this.box = selectionBox = this.getSelectionBox();
            for (int i = 0; i < this.corners.length; ++i) {
                BoxCorner corner = BoxCorner.values()[i];
                LittleVec vec = selectionBox.box.get(corner);
                if (corner.x.positive) {
                    --vec.x;
                }
                if (corner.y.positive) {
                    --vec.y;
                }
                if (corner.z.positive) {
                    --vec.z;
                }
                this.corners[i] = new LittleVecAbsolute(selectionBox.pos, selectionBox.grid, vec);
            }
            this.first = null;
            return true;
        }
        if (this.marked > -1) {
            this.corners[this.marked] = this.last;
            this.updateBox();
            return true;
        }
        this.transformer.boxFinished(level, player, this.stack, this.box);
        this.box = null;
        Arrays.fill(this.corners, null);
        return true;
    }

    @Override
    public boolean onLeftClick(Level level, Player player, BlockHitResult hit) {
        if (this.box != null) {
            int index = -1;
            double distance = Double.MAX_VALUE;
            float partialTickTime = TickUtils.getFrameTime((LevelAccessor)player.level());
            Vec3 pos = player.getEyePosition(partialTickTime);
            double reach = PlayerUtils.getReach((Player)player);
            Vec3 view = player.getViewVector(partialTickTime);
            Vec3 look = pos.add(view.x * reach, view.y * reach, view.z * reach);
            for (int i = 0; i < this.corners.length; ++i) {
                double tempDistance;
                Optional result = this.corners[i].getBox().clip(pos, look);
                if (!result.isPresent() || !((tempDistance = pos.distanceToSqr((Vec3)result.get())) < distance)) continue;
                index = i;
                distance = tempDistance;
            }
            this.marked = index;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(Level level, Player player, KeyMapping key) {
        Facing facing;
        if (this.box != null && this.marked > -1 && (facing = LittleTilesClient.facingFromKeybind(player, key)) != null) {
            LittleGrid grid = this.transformer.getPositionGrid(player, this.stack);
            LittleVec vec = new LittleVec(facing);
            vec.scale(Screen.hasControlDown() ? grid.count : 1);
            this.corners[this.marked].add(new LittleVecAbsolute(BlockPos.ZERO, grid, vec));
            this.updateBox();
            return true;
        }
        return false;
    }

    @Override
    public void removed() {
    }
}

