/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.block.mc;

import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import org.joml.Vector3d;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.client.IFakeRenderingBlock;
import team.creative.littletiles.api.common.block.ILittleMCBlock;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.block.mc.BlockFlowingWater;
import team.creative.littletiles.common.config.LittlePermissionInteract;
import team.creative.littletiles.common.math.box.LittleBox;

public class BlockWater
extends Block
implements ILittleMCBlock,
IFakeRenderingBlock {
    public BlockWater(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    public Block asVanillaBlock() {
        return this;
    }

    @Override
    public boolean isFluid(TagKey<Fluid> fluid) {
        return fluid.equals((Object)FluidTags.LAVA);
    }

    @Override
    public boolean canBeConvertedToVanilla() {
        return false;
    }

    @Override
    public InteractionResult use(IParentCollection parent, LittleTile tile, LittleBox box, Player player, BlockHitResult result) {
        if (player.getMainHandItem().getItem() instanceof BucketItem && !parent.isStructure() && ((LittlePermissionInteract)LittleTiles.CONFIG.interact.get((Player)player)).allowFlowingWater) {
            BlockState newState = (BlockState)((Block)LittleTilesRegistry.FLOWING_WATER.value()).defaultBlockState().setValue(BlockFlowingWater.FACING, (Comparable)Direction.values()[0]);
            parent.getBE().updateTiles(x -> {
                LittleTile newFlowing = new LittleTile(newState, -1, box.copy());
                x.noneStructureTiles().remove(tile, box);
                x.noneStructureTiles().add(newFlowing);
            });
            return InteractionResult.SUCCESS;
        }
        return ILittleMCBlock.super.use(parent, tile, box, player, result);
    }

    @Override
    public BlockState getFakeState(BlockState state) {
        return Blocks.WATER.defaultBlockState();
    }

    @Override
    public Vector3d getFogColor(IParentCollection parent, LittleTile tile, Entity entity, Vector3d originalColor, float partialTicks) {
        float f12 = 0.0f;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            AttributeInstance attributeinstance = living.getAttribute(Attributes.OXYGEN_BONUS);
            f12 = (float)(attributeinstance != null ? attributeinstance.getValue() : 0.0) * 0.2f;
            if (living.hasEffect(MobEffects.WATER_BREATHING)) {
                f12 = f12 * 0.3f + 0.6f;
            }
        }
        return new Vector3d((double)(0.02f + f12), (double)(0.02f + f12), (double)(0.2f + f12));
    }
}

