/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.control;

import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import team.creative.creativecore.client.render.GuiRenderHelper;
import team.creative.creativecore.common.gui.control.simple.GuiProgressbar;
import team.creative.creativecore.common.gui.style.ControlFormatting;
import team.creative.creativecore.common.util.type.Color;

public class GuiColorProgressBar
extends GuiProgressbar {
    public Color color;

    public GuiColorProgressBar(String name, double pos, double max, Color color) {
        super(name, pos, max);
        this.color = color;
    }

    public ControlFormatting getControlFormatting() {
        return ControlFormatting.NESTED_NO_PADDING;
    }

    public List<Component> getTooltip() {
        List tooltip = super.getTooltip();
        if (tooltip != null) {
            tooltip.add(Component.translatable((String)"gui.color.rightclick"));
        }
        return tooltip;
    }

    public boolean mouseClicked(double x, double y, int button) {
        if (button == 1) {
            GuiColorProgressBar.playSound((Holder.Reference)SoundEvents.UI_BUTTON_CLICK);
            return true;
        }
        return false;
    }

    protected void renderProgress(GuiGraphics graphics, double percent) {
        GuiRenderHelper.colorRect((GuiGraphics)graphics, (int)0, (int)0, (int)((int)((double)this.rect.getContentWidth() * percent)), (int)this.rect.getContentHeight(), (int)this.color.toInt());
    }
}

