/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.control;

import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import team.creative.creativecore.Side;
import team.creative.creativecore.common.config.gui.GuiConfigSubControlNested;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiComboBoxTree;
import team.creative.creativecore.common.gui.control.parent.GuiScrollY;
import team.creative.creativecore.common.gui.extension.GuiExtensionCreator;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.tool.ILittleShaper;
import team.creative.littletiles.common.placement.shape.LittleShape;
import team.creative.littletiles.common.placement.shape.LittleShapeInstance;
import team.creative.littletiles.common.placement.shape.ShapeRegistry;
import team.creative.littletiles.common.placement.shape.config.LittleShapeConfig;

public class GuiShapeConfiguration
extends GuiParent {
    protected final Player player;
    protected final ContainerSlotView tool;

    public GuiShapeConfiguration(Player player, String name, ContainerSlotView tool) {
        super(name);
        this.flow = GuiFlow.STACK_Y;
        this.player = player;
        this.tool = tool;
        GuiComboBoxTree box = new GuiComboBoxTree("shape", ShapeRegistry.SHAPE_TREE, x -> Component.translatable((String)("shape." + x))).setDirection(GuiExtensionCreator.ExtensionDirection.BELOW_OR_ABOVE_ANY_SIZE);
        box.setExpandableX();
        LittleShapeInstance shapeInstance = ((ILittleShaper)tool.get().getItem()).getShape(tool.get());
        box.select((Object)shapeInstance.shape);
        this.add((GuiControl)box);
        this.add((GuiControl)new GuiScrollY("settings").setHovered().setDim(20, 60).setExpandable());
        this.changed();
        this.registerEventChanged(x -> {
            if (x.control.is("shape")) {
                this.changed();
            }
        });
    }

    public HolderLookup.Provider provider() {
        return this.player.registryAccess();
    }

    public void changed() {
        GuiComboBoxTree box = (GuiComboBoxTree)this.get("shape");
        GuiScrollY scroll = (GuiScrollY)this.get("settings");
        scroll.clear();
        LittleShapeInstance in = (LittleShapeInstance)this.tool.get().get(LittleTilesRegistry.SHAPE);
        LittleShapeConfig config = in != null ? in.loadOtherConfig(this.provider(), (LittleShape)box.selected(), Side.CLIENT) : ShapeRegistry.createConfigDefault((LittleShape)box.selected());
        if (config != null) {
            scroll.add((GuiControl)ShapeRegistry.SHAPE_CONFIG_REGISTRY.create("config", (Object)config, Side.CLIENT));
        }
        scroll.reflow();
    }

    public LittleShapeInstance save() {
        LittleShapeInstance in;
        GuiComboBoxTree box = (GuiComboBoxTree)this.get("shape");
        GuiScrollY scroll = (GuiScrollY)this.get("settings");
        LittleShape shape = (LittleShape)box.selected((Object)((ILittleShaper)this.tool.get().getItem()).defaultShape());
        GuiConfigSubControlNested shapeConfig = (GuiConfigSubControlNested)scroll.get("config");
        LittleShapeConfig config = null;
        if (shapeConfig != null) {
            shapeConfig.save();
            config = (LittleShapeConfig)shapeConfig.value;
        }
        if ((in = (LittleShapeInstance)this.tool.get().get(LittleTilesRegistry.SHAPE)) == null) {
            in = LittleShapeInstance.of(shape);
        }
        return in.configure(this.provider(), shape, config, Side.CLIENT);
    }
}

