/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.signal.dialog;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiLayer;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.control.parent.GuiPanel;
import team.creative.creativecore.common.gui.control.parent.GuiScrollY;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.flow.GuiSizeRule;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.common.gui.signal.GuiSignalComponent;
import team.creative.littletiles.common.gui.signal.IConditionConfiguration;
import team.creative.littletiles.common.gui.signal.dialog.GuiDialogSignal;
import team.creative.littletiles.common.gui.tool.recipe.GuiTreeItemStructure;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.signal.component.ISignalComponent;
import team.creative.littletiles.common.structure.signal.gui.mode.GuiSignalModeConfiguration;
import team.creative.littletiles.common.structure.signal.input.SignalInputCondition;
import team.creative.littletiles.common.structure.signal.logic.SignalMode;
import team.creative.littletiles.common.structure.signal.output.InternalSignalOutput;
import team.creative.littletiles.common.structure.signal.output.SignalExternalOutputHandler;
import team.creative.littletiles.common.structure.signal.output.SignalOutputHandler;

public class GuiDialogSignalEvents
extends GuiLayer {
    public GuiTreeItemStructure item;
    public List<GuiSignalComponent> inputs;
    public List<GuiSignalEvent> events;

    public GuiDialogSignalEvents() {
        super("gui.dialog.signal.overview", 300, 200);
        this.flow = GuiFlow.STACK_Y;
    }

    public void init(GuiTreeItemStructure item) {
        this.item = item;
        this.inputs = item.signalSearch.search(true, true, true);
        this.events = new ArrayList<GuiSignalEvent>();
        for (GuiSignalEvent event : item.internalOutputs()) {
            this.events.add(event.copy());
        }
        for (GuiSignalEvent event : item.externalOutputs()) {
            this.events.add(event.copy());
        }
        super.init();
    }

    public void addEntry(GuiSignalEvent event) {
        GuiScrollY box = (GuiScrollY)this.get("content");
        GuiPanel panel = new GuiPanel("event", (GuiFlow)GuiFlow.STACK_Y);
        box.add(panel.setExpandableX());
        panel.add((GuiControl)new GuiLabel("label"));
        panel.add((GuiControl)new GuiLabel("mode"));
        GuiParent buttons = new GuiParent();
        panel.add(buttons.setExpandableX());
        buttons.add((GuiControl)new GuiButton("edit", x -> ((GuiDialogSignal)LittleTilesGuiRegistry.SIGNAL_DIALOG.open(this.getIntegratedParent(), new CompoundTag())).init(this.inputs, event)).setTranslate("gui.edit"));
        buttons.add((GuiControl)new GuiButton("reset", x -> event.reset()).setTranslate("gui.clear"));
        event.panel = panel;
        event.update();
    }

    public void create() {
        if (this.item == null) {
            return;
        }
        GuiParent upper = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add(upper.setExpandable());
        GuiScrollY left = new GuiScrollY("content");
        left.flow = GuiFlow.STACK_Y;
        upper.add((GuiControl)left.setExpandable());
        GuiScrollY right = new GuiScrollY("components");
        right.flow = GuiFlow.STACK_Y;
        upper.add(right.setDim((GuiSizeRule)new GuiSizeRule.GuiFixedDimension(100)).setExpandableY());
        right.add((GuiControl)new GuiLabel("title").setTranslate("gui.signal.components"));
        for (GuiSignalComponent component : this.inputs) {
            right.add((GuiControl)new GuiLabel(component.name()).setTitle((Component)Component.literal((String)component.display())));
        }
        for (GuiSignalEvent event : this.events) {
            this.addEntry(event);
        }
        GuiLeftRightBox bottom = new GuiLeftRightBox();
        this.add((GuiControl)bottom);
        bottom.addLeft((GuiControl)new GuiButton("cancel", x -> this.closeThisLayer()).setTranslate("gui.cancel"));
        bottom.addRight((GuiControl)new GuiButton("save", x -> {
            for (GuiSignalEvent event : this.events) {
                this.item.setSignalOutput(event.component.external(), event.component.index(), event);
            }
            this.closeThisLayer();
        }).setTranslate("gui.save"));
    }

    public static class GuiSignalEvent
    implements IConditionConfiguration {
        public final GuiSignalComponent component;
        public SignalInputCondition condition;
        public GuiSignalModeConfiguration modeConfig;
        public GuiPanel panel;

        public GuiSignalEvent(GuiSignalComponent component) {
            this.component = component;
            this.condition = null;
            this.modeConfig = component.defaultMode().createConfiguration(null);
        }

        public GuiSignalEvent(GuiSignalComponent component, InternalSignalOutput internal) {
            this.component = component;
            if (internal == null) {
                this.condition = null;
                this.modeConfig = component.defaultMode().createConfiguration(null);
            } else {
                this.condition = internal.condition;
                SignalMode mode = internal.handler != null ? internal.handler.getMode() : component.defaultMode();
                this.modeConfig = mode.createConfiguration(internal.handler);
            }
        }

        public GuiSignalEvent(GuiSignalComponent component, SignalExternalOutputHandler external) {
            this.component = component;
            if (external == null) {
                this.condition = null;
                this.modeConfig = component.defaultMode().createConfiguration(null);
            } else {
                this.condition = external.condition;
                SignalMode mode = external.handler != null ? external.handler.getMode() : component.defaultMode();
                this.modeConfig = mode.createConfiguration(external.handler);
            }
        }

        private GuiSignalEvent(GuiSignalComponent component, SignalInputCondition condition, GuiSignalModeConfiguration modeConfig) {
            this.component = component;
            this.condition = condition;
            this.modeConfig = modeConfig;
        }

        public void reset() {
            this.modeConfig = SignalMode.getConfigDefault();
            this.condition = null;
            this.update();
        }

        @Override
        public void update() {
            if (this.panel == null) {
                return;
            }
            GuiLabel label = (GuiLabel)this.panel.get("label");
            label.setTitle((Component)Component.literal((String)(this.component.name() + ": " + String.valueOf(this.condition))));
            GuiLabel mode = (GuiLabel)this.panel.get("mode");
            int delay = this.modeConfig.delay;
            if (this.condition != null) {
                delay = Math.max(delay, (int)Math.ceil(this.condition.calculateDelay()));
            }
            mode.setTitle((Component)this.modeConfig.description(delay));
        }

        public SignalOutputHandler getHandler(ISignalComponent component, LittleStructure structure) {
            if (this.condition != null) {
                return this.modeConfig.getHandler(component, structure);
            }
            return null;
        }

        public GuiSignalEvent copy() {
            return new GuiSignalEvent(this.component, this.condition, this.modeConfig.copy());
        }

        @Override
        public GuiSignalComponent getOutput() {
            return this.component;
        }

        @Override
        public SignalInputCondition getCondition() {
            return this.condition;
        }

        @Override
        public void setCondition(SignalInputCondition condition) {
            this.condition = condition;
        }

        @Override
        public boolean hasModeConfiguration() {
            return true;
        }

        @Override
        public GuiSignalModeConfiguration getModeConfiguration() {
            return this.modeConfig;
        }

        @Override
        public void setModeConfiguration(GuiSignalModeConfiguration config) {
            this.modeConfig = config;
        }
    }
}

