/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool;

import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.world.item.ItemStack;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.collection.GuiStackSelector;
import team.creative.creativecore.common.gui.control.simple.GuiColorPicker;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiShowItem;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.type.Color;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.client.LittleTilesClient;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.gui.LittleGuiUtils;
import team.creative.littletiles.common.gui.control.GuiGridConfig;
import team.creative.littletiles.common.gui.tool.GuiConfigureTool;
import team.creative.littletiles.common.item.ItemMultiTiles;
import team.creative.littletiles.common.placement.mode.PlacementMode;
import team.creative.littletiles.common.placement.setting.PlacementPlayerSetting;

public class GuiGlove
extends GuiConfigureTool {
    public GuiGlove(ContainerSlotView view) {
        super("glove", 230, 200, view);
        this.registerEventChanged(x -> {
            if (x.control.is(new String[]{"picker", "preview"})) {
                this.updateLabel();
            }
        });
        this.flow = GuiFlow.STACK_Y;
        this.valign = VAlign.STRETCH;
        this.registerEventChanged(x -> {
            if (x.control.is("mode")) {
                GuiComboBox modeBox = (GuiComboBox)x.control;
                TextBuilder builder = new TextBuilder();
                if (((PlacementMode)modeBox.selected()).canPlaceStructures()) {
                    builder.text(String.valueOf(ChatFormatting.BOLD)).translate("placement.mode.placestructure").text(String.valueOf(ChatFormatting.WHITE)).newLine();
                }
                builder.translate(((PlacementMode)modeBox.selected()).translatableKey() + ".tooltip");
                ((GuiLabel)this.get("text")).setTitle(builder.build());
                LittleTilesClient.placementMode((PlacementMode)modeBox.selected());
            }
        });
    }

    public void create() {
        if (!this.isClient()) {
            return;
        }
        GuiParent upper = new GuiParent();
        this.add((GuiControl)upper);
        GuiParent left = new GuiParent((GuiFlow)GuiFlow.STACK_Y).setAlign(Align.STRETCH);
        upper.add((GuiControl)left);
        LittleElement element = LittleElement.getOrDefault(this.tool.get());
        Color color = new Color(element.color);
        left.add((GuiControl)new GuiColorPicker("picker", color, LittleTiles.CONFIG.isTransparencyEnabled(this.getPlayer()), LittleTiles.CONFIG.getMinimumTransparency(this.getPlayer())));
        GuiParent parent = new GuiParent((GuiFlow)GuiFlow.STACK_X).setVAlign(VAlign.CENTER);
        left.add((GuiControl)parent);
        parent.add(new GuiShowItem("item").setDim(60, 60));
        parent.add((GuiControl)new GuiGridConfig("grid", this.getPlayer(), PlacementPlayerSetting.grid(this.getPlayer()), LittleTilesClient::grid));
        GuiStackSelector selector = new GuiStackSelector("preview", this.getPlayer(), LittleGuiUtils.getCollector(this.getPlayer()), true);
        selector.setSelectedForce(element.getBlock().getStack());
        left.add((GuiControl)selector);
        GuiParent right = new GuiParent((GuiFlow)GuiFlow.STACK_Y).setAlign(Align.STRETCH);
        upper.add((GuiControl)right);
        GuiComboBox modeBox = new GuiComboBox("mode", PlacementMode.map());
        modeBox.select((Object)PlacementPlayerSetting.placementMode(this.getPlayer()));
        right.add((GuiControl)modeBox);
        right.add((GuiControl)new GuiLabel("text"));
        this.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)modeBox));
        this.updateLabel();
    }

    public void updateLabel() {
        LittleElement element;
        GuiStackSelector selector = (GuiStackSelector)this.get("preview");
        ItemStack selected = selector.getSelected();
        GuiColorPicker picker = (GuiColorPicker)this.get("picker");
        try {
            element = LittleElement.of(selected, picker.color.toInt());
        }
        catch (LittleElement.NotBlockException e) {
            element = new LittleElement(LittleElement.getOrDefault(this.tool.get()), picker.color.toInt());
        }
        ((GuiShowItem)this.get((String)"item", GuiShowItem.class)).stack = ItemMultiTiles.of(element);
    }

    @Override
    public boolean saveConfiguration(PatchedDataComponentMap data) {
        LittleElement element;
        GuiColorPicker picker = (GuiColorPicker)this.get("picker");
        ItemStack selected = ((GuiStackSelector)this.get("preview", GuiStackSelector.class)).getSelected();
        try {
            element = LittleElement.of(selected, picker.color.toInt());
        }
        catch (LittleElement.NotBlockException e) {
            element = new LittleElement(LittleElement.getOrDefault(this.tool.get()), picker.color.toInt());
        }
        data.set((DataComponentType)LittleTilesRegistry.ELEMENT.get(), (Object)element);
        return true;
    }
}

