/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool;

import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.PatchedDataComponentMap;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.collection.GuiComboBox;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.event.GuiControlChangedEvent;
import team.creative.creativecore.common.gui.event.GuiEvent;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.control.GuiGridConfig;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.placement.mode.PlacementMode;

public abstract class GuiModeSelector
extends GuiConfigure {
    public LittleGrid grid;
    public PlacementMode mode;

    public GuiModeSelector(ContainerSlotView view, LittleGrid grid, PlacementMode mode) {
        super("mode-selector", 150, 150, view);
        this.grid = grid;
        this.mode = mode;
        this.registerEventChanged(x -> {
            if (x.control.is("mode")) {
                TextBuilder builder = new TextBuilder();
                if (this.getMode().canPlaceStructures()) {
                    builder.text(String.valueOf(ChatFormatting.BOLD)).translate("placement.mode.placestructure").text(String.valueOf(ChatFormatting.WHITE)).newLine();
                }
                builder.translate(this.getMode().translatableKey() + ".tooltip");
                ((GuiLabel)this.get("text")).setTitle(builder.build());
            }
        });
    }

    public void create() {
        GuiParent place = new GuiParent((GuiFlow)GuiFlow.STACK_Y);
        this.add((GuiControl)place);
        GuiComboBox box = new GuiComboBox("mode", PlacementMode.map());
        box.select((Object)this.mode);
        place.add((GuiControl)box);
        place.add((GuiControl)new GuiLabel("text"));
        GuiGridConfig gridBox = new GuiGridConfig("grid", this.getPlayer(), this.grid, null);
        gridBox.select(this.grid);
        this.add((GuiControl)gridBox);
        this.raiseEvent((GuiEvent)new GuiControlChangedEvent((GuiControl)box));
    }

    public PlacementMode getMode() {
        GuiComboBox box = (GuiComboBox)this.get("mode");
        return (PlacementMode)box.selected((Object)PlacementMode.getDefault());
    }

    public abstract boolean saveConfiguration(DataComponentMap var1, LittleGrid var2, PlacementMode var3);

    @Override
    public boolean saveConfiguration(PatchedDataComponentMap data) {
        this.mode = this.getMode();
        this.grid = ((GuiGridConfig)this.get("grid", GuiGridConfig.class)).get();
        return this.saveConfiguration((DataComponentMap)data, this.grid, this.mode);
    }
}

