/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.gui.tool.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.Align;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.VAlign;
import team.creative.creativecore.common.gui.control.collection.GuiComboBoxFlexible;
import team.creative.creativecore.common.gui.control.parent.GuiLeftRightBox;
import team.creative.creativecore.common.gui.control.simple.GuiButton;
import team.creative.creativecore.common.gui.control.simple.GuiButtonIcon;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.creativecore.common.gui.control.tree.GuiTree;
import team.creative.creativecore.common.gui.control.tree.GuiTreeItem;
import team.creative.creativecore.common.gui.dialog.DialogGuiLayer;
import team.creative.creativecore.common.gui.dialog.GuiDialogHandler;
import team.creative.creativecore.common.gui.flow.GuiFlow;
import team.creative.creativecore.common.gui.flow.GuiSizeRule;
import team.creative.creativecore.common.gui.integration.IGuiIntegratedParent;
import team.creative.creativecore.common.gui.style.Icon;
import team.creative.creativecore.common.gui.sync.GuiSyncLocal;
import team.creative.creativecore.common.gui.sync.GuiSyncLocalLayer;
import team.creative.creativecore.common.util.inventory.ContainerSlotView;
import team.creative.creativecore.common.util.math.geo.Rect;
import team.creative.creativecore.common.util.text.TextBuilder;
import team.creative.creativecore.common.util.text.TextMapBuilder;
import team.creative.creativecore.common.util.type.itr.FunctionIterator;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.api.common.tool.ILittleTool;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.gui.control.animation.GuiAnimationPanel;
import team.creative.littletiles.common.gui.tool.GuiConfigure;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipeAdd;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipeAnimationHandler;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipeAnimationStorage;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipeMerge;
import team.creative.littletiles.common.gui.tool.recipe.GuiRecipeMove;
import team.creative.littletiles.common.gui.tool.recipe.GuiTreeItemStructure;
import team.creative.littletiles.common.gui.tool.recipe.test.GuiRecipeTest;
import team.creative.littletiles.common.gui.tool.recipe.test.RecipeTest;
import team.creative.littletiles.common.gui.tool.recipe.test.RecipeTestError;
import team.creative.littletiles.common.gui.tool.recipe.test.RecipeTestResults;
import team.creative.littletiles.common.item.ItemLittleBlueprint;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGui;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGuiControl;
import team.creative.littletiles.common.structure.registry.gui.LittleStructureGuiRegistry;

public class GuiRecipe
extends GuiConfigure {
    public final GuiSyncLocal<EndTag> CLEAR_CONTENT = this.getSyncHolder().register("clear_content", tag -> {
        CompoundTag content = new CompoundTag();
        LittleGrid.MIN.set(content);
        ILittleTool.setData(this.tool.get(), content);
        this.tool.changed();
        LittleTilesGuiRegistry.OPEN_CONFIG.open(this.getPlayer());
    });
    public final GuiSyncLocal<EndTag> REMOVE_CONTENT = this.getSyncHolder().register("remove_content", tag -> {
        CompoundTag data = ILittleTool.getData(this.tool.get());
        data.remove("c");
        this.tool.get().remove(LittleTilesRegistry.DATA);
        this.tool.changed();
        LittleTilesGuiRegistry.OPEN_CONFIG.open(this.getPlayer());
    });
    public final GuiSyncLocal<CompoundTag> SAVE = this.getSyncHolder().register("save", tag -> {
        ILittleTool.setData(this.tool.get(), tag);
        this.tool.changed();
        GuiRecipe.super.closeThisLayer();
    });
    public final GuiSyncLocalLayer<GuiRecipeTest> OPEN_TEST = this.getSyncHolder().layer("test", tag -> new GuiRecipeTest());
    public final GuiSyncLocalLayer<GuiRecipeAdd> OPEN_ADD = this.getSyncHolder().layer("add", tag -> new GuiRecipeAdd());
    public final GuiSyncLocalLayer<GuiRecipeMove> OPEN_MOVE = this.getSyncHolder().layer("move", tag -> new GuiRecipeMove());
    public final GuiSyncLocalLayer<GuiRecipeMerge> OPEN_MERGE = this.getSyncHolder().layer("merge", tag -> new GuiRecipeMerge());
    public GuiTree tree;
    public GuiComboBoxFlexible<LittleStructureGui> types;
    public GuiParent config;
    public LittleStructureGuiControl control;
    public GuiLabel testReport;
    public GuiParent sidebarButtons;
    @OnlyIn(value=Dist.CLIENT)
    public GuiRecipeAnimationStorage storage;
    public GuiRecipeAnimationHandler animation = new GuiRecipeAnimationHandler();
    private boolean selectedBefore = true;

    public GuiRecipe(ContainerSlotView view) {
        super("recipe", view);
        this.flow = GuiFlow.STACK_X;
        this.valign = VAlign.STRETCH;
        this.setDim((GuiSizeRule)new GuiSizeRule.GuiSizeRules().minWidth(500).minHeight(300));
        this.registerEventChanged(x -> {
            if (x.control.is("type") && this.tree.selected() != null) {
                ((GuiTreeItemStructure)this.tree.selected()).load();
            } else if (x instanceof GuiTree.GuiTreeSelectionChanged) {
                GuiTree.GuiTreeSelectionChanged sel = (GuiTree.GuiTreeSelectionChanged)x;
                if (this.selectedBefore != (sel.selected != null)) {
                    this.selectedBefore = sel.selected != null;
                    for (GuiControl control : this.sidebarButtons) {
                        if (control.is("add")) continue;
                        control.setEnabled(this.selectedBefore);
                    }
                }
            }
        });
    }

    public void becameTopLayer() {
        super.becameTopLayer();
        if (this.isClient()) {
            ((GuiAnimationPanel)this.get("animation", GuiAnimationPanel.class)).refresh();
        }
    }

    @Override
    public boolean saveConfiguration(PatchedDataComponentMap data) {
        return false;
    }

    public void buildStructureTree(GuiTree tree, GuiTreeItem parent, LittleGroup group, int index) {
        if (group.isEmpty()) {
            if (!group.children.hasChildren()) {
                return;
            }
            for (LittleGroup child : group.children.children()) {
                this.buildStructureTree(tree, parent, child, index);
                ++index;
            }
            return;
        }
        LittleGroup copy = new LittleGroup(group.hasStructure() ? group.getStructureTag().copy() : null, (List<LittleGroup>)Collections.EMPTY_LIST);
        copy.addAll(group.getGrid(), (Iterable<LittleTile>)new FunctionIterator((Iterable)((Object)group), x -> x.copy()));
        for (Map.Entry extension : group.children.extensionEntries()) {
            copy.children.addExtension(extension.getKey(), ((LittleGroup)extension.getValue()).copy());
        }
        GuiTreeItemStructure item = new GuiTreeItemStructure(this, tree, copy, index);
        parent.addItem((GuiTreeItem)item);
        int i = 0;
        for (LittleGroup child : group.children.children()) {
            this.buildStructureTree(tree, item, child, i);
            ++i;
        }
    }

    public void closeThisLayer() {
        this.closeWithDialog();
    }

    public void closeTopLayer() {
        this.closeWithDialog();
    }

    @Override
    public void closed() {
        if (this.isClient()) {
            this.storage.unload();
        }
    }

    private void closeWithDialog() {
        if (this.runTest().success()) {
            CompoundTag nbt = LittleGroup.save(this.reconstructBlueprint());
            if (ItemLittleBlueprint.getContent(this.tool.get()).equals((Object)nbt)) {
                super.closeThisLayer();
                return;
            }
            GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"cancel", (Component)GuiRecipe.translatable((String)"gui.recipe.cancel.dialog"), (g, b) -> {
                if (b == DialogGuiLayer.DialogButton.CANCEL) {
                    return;
                }
                if (b == DialogGuiLayer.DialogButton.YES) {
                    this.SAVE.send((Tag)LittleGroup.save(this.reconstructBlueprint()));
                }
                GuiRecipe.super.closeThisLayer();
            }, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.CANCEL, DialogGuiLayer.DialogButton.NO, DialogGuiLayer.DialogButton.YES});
        } else {
            GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"cancel", (Component)GuiRecipe.translatable((String)"gui.recipe.cancel.dialog.failed"), (g, b) -> {
                if (b == DialogGuiLayer.DialogButton.CONFIRM) {
                    GuiRecipe.super.closeThisLayer();
                }
            }, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.ABORT, DialogGuiLayer.DialogButton.CONFIRM});
        }
    }

    public void create() {
        if (!this.isClient()) {
            return;
        }
        this.flow = GuiFlow.STACK_Y;
        this.align = Align.STRETCH;
        LittleGroup group = LittleGroup.load(ItemLittleBlueprint.getContent(this.tool.get()));
        GuiParent top = new GuiParent((GuiFlow)GuiFlow.STACK_X);
        this.add(top.setExpandableY());
        this.tree = new GuiTree("overview", false){

            public void updateTree() {
                GuiRecipe.this.actionOnAllItems(x -> x.updateTitle());
                super.updateTree();
            }
        }.setRootVisibility(false).keepSelected();
        if (this.storage == null) {
            this.storage = new GuiRecipeAnimationStorage(this.tree);
        }
        this.buildStructureTree(this.tree, this.tree.root(), group, 0);
        this.tree.root().setTitle((Component)Component.literal((String)"root"));
        this.tree.updateTree();
        GuiParent sidebar = new GuiParent((GuiFlow)GuiFlow.STACK_Y).setAlign(Align.STRETCH);
        top.add(sidebar.setDim((GuiSizeRule)new GuiSizeRule.GuiSizeRatioRules().widthRatio(0.2f).maxWidth(100)));
        sidebar.add(this.tree.setExpandableY());
        this.sidebarButtons = new GuiParent((GuiFlow)GuiFlow.FIT_X);
        sidebar.add((GuiControl)this.sidebarButtons.setAlign(Align.CENTER));
        this.sidebarButtons.add(new GuiButton("add", x -> ((GuiRecipeAdd)this.OPEN_ADD.open(new CompoundTag())).init(this)).setTranslate("gui.plus").setAlign(Align.CENTER).setVAlign(VAlign.CENTER).setDim(15, 15).setTooltip(new TextBuilder().translate("gui.recipe.add").build()));
        this.sidebarButtons.add(new GuiButtonIcon("duplicate", Icon.DUPLICATE, x -> {
            if (this.tree.selected() == null) {
                return;
            }
            this.tree.selected().getParentItem().addItem((GuiTreeItem)((GuiTreeItemStructure)this.tree.selected()).duplicate());
            this.tree.updateTree();
        }).setDim(15, 15).setTooltip(new TextBuilder().translate("gui.recipe.duplicate").build()));
        this.sidebarButtons.add(new GuiButton("del", x -> {
            if (this.tree.selected() == null) {
                return;
            }
            GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"delete_item", (Component)Component.translatable((String)"gui.recipe.dialog.delete", (Object[])new Object[]{((GuiTreeItemStructure)this.tree.selected()).getTitle()}), (g, b) -> {
                if (b == DialogGuiLayer.DialogButton.YES) {
                    this.removeItem((GuiTreeItemStructure)this.tree.selected());
                }
            }, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.NO, DialogGuiLayer.DialogButton.YES});
        }).setTranslate("gui.del").setAlign(Align.CENTER).setVAlign(VAlign.CENTER).setDim(15, 15).setTooltip(new TextBuilder().translate("gui.recipe.delete").build()));
        this.sidebarButtons.add(new GuiButtonIcon("move", Icon.MOVE, x -> ((GuiRecipeMove)this.OPEN_MOVE.open(new CompoundTag())).init(this)).setDim(15, 15).setTooltip(new TextBuilder().translate("gui.recipe.move").build()));
        this.sidebarButtons.add(new GuiButtonIcon("up", Icon.ARROW_UP, x -> this.tree.moveUp()).setDim(15, 15).setTooltip(new TextBuilder().translate("gui.recipe.moveup").build()));
        this.sidebarButtons.add(new GuiButtonIcon("down", Icon.ARROW_DOWN, x -> this.tree.moveDown()).setDim(15, 15).setTooltip(new TextBuilder().translate("gui.recipe.movedown").build()));
        this.sidebarButtons.add(new GuiButtonIcon("merge", Icon.MERGE, x -> ((GuiRecipeMerge)this.OPEN_MERGE.open(new CompoundTag())).init(this)).setDim(15, 15).setTooltip(new TextBuilder().translate("gui.recipe.merge").build()));
        GuiParent topCenter = new GuiParent((GuiFlow)GuiFlow.STACK_Y).setAlign(Align.STRETCH);
        top.add(topCenter.setDim((GuiSizeRule)new GuiSizeRule.GuiSizeRatioRules().widthRatio(0.4f).maxWidth(400)).setExpandableY());
        this.types = new GuiComboBoxFlexible("type", new TextMapBuilder().addComponent(LittleStructureGuiRegistry.registered(), x -> x.translatable()), x -> x.translatable());
        topCenter.add(this.types);
        this.config = new GuiParent("config", (GuiFlow)GuiFlow.STACK_Y).setAlign(Align.STRETCH);
        topCenter.add(this.config.setExpandableY());
        this.config.registerEventChanged(x -> {
            GuiTreeItem patt0$temp;
            if (x.control.is("name") && (patt0$temp = this.tree.selected()) instanceof GuiTreeItemStructure) {
                GuiTreeItemStructure item = (GuiTreeItemStructure)patt0$temp;
                item.onNameChanged((GuiTextfield)x.control);
            }
        });
        top.add((GuiControl)new GuiAnimationPanel(this.tree, this.storage, true, this.animation));
        GuiLeftRightBox bottom = new GuiLeftRightBox();
        this.add(bottom.setVAlign(VAlign.CENTER).setExpandableX());
        bottom.addLeft((GuiControl)new GuiButton("cancel", x -> this.closeThisLayer()).setTranslate("gui.cancel"));
        bottom.addLeft((GuiControl)new GuiButton("selection", x -> GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"remove_content", (Component)Component.translatable((String)"gui.recipe.dialog.clear"), (g, b) -> {
            if (b == DialogGuiLayer.DialogButton.YES) {
                this.REMOVE_CONTENT.send((Tag)EndTag.INSTANCE);
            }
        }, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.NO, DialogGuiLayer.DialogButton.YES})).setTranslate("gui.recipe.selection"));
        bottom.addLeft((GuiControl)new GuiButton("clear", x -> GuiDialogHandler.openDialog((IGuiIntegratedParent)this.getIntegratedParent(), (String)"clear_content", (Component)Component.translatable((String)"gui.recipe.dialog.clear"), (g, b) -> {
            if (b == DialogGuiLayer.DialogButton.YES) {
                this.CLEAR_CONTENT.send((Tag)EndTag.INSTANCE);
            }
        }, (DialogGuiLayer.DialogButton[])new DialogGuiLayer.DialogButton[]{DialogGuiLayer.DialogButton.NO, DialogGuiLayer.DialogButton.YES})).setTranslate("gui.recipe.clear"));
        this.testReport = new GuiLabel("report").setTitle((Component)Component.empty());
        bottom.addRight((GuiControl)this.testReport);
        bottom.addRight((GuiControl)new GuiButton("check", x -> ((GuiRecipeTest)this.OPEN_TEST.open(new CompoundTag())).init(this)).setTranslate("gui.recipe.test"));
        bottom.addRight((GuiControl)new GuiButton("save", x -> {
            if (this.runTest().success()) {
                this.SAVE.send((Tag)LittleGroup.save(this.reconstructBlueprint()));
            }
        }).setTranslate("gui.save"));
        this.tree.selectFirst();
    }

    public void tick() {
        if (!this.isClient()) {
            return;
        }
        super.tick();
        this.animation.tick();
        if (this.storage != null) {
            this.storage.tick();
        }
    }

    public void render(GuiGraphics graphics, Rect controlRect, Rect realRect, double scale, int mouseX, int mouseY) {
        this.storage.renderTick();
        super.render(graphics, controlRect, realRect, scale, mouseX, mouseY);
    }

    public void removeItem(GuiTreeItemStructure item) {
        if (item == null) {
            return;
        }
        item.getParentItem().removeItem((GuiTreeItem)item);
        this.tree.updateTree();
        this.tree.selectFirst();
    }

    public void actionOnAllItems(Consumer<GuiTreeItemStructure> con) {
        for (GuiTreeItem item : this.tree.allItems()) {
            if (!(item instanceof GuiTreeItemStructure)) continue;
            GuiTreeItemStructure s = (GuiTreeItemStructure)item;
            con.accept(s);
        }
    }

    public RecipeTestResults runTest() {
        if (this.tree.selected() != null) {
            ((GuiTreeItemStructure)this.tree.selected()).save();
        }
        RecipeTestResults results = RecipeTest.STANDARD.test(this);
        this.actionOnAllItems(x -> x.clearErrors());
        if (results.success()) {
            this.testReport.setTitle((Component)GuiRecipe.translatable((String)"gui.recipe.test.result.success"));
            ((GuiButton)this.get("check", GuiButton.class)).setTranslate("gui.recipe.test");
        } else {
            for (RecipeTestError error : results) {
                for (GuiTreeItemStructure item : error) {
                    item.addError(error);
                }
            }
            String title = GuiRecipe.translate((String)"gui.recipe.test.result.fail") + " ";
            title = results.errorCount() == 1 ? title + GuiRecipe.translate((String)"gui.recipe.test.error.single") : title + GuiRecipe.translate((String)"gui.recipe.test.error.multiple", (Object[])new Object[]{results.errorCount()});
            this.testReport.setTitle((Component)Component.literal((String)title));
            ((GuiButton)this.get("check", GuiButton.class)).setTranslate("gui.recipe.solve");
        }
        this.actionOnAllItems(x -> {
            x.updateTitle();
            x.updateTooltip();
        });
        this.reflow();
        return results;
    }

    protected LittleGroup reconstructBlueprint(GuiTreeItemStructure item) {
        CompoundTag nbt;
        Consumer<GuiTreeItemStructure> finalizer = LittleStructureGuiRegistry.getFinalizer(item.getStructureType());
        if (finalizer != null) {
            finalizer.accept(item);
        }
        ArrayList<LittleGroup> children = new ArrayList<LittleGroup>();
        for (GuiTreeItem child : item.items()) {
            children.add(this.reconstructBlueprint((GuiTreeItemStructure)child));
        }
        if (item.structure == null) {
            nbt = null;
        } else {
            nbt = new CompoundTag();
            item.structure.save(nbt, this.provider());
        }
        return new LittleGroup(nbt, item.group.copyExceptChildren(), children);
    }

    protected LittleGroup reconstructBlueprint() {
        if (this.tree.root().itemsCount() == 1) {
            return this.reconstructBlueprint((GuiTreeItemStructure)this.tree.root().items().iterator().next());
        }
        ArrayList<LittleGroup> children = new ArrayList<LittleGroup>();
        for (GuiTreeItem child : this.tree.root().items()) {
            children.add(this.reconstructBlueprint((GuiTreeItemStructure)child));
        }
        return new LittleGroup((CompoundTag)null, children);
    }
}

