/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.packet.structure;

import net.minecraft.world.entity.player.Player;
import team.creative.littletiles.common.math.location.StructureLocation;
import team.creative.littletiles.common.packet.structure.StructurePacket;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.type.bed.ILittleBedPlayerExtension;
import team.creative.littletiles.common.structure.type.bed.LittleBed;

public class BedUpdate
extends StructurePacket {
    public int playerID;
    public boolean wakeUp;

    public BedUpdate() {
    }

    public BedUpdate(StructureLocation location, Player player, boolean wakeUp) {
        super(location);
        this.playerID = player.getId();
        this.wakeUp = wakeUp;
    }

    @Override
    public void execute(Player player, LittleStructure structure) {
        Player entity;
        this.requiresClient(player);
        Object object = entity = this.playerID == -1 ? player : player.level().getEntity(this.playerID);
        if (entity instanceof ILittleBedPlayerExtension) {
            ILittleBedPlayerExtension p = (ILittleBedPlayerExtension)entity;
            if (structure instanceof LittleBed) {
                LittleBed bed = (LittleBed)structure;
                if (this.wakeUp) {
                    bed.wakeUp();
                    p.setBed(null);
                } else {
                    bed.setSleepingPlayerClient((Player)p);
                    p.setBed(bed);
                }
            }
        }
    }
}

