/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.placement;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.event.level.BlockEvent;
import org.apache.commons.lang3.mutable.MutableInt;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.action.LittleAction;
import team.creative.littletiles.common.action.exception.AreaProtected;
import team.creative.littletiles.common.action.exception.LittleActionException;
import team.creative.littletiles.common.action.exception.NotAllowedToPlaceException;
import team.creative.littletiles.common.action.exception.TooDenseException;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.element.LittleElement;
import team.creative.littletiles.common.block.little.tile.LittleTile;
import team.creative.littletiles.common.block.little.tile.collection.LittleBlockCollection;
import team.creative.littletiles.common.block.little.tile.collection.LittleCollection;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupAbsolute;
import team.creative.littletiles.common.block.little.tile.group.LittleGroupHolder;
import team.creative.littletiles.common.block.little.tile.parent.IParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.ParentCollection;
import team.creative.littletiles.common.block.little.tile.parent.StructureParentCollection;
import team.creative.littletiles.common.block.mc.BlockTile;
import team.creative.littletiles.common.config.LittlePermissionBuild;
import team.creative.littletiles.common.grid.IGridBased;
import team.creative.littletiles.common.grid.LittleGrid;
import team.creative.littletiles.common.ingredient.LittleIngredient;
import team.creative.littletiles.common.ingredient.LittleIngredients;
import team.creative.littletiles.common.level.LittleUpdateCollector;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.math.box.volume.LittleBoxReturnedVolume;
import team.creative.littletiles.common.math.box.volume.LittleVolumes;
import team.creative.littletiles.common.math.vec.LittleVec;
import team.creative.littletiles.common.placement.PlacementContext;
import team.creative.littletiles.common.placement.PlacementPreview;
import team.creative.littletiles.common.placement.PlacementResult;
import team.creative.littletiles.common.placement.box.LittlePlaceBox;
import team.creative.littletiles.common.structure.LittleStructure;

public class Placement {
    public final Player player;
    public final Level level;
    public final PlacementPreview preview;
    public final LinkedHashMap<BlockPos, PlacementBlock> blocks = new LinkedHashMap();
    public final PlacementStructurePreview origin;
    public final List<PlacementStructurePreview> structures = new ArrayList<PlacementStructurePreview>();
    public final BitSet availableIds = new BitSet();
    public final LittleIngredients removedIngredients;
    public final LittleGroupAbsolute removedTiles;
    public final LittleGroup unplaceableTiles;
    public final List<SoundType> soundsToBePlayed = new ArrayList<SoundType>();
    protected MutableInt affectedBlocks = new MutableInt();
    protected ItemStack stack;
    protected boolean ignoreWorldBoundaries = true;
    protected BiPredicate<IParentCollection, LittleTile> predicate;
    protected boolean playSounds = true;

    public Placement(@Nullable Player player, Level level, PlacementPreview preview) throws LittleActionException {
        this.player = player;
        this.level = level;
        this.preview = preview;
        this.origin = this.createStructureTree(null, preview.previews, null);
        this.removedIngredients = new LittleIngredients();
        this.removedTiles = new LittleGroupAbsolute(preview.position.getPos());
        this.unplaceableTiles = new LittleGroup();
        preview.position.forceSameGrid((IGridBased)preview.previews);
        this.createPreviews(this.origin, preview.position.getVec());
        for (PlacementBlock block : this.blocks.values()) {
            block.convertToSmallest();
        }
    }

    public Placement(Player player, PlacementPreview preview) throws LittleActionException {
        this(player, preview.getLevel((Entity)player), preview);
    }

    public Placement setPlaySounds(boolean sounds) {
        this.playSounds = sounds;
        return this;
    }

    public Placement setIgnoreWorldBoundaries(boolean value) {
        this.ignoreWorldBoundaries = value;
        return this;
    }

    public Placement setPredicate(BiPredicate<IParentCollection, LittleTile> predicate) {
        this.predicate = predicate;
        return this;
    }

    public Placement setStack(ItemStack stack) {
        this.stack = stack;
        return this;
    }

    public void addRemovedIngredient(PlacementBlock block, LittleElement element, LittleBoxReturnedVolume volume) {
        this.removedIngredients.add(LittleIngredient.extract(element, volume.getPercentVolume(block.getGrid())));
    }

    public void addRemovedIngredient(LittleVolumes volumes) {
        if (!volumes.isEmpty()) {
            for (Map.Entry<LittleElement, Integer> entry : volumes.entrySet()) {
                this.removedIngredients.add(LittleIngredient.extract(entry.getKey(), (double)entry.getValue().intValue() * volumes.getGrid().pixelVolume));
            }
        }
    }

    public LittleIngredients overflow() {
        LittleIngredients ingredients = LittleAction.getIngredients((HolderLookup.Provider)this.level.registryAccess(), this.removedTiles);
        ingredients.add(this.removedIngredients);
        return ingredients;
    }

    public boolean canPlace() throws LittleActionException {
        this.affectedBlocks.setValue(0);
        for (BlockPos pos : this.blocks.keySet()) {
            if (LittleAction.isAllowedToInteract((LevelAccessor)this.level, this.player, pos, true, Facing.EAST)) continue;
            LittleAction.sendBlockResetToClient((LevelAccessor)this.level, this.player, pos);
            return false;
        }
        List<BlockPos> coordsToCheck = this.preview.mode.getCoordsToCheck(this.blocks.keySet(), this.preview.position.getPos());
        if (coordsToCheck != null) {
            for (BlockPos pos : coordsToCheck) {
                PlacementBlock block = this.blocks.get(pos);
                if (block == null || block.canPlace()) continue;
                return false;
            }
        }
        return true;
    }

    public PlacementResult place() throws LittleActionException {
        if (this.blocks.isEmpty()) {
            return null;
        }
        if (this.player != null && !this.level.isClientSide) {
            if (this.player != null) {
                LittlePermissionBuild config = (LittlePermissionBuild)LittleTiles.CONFIG.build.get(this.player);
                if (LittleTiles.CONFIG.isPlaceLimited(this.player) && this.preview.previews.getVolumeIncludingChildren() > (double)((Integer)config.placeBlockLimit.value).intValue()) {
                    for (BlockPos blockPos : this.blocks.keySet()) {
                        LittleAction.sendBlockResetToClient((LevelAccessor)this.level, this.player, blockPos);
                    }
                    throw new NotAllowedToPlaceException(this.player, config);
                }
                if (LittleTiles.CONFIG.isTransparencyRestricted(this.player)) {
                    for (LittleTile littleTile : this.preview.previews.allTiles()) {
                        try {
                            LittleAction.isAllowedToPlacePreview(this.player, littleTile);
                        }
                        catch (LittleActionException e) {
                            for (BlockPos pos : this.blocks.keySet()) {
                                LittleAction.sendBlockResetToClient((LevelAccessor)this.level, this.player, pos);
                            }
                            throw e;
                        }
                    }
                }
            }
            this.affectedBlocks.setValue(0);
            boolean cancelled = false;
            BlockState against = this.level.getBlockState(this.preview.position.facing == null ? this.preview.position.getPos() : this.preview.position.getPos().relative(this.preview.position.facing.toVanilla()));
            for (BlockPos snapPos : this.blocks.keySet()) {
                if (!((BlockEvent.EntityPlaceEvent)NeoForge.EVENT_BUS.post((Event)new BlockEvent.EntityPlaceEvent(BlockSnapshot.create((ResourceKey)this.level.dimension(), (LevelAccessor)this.level, (BlockPos)snapPos), against, (Entity)this.player))).isCanceled()) continue;
                cancelled = true;
                break;
            }
            if (cancelled) {
                for (BlockPos snapPos : this.blocks.keySet()) {
                    LittleAction.sendBlockResetToClient((LevelAccessor)this.level, this.player, snapPos);
                }
                throw new AreaProtected();
            }
        }
        try {
            if (this.canPlace()) {
                return this.placeTiles();
            }
        }
        catch (LittleActionException e) {
            for (BlockPos blockPos : this.blocks.keySet()) {
                LittleAction.sendBlockResetToClient((LevelAccessor)this.level, this.player, blockPos);
            }
            throw e;
        }
        return null;
    }

    public PlacementResult tryPlace() {
        try {
            return this.place();
        }
        catch (LittleActionException e) {
            return null;
        }
    }

    protected PlacementResult placeTiles() throws LittleActionException {
        PlacementResult result = new PlacementResult(this.preview.position.getPos());
        for (PlacementBlock block : this.blocks.values()) {
            block.place(result);
        }
        result.parentStructure = this.origin.isStructure() ? this.origin.getStructure() : null;
        LittleUpdateCollector neighbor = new LittleUpdateCollector(this.level, this.blocks.keySet());
        Iterator<Object> iterator = this.blocks.values().iterator();
        while (iterator.hasNext()) {
            PlacementBlock block = iterator.next();
            if (!block.combineTilesSecretly()) continue;
            result.blocks.remove(block.cached);
            iterator.remove();
        }
        this.origin.place();
        if (this.origin.isStructure()) {
            if (this.origin.getStructure() == null) {
                throw new LittleActionException("Missing missing mainblock of structure. Placed " + result.placedPreviews.size() + " tile(s).");
            }
            this.notifyStructurePlaced();
        }
        this.constructStructureRelations();
        for (PlacementStructurePreview preview : this.structures) {
            if (!preview.isStructure()) continue;
            preview.getStructure().afterPlaced();
        }
        neighbor.process();
        if (this.playSounds) {
            for (int i = 0; i < this.soundsToBePlayed.size(); ++i) {
                this.level.playSound(null, this.preview.position.getPos(), this.soundsToBePlayed.get(i).getPlaceSound(), SoundSource.BLOCKS, (this.soundsToBePlayed.get(i).getVolume() + 1.0f) / 2.0f, this.soundsToBePlayed.get(i).getPitch() * 0.8f);
            }
        }
        this.removedTiles.convertToSmallest();
        this.unplaceableTiles.convertToSmallest();
        for (PlacementStructurePreview preview : this.structures) {
            if (!preview.isStructure()) continue;
            preview.getStructure().finishedPlacement(this);
        }
        return result;
    }

    public void notifyStructurePlaced() {
        this.origin.getStructure().placedStructure(this.stack);
    }

    public void constructStructureRelations() {
        this.updateRelations(this.origin);
    }

    private void updateRelations(PlacementStructurePreview preview) {
        for (int i = 0; i < preview.children.size(); ++i) {
            PlacementStructurePreview child = preview.children.get(i);
            if (preview.isStructure() && child.isStructure()) {
                preview.getStructure().children.connectToChild(i, child.getStructure());
                child.getStructure().children.connectToParentAsChild(i, preview.getStructure());
            }
            this.updateRelations(child);
        }
        for (Map.Entry<String, PlacementStructurePreview> pair : preview.extensions.entrySet()) {
            if (preview.isStructure() && pair.getValue().isStructure()) {
                preview.getStructure().children.connectToExtension(pair.getValue().extension, pair.getValue().getStructure());
                pair.getValue().getStructure().children.connectToParentAsExtension(preview.getStructure());
            }
            this.updateRelations(pair.getValue());
        }
    }

    public PlacementBlock getOrCreateBlock(BlockPos pos) {
        PlacementBlock block = this.blocks.get(pos);
        if (block == null) {
            block = new PlacementBlock(pos, this.preview.previews.getGrid());
            this.blocks.put(pos, block);
        }
        return block;
    }

    private PlacementStructurePreview createStructureTree(PlacementStructurePreview parent, LittleGroup previews, String extension) {
        PlacementStructurePreview structure = new PlacementStructurePreview(parent, previews, extension);
        for (LittleGroup littleGroup : previews.children.children()) {
            structure.addChild(this.createStructureTree(structure, littleGroup, null));
        }
        for (Map.Entry entry : previews.children.extensionEntries()) {
            structure.addExtension((String)entry.getKey(), this.createStructureTree(structure, (LittleGroup)entry.getValue(), (String)entry.getKey()));
        }
        return structure;
    }

    private void createPreviews(PlacementStructurePreview current, LittleVec inBlockOffset) {
        if (current.previews != null) {
            LittleBlockCollection collection = new LittleBlockCollection(this.preview.position.getPos(), this.preview.previews.getGrid());
            collection.add(current.previews, inBlockOffset);
            for (Map.Entry<BlockPos, LittleCollection> entry : collection.entrySet()) {
                this.getOrCreateBlock(entry.getKey()).addPlacePreviews(current, current.index, entry.getValue());
            }
        }
        for (PlacementStructurePreview child : current.children) {
            this.createPreviews(child, inBlockOffset);
        }
    }

    public class PlacementStructurePreview {
        private LittleStructure cachedStructure;
        public final LittleGroup previews;
        public final PlacementStructurePreview parent;
        public final int index;
        public final String extension;
        private int structureIndex = -1;
        List<PlacementStructurePreview> children = new ArrayList<PlacementStructurePreview>();
        HashMap<String, PlacementStructurePreview> extensions = new HashMap();

        public PlacementStructurePreview(PlacementStructurePreview parent, LittleGroup previews, String extension) {
            this.index = Placement.this.structures.size();
            Placement.this.structures.add(this);
            this.extension = extension;
            this.parent = parent;
            this.previews = previews;
            if (previews instanceof LittleGroupHolder) {
                this.cachedStructure = ((LittleGroupHolder)previews).structure;
            }
        }

        public int getAttribute() {
            return this.previews.getStructureType().attribute;
        }

        public int getIndex() {
            if (this.structureIndex == -1) {
                this.structureIndex = Placement.this.availableIds.nextClearBit(0);
                Placement.this.availableIds.set(this.structureIndex);
            }
            return this.structureIndex;
        }

        public boolean isStructure() {
            return this.previews.hasStructure();
        }

        public void addChild(PlacementStructurePreview child) {
            this.children.add(child);
        }

        public void addExtension(String key, PlacementStructurePreview child) {
            this.extensions.put(key, child);
        }

        public void place(StructureParentCollection parent, HolderLookup.Provider provider) {
            if (this.cachedStructure == null) {
                this.cachedStructure = parent.setStructureNBT(this.previews.getStructureTag(), provider);
                this.cachedStructure.children.initAfterPlacing(this.children.size());
            } else {
                StructureParentCollection.setRelativePos(parent, this.cachedStructure.mainBlock.getPos().subtract((Vec3i)parent.getPos()));
                this.cachedStructure.addBlock(parent);
            }
        }

        public void place() throws LittleActionException {
            if (this.isStructure()) {
                for (LittlePlaceBox box : this.previews.getSpecialBoxes()) {
                    box.add(Placement.this.preview.position.getVec());
                    box.place(Placement.this, this.previews.getGrid(), Placement.this.preview.position.getPos(), this.getStructure());
                }
            }
            for (PlacementStructurePreview preview : this.children) {
                preview.place();
            }
        }

        public boolean isPlaced() {
            return this.isStructure() && this.cachedStructure != null;
        }

        public LittleStructure getStructure() {
            return this.cachedStructure;
        }
    }

    public class PlacementBlock
    implements IGridBased {
        public final BlockPos pos;
        private BETiles cached;
        private LittleGrid grid;
        private final LittleCollection[] tiles;
        private int attribute = 0;
        private boolean requiresCollisionTest;

        public PlacementBlock(BlockPos pos, LittleGrid grid) {
            this.pos = pos;
            this.grid = grid;
            this.tiles = new LittleCollection[Placement.this.structures.size()];
            BlockEntity blockEntity = Placement.this.level.getBlockEntity(pos);
            if (blockEntity instanceof BETiles) {
                BETiles b;
                this.cached = b = (BETiles)blockEntity;
                this.cached.fillUsedIds(Placement.this.availableIds);
            }
        }

        @Override
        public LittleGrid getGrid() {
            return this.grid;
        }

        public void addPlacePreviews(PlacementStructurePreview structure, int index, LittleCollection previews) {
            LittleCollection list = this.tiles[index];
            if (list == null) {
                this.tiles[index] = previews;
            } else {
                list.addAll(previews);
            }
            if (structure.isStructure()) {
                this.attribute |= structure.getAttribute();
            }
        }

        @Override
        public void convertTo(LittleGrid to) {
            for (int i = 0; i < this.tiles.length; ++i) {
                if (this.tiles[i] == null) continue;
                for (LittleTile preview : this.tiles[i]) {
                    preview.convertTo(this.grid, to);
                }
            }
            this.grid = to;
        }

        @Override
        public int getSmallest() {
            int size = LittleGrid.MIN.count;
            for (int i = 0; i < this.tiles.length; ++i) {
                if (this.tiles[i] == null) continue;
                for (LittleTile preview : this.tiles[i]) {
                    size = Math.max(size, preview.getSmallest(this.grid));
                }
            }
            return size;
        }

        private boolean needsCollisionTest() {
            for (int i = 0; i < this.tiles.length; ++i) {
                if (this.tiles[i] == null || this.tiles[i].isEmpty()) continue;
                return true;
            }
            return false;
        }

        public boolean canPlace() throws LittleActionException {
            if (!this.needsCollisionTest()) {
                return true;
            }
            if (!(Placement.this.ignoreWorldBoundaries || this.pos.getY() >= 0 && this.pos.getY() < 256)) {
                return false;
            }
            BETiles te = LittleAction.loadBE(Placement.this.player, Placement.this.level, this.pos, null, false, this.attribute);
            if (te != null) {
                int size = te.tilesCount();
                for (int i = 0; i < this.tiles.length; ++i) {
                    if (this.tiles[i] == null) continue;
                    size += this.tiles[i].size();
                }
                if (size > LittleTiles.CONFIG.general.maxAllowedDensity) {
                    throw new TooDenseException();
                }
                if (!((Boolean)te.sameGrid(this, () -> {
                    for (int i = 0; i < this.tiles.length; ++i) {
                        if (this.tiles[i] == null) continue;
                        for (LittleTile tile : this.tiles[i]) {
                            for (LittleBox box : tile) {
                                if (!(Placement.this.preview.mode.checkAll() ? !te.isSpaceFor(box, Placement.this.predicate) : !te.isSpaceFor(box, (x, y) -> x.isStructure() && (Placement.this.predicate == null || Placement.this.predicate.test((IParentCollection)x, (LittleTile)y))))) continue;
                                return false;
                            }
                        }
                    }
                    return true;
                })).booleanValue()) {
                    return false;
                }
                this.cached = te;
                return true;
            }
            int size = 0;
            for (int i = 0; i < this.tiles.length; ++i) {
                if (this.tiles[i] == null) continue;
                size += this.tiles[i].size();
            }
            if (size > LittleTiles.CONFIG.general.maxAllowedDensity) {
                throw new TooDenseException();
            }
            BlockState state = Placement.this.level.getBlockState(this.pos);
            if (state.is(BlockTags.REPLACEABLE)) {
                return true;
            }
            return !Placement.this.preview.mode.checkAll() && LittleAction.isBlockValid(state) && LittleAction.canConvertBlock(Placement.this.player, Placement.this.level, this.pos, state, Placement.this.affectedBlocks.incrementAndGet());
        }

        public boolean combineTilesSecretly() {
            if (this.cached == null) {
                return false;
            }
            boolean hasPlacedNoneTiles = false;
            if (this.hasStructure()) {
                for (int i = 0; i < this.tiles.length; ++i) {
                    if (this.tiles[i] == null) continue;
                    if (Placement.this.structures.get(i).isStructure()) {
                        this.cached.combineStructureTilesSecretly(Placement.this.structures.get(i).getIndex());
                        continue;
                    }
                    hasPlacedNoneTiles = true;
                }
                if (hasPlacedNoneTiles) {
                    this.cached.combineNoneTilesSecretly(this.requiresCollisionTest);
                }
                return false;
            }
            this.cached.combineNoneTilesSecretly(this.requiresCollisionTest);
            return this.cached.tilesCount() == 1 && this.cached.convertBlockToVanilla();
        }

        public boolean hasStructure() {
            for (int i = 0; i < this.tiles.length; ++i) {
                if (this.tiles[i] == null || !Placement.this.structures.get(i).isStructure()) continue;
                return true;
            }
            return false;
        }

        public void place(PlacementResult result) throws LittleActionException {
            boolean hascollideBlock = false;
            for (int i = 0; i < this.tiles.length; ++i) {
                if (this.tiles[i] == null) continue;
                hascollideBlock = true;
                break;
            }
            if (hascollideBlock) {
                this.requiresCollisionTest = true;
                if (this.cached == null) {
                    if (!(Placement.this.level.getBlockState(this.pos).getBlock() instanceof BlockTile) && Placement.this.level.getBlockState(this.pos).is(BlockTags.REPLACEABLE)) {
                        this.requiresCollisionTest = false;
                        LittleAction.setBlockPreventPredict(Placement.this.level, this.pos, BlockTile.getStateByAttribute(Placement.this.level, this.pos, this.attribute), 0);
                    }
                    this.cached = LittleAction.loadBE(Placement.this.player, Placement.this.level, this.pos, Placement.this.affectedBlocks, Placement.this.preview.mode.shouldConvertBlock(), this.attribute);
                } else {
                    this.cached = this.cached.forceSupportAttribute(this.attribute);
                }
                if (this.cached != null) {
                    int size = this.cached.tilesCount();
                    for (int i = 0; i < this.tiles.length; ++i) {
                        if (this.tiles[i] == null) continue;
                        size += this.tiles[i].size();
                    }
                    if (size > LittleTiles.CONFIG.general.maxAllowedDensity) {
                        throw new TooDenseException();
                    }
                    if (this.cached.isEmpty()) {
                        this.requiresCollisionTest = false;
                    }
                    PlacementContext context = new PlacementContext(Placement.this, this, result, this.requiresCollisionTest);
                    try {
                        this.cached.sameGrid(this, () -> this.cached.updateTilesSecretly(x -> {
                            for (int i = 0; i < this.tiles.length; ++i) {
                                if (this.tiles[i] == null || this.tiles[i].isEmpty()) continue;
                                ParentCollection parent = x.noneStructureTiles();
                                PlacementStructurePreview structure = Placement.this.structures.get(i);
                                if (structure.isStructure()) {
                                    StructureParentCollection list = x.addStructure(structure.getIndex(), structure.getAttribute());
                                    structure.place(list, (HolderLookup.Provider)Placement.this.level.registryAccess());
                                    parent = list;
                                }
                                context.setParent(parent);
                                Placement.this.preview.mode.prepareBlock(context);
                                for (LittleTile tile : this.tiles[i]) {
                                    try {
                                        if (!Placement.this.preview.mode.placeTile(context, structure.getStructure(), tile) || !Placement.this.playSounds || Placement.this.soundsToBePlayed.contains(tile.getSound())) continue;
                                        Placement.this.soundsToBePlayed.add(tile.getSound());
                                    }
                                    catch (LittleActionException e) {
                                        LittleTiles.LOGGER.catching((Throwable)e);
                                        throw new RuntimeException(e);
                                    }
                                }
                            }
                        }));
                    }
                    catch (RuntimeException e) {
                        if (e.getCause() instanceof LittleActionException) {
                            LittleTiles.LOGGER.catching((Throwable)e);
                            throw (LittleActionException)e.getCause();
                        }
                        throw e;
                    }
                }
            }
        }

        public BETiles getBE() {
            return this.cached;
        }
    }
}

